/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing;

import io.scanbot.sdk.docprocessing.ProcessorMonitor;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/docprocessing/DocumentProcessorMonitor;", "Lio/scanbot/sdk/docprocessing/ProcessorMonitor;", "Lio/scanbot/sdk/entity/Document;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;)V", "onProcessed", "", "objectToProcess", "sdk-docprocessing_release"})
public final class DocumentProcessorMonitor
implements ProcessorMonitor<Document> {
    private final DocumentStoreStrategy documentStoreStrategy;

    @Override
    public void onProcessed(@NotNull Document objectToProcess) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)objectToProcess, (String)"objectToProcess");
        String docId = objectToProcess.id;
        File documentFile = this.documentStoreStrategy.getDocumentFile(docId, objectToProcess.name);
        File thumbnailFile = this.documentStoreStrategy.getThumbnailFile(docId);
        objectToProcess.size = documentFile.length();
        File file = thumbnailFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"thumbnailFile");
        objectToProcess.thumbnailUri = file.getPath();
    }

    public DocumentProcessorMonitor(@NotNull DocumentStoreStrategy documentStoreStrategy) {
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        this.documentStoreStrategy = documentStoreStrategy;
    }
}

