/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.draft;

import android.content.SharedPreferences;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.entity.SnappingDraft;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/docprocessing/draft/CombinedDocumentDraftExtractor;", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "sharedPreferences", "Landroid/content/SharedPreferences;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Landroid/content/SharedPreferences;)V", "createDocument", "Lio/scanbot/sdk/entity/Document;", "name", "", "size", "", "extract", "", "Lio/scanbot/sdk/entity/DocumentDraft;", "draft", "Lio/scanbot/sdk/entity/SnappingDraft;", "(Lio/scanbot/sdk/entity/SnappingDraft;)[Lio/scanbot/sdk/entity/DocumentDraft;", "sdk-docprocessing_release"})
public final class CombinedDocumentDraftExtractor
implements DocumentDraftExtractor {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final SharedPreferences sharedPreferences;

    @Override
    @NotNull
    public DocumentDraft[] extract(@NotNull SnappingDraft draft) {
        Intrinsics.checkParameterIsNotNull((Object)draft, (String)"draft");
        boolean singleAsJpeg = this.sharedPreferences.getBoolean("SAVE_SINGLE_AS_JPEG", false);
        String extension = singleAsJpeg && draft.size() == 1 ? ".jpg" : ".pdf";
        String string = this.documentStoreStrategy.getUniqueName(Intrinsics.stringPlus((String)draft.documentName, (Object)extension));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"documentStoreStrategy.ge\u2026documentName + extension)");
        Document document = this.createDocument(string, draft.size());
        return new DocumentDraft[]{new DocumentDraft(document, draft.getPages(), null, 4, null)};
    }

    private final Document createDocument(String name, int size) {
        Document document = new Document();
        boolean bl = false;
        boolean bl2 = false;
        Document $this$apply = document;
        boolean bl3 = false;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        $this$apply.id = string;
        $this$apply.name = name;
        $this$apply.pagesCount = size;
        $this$apply.ocrStatus = OcrStatus.NOT_SCHEDULED;
        return document;
    }

    public CombinedDocumentDraftExtractor(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)sharedPreferences, (String)"sharedPreferences");
        this.documentStoreStrategy = documentStoreStrategy;
        this.sharedPreferences = sharedPreferences;
    }
}

