/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing;

import io.scanbot.sdk.docprocessing.DocumentProcessingResult;
import io.scanbot.sdk.docprocessing.DocumentProcessor;
import io.scanbot.sdk.docprocessing.ProcessorMonitor;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerFactory;
import io.scanbot.sdk.docprocessing.compose.PdfConfig;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.util.bitmap.BitmapLruCache;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/docprocessing/DefaultDocumentProcessor;", "Lio/scanbot/sdk/docprocessing/DocumentProcessor;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "bitmapLruCache", "Lio/scanbot/sdk/util/bitmap/BitmapLruCache;", "composerFactory", "Lio/scanbot/sdk/docprocessing/compose/ComposerFactory;", "documentProcessorMonitor", "Lio/scanbot/sdk/docprocessing/ProcessorMonitor;", "Lio/scanbot/sdk/entity/Document;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/util/bitmap/BitmapLruCache;Lio/scanbot/sdk/docprocessing/compose/ComposerFactory;Lio/scanbot/sdk/docprocessing/ProcessorMonitor;)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "performProcessing", "", "document", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "pdfSize", "Lio/scanbot/sdk/process/PDFPageSize;", "processDocument", "Lio/scanbot/sdk/docprocessing/DocumentProcessingResult;", "documentDraft", "Lio/scanbot/sdk/entity/DocumentDraft;", "sdk-docprocessing_release"})
public final class DefaultDocumentProcessor
implements DocumentProcessor {
    private final Logger logger;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final BitmapLruCache bitmapLruCache;
    private final ComposerFactory composerFactory;
    private final ProcessorMonitor<Document> documentProcessorMonitor;

    @Override
    @Nullable
    public DocumentProcessingResult processDocument(@NotNull DocumentDraft documentDraft) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)documentDraft, (String)"documentDraft");
        Document document = documentDraft.document;
        this.performProcessing(document, documentDraft.pages, documentDraft.pageSize);
        this.documentProcessorMonitor.onProcessed(document);
        this.bitmapLruCache.evictAll();
        List list = documentDraft.pages;
        File file = this.documentStoreStrategy.getDocumentFile(document.id, document.name);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"documentStoreStrategy.ge\u2026cument.id, document.name)");
        return new DocumentProcessingResult(document, list, file);
    }

    private final void performProcessing(Document document, List<Page> pages, PDFPageSize pdfSize) throws IOException {
        this.documentStoreStrategy.ensureDocumentDirectory(document.id);
        Composer composer = this.composerFactory.composerForDocument(document);
        this.logger.d("Processing", '(' + document.name + ") Using composer: " + composer.getClass().getSimpleName());
        composer.composeDocument(document, pages, new PdfConfig(pdfSize));
    }

    public DefaultDocumentProcessor(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BitmapLruCache bitmapLruCache, @NotNull ComposerFactory composerFactory, @NotNull ProcessorMonitor<Document> documentProcessorMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)bitmapLruCache, (String)"bitmapLruCache");
        Intrinsics.checkParameterIsNotNull((Object)composerFactory, (String)"composerFactory");
        Intrinsics.checkParameterIsNotNull(documentProcessorMonitor, (String)"documentProcessorMonitor");
        this.documentStoreStrategy = documentStoreStrategy;
        this.bitmapLruCache = bitmapLruCache;
        this.composerFactory = composerFactory;
        this.documentProcessorMonitor = documentProcessorMonitor;
        this.logger = LoggerProvider.getLogger();
    }
}

