/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.generictext;

import android.graphics.Rect;
import io.scanbot.generictext.NativeGenericTextCleanerCallback;
import io.scanbot.generictext.NativeGenericTextRecognizer;
import io.scanbot.generictext.NativeGenericTextRecognizerConfig;
import io.scanbot.generictext.NativeGenericTextValidationCallback;
import io.scanbot.generictext.NativeTextRecognitionResult;
import io.scanbot.generictext.NativeTextWordBox;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.generictext.DefaultGenericTextRecognizer;
import io.scanbot.sdk.generictext.GenericTextRecognitionResult;
import io.scanbot.sdk.generictext.GenericTextRecognizer;
import io.scanbot.sdk.generictext.GenericTextWordBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010+\u001a\u00020,H\u0016J4\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u00020\u00172\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0012\u00106\u001a\u00020,2\b\u00107\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u00108\u001a\u00020,2\b\u00109\u001a\u0004\u0018\u00010&2\b\u00107\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010:\u001a\u00020,H\u0002R0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0011@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0017@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0017@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0017@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001a\"\u0004\b$\u0010\u001cR\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010(\u001a\b\u0012\u0004\u0012\u00020'0\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020'0\u0006@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\n\"\u0004\b*\u0010\f\u00a8\u0006;"}, d2={"Lio/scanbot/sdk/generictext/DefaultGenericTextRecognizer;", "Lio/scanbot/sdk/generictext/GenericTextRecognizer;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "value", "", "", "allowedSymbols", "getAllowedSymbols", "()Ljava/util/Set;", "setAllowedSymbols", "(Ljava/util/Set;)V", "callbackCleaner", "Lio/scanbot/sdk/generictext/GenericTextRecognizer$CleanRecognitionResultCallback;", "callbackValidator", "Lio/scanbot/sdk/generictext/GenericTextRecognizer$GenericTextValidationCallback;", "", "matchSubstringForPattern", "getMatchSubstringForPattern", "()Z", "setMatchSubstringForPattern", "(Z)V", "", "maximumNumberOfAccumulatedFrames", "getMaximumNumberOfAccumulatedFrames", "()I", "setMaximumNumberOfAccumulatedFrames", "(I)V", "minimumNumberOfRequiredFramesWithEqualRecognitionResult", "getMinimumNumberOfRequiredFramesWithEqualRecognitionResult", "setMinimumNumberOfRequiredFramesWithEqualRecognitionResult", "nativeGenericTextRecognizer", "Lio/scanbot/generictext/NativeGenericTextRecognizer;", "ocrResolutionLimit", "getOcrResolutionLimit", "setOcrResolutionLimit", "simpleValidator", "", "Lio/scanbot/sdk/entity/Language;", "supportedLanguages", "getSupportedLanguages", "setSupportedLanguages", "cleanRecognitionQueue", "", "scanNv21", "Lio/scanbot/sdk/generictext/GenericTextRecognitionResult;", "nv21", "", "width", "height", "orientation", "finderRect", "Landroid/graphics/Rect;", "setCleaner", "callback", "setValidator", "validator", "updateConfig", "sdk-generictext_release"})
public final class DefaultGenericTextRecognizer
implements GenericTextRecognizer {
    private NativeGenericTextRecognizer nativeGenericTextRecognizer;
    private int minimumNumberOfRequiredFramesWithEqualRecognitionResult;
    private int maximumNumberOfAccumulatedFrames;
    private int ocrResolutionLimit;
    @NotNull
    private Set<? extends Language> supportedLanguages;
    @NotNull
    private Set<Character> allowedSymbols;
    private boolean matchSubstringForPattern;
    private String simpleValidator;
    private GenericTextRecognizer.GenericTextValidationCallback callbackValidator;
    private GenericTextRecognizer.CleanRecognitionResultCallback callbackCleaner;

    @Override
    public int getMinimumNumberOfRequiredFramesWithEqualRecognitionResult() {
        return this.minimumNumberOfRequiredFramesWithEqualRecognitionResult;
    }

    @Override
    public void setMinimumNumberOfRequiredFramesWithEqualRecognitionResult(int value) {
        this.minimumNumberOfRequiredFramesWithEqualRecognitionResult = value;
        this.updateConfig();
    }

    @Override
    public int getMaximumNumberOfAccumulatedFrames() {
        return this.maximumNumberOfAccumulatedFrames;
    }

    @Override
    public void setMaximumNumberOfAccumulatedFrames(int value) {
        this.maximumNumberOfAccumulatedFrames = value;
        this.updateConfig();
    }

    @Override
    public int getOcrResolutionLimit() {
        return this.ocrResolutionLimit;
    }

    @Override
    public void setOcrResolutionLimit(int value) {
        this.ocrResolutionLimit = value;
        this.updateConfig();
    }

    @Override
    @NotNull
    public Set<Language> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @Override
    public void setSupportedLanguages(@NotNull Set<? extends Language> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.supportedLanguages = value;
        this.updateConfig();
    }

    @Override
    @NotNull
    public Set<Character> getAllowedSymbols() {
        return this.allowedSymbols;
    }

    @Override
    public void setAllowedSymbols(@NotNull Set<Character> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.allowedSymbols = value;
        this.updateConfig();
    }

    @Override
    public boolean getMatchSubstringForPattern() {
        return this.matchSubstringForPattern;
    }

    @Override
    public void setMatchSubstringForPattern(boolean value) {
        this.matchSubstringForPattern = value;
        this.updateConfig();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public GenericTextRecognitionResult scanNv21(@NotNull byte[] nv21, int width, int height, int orientation, @Nullable Rect finderRect) {
        Intrinsics.checkNotNullParameter((Object)nv21, (String)"nv21");
        NativeTextRecognitionResult result = this.nativeGenericTextRecognizer.scanNv21(nv21, width, height, orientation, finderRect);
        Rect rect = finderRect;
        if (rect == null) {
            rect = new Rect(0, 0, width, height);
        }
        Rect finder = rect;
        NativeTextRecognitionResult nativeTextRecognitionResult = result;
        if (nativeTextRecognitionResult != null) {
            Collection<GenericTextWordBox> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            NativeTextRecognitionResult nativeTextRecognitionResult2 = nativeTextRecognitionResult;
            boolean bl = false;
            boolean bl2 = false;
            NativeTextRecognitionResult it = nativeTextRecognitionResult2;
            boolean bl3 = false;
            Iterable iterable = result.getListOfWords();
            double d = result.getConfidenceValue();
            String string = result.getRawString();
            boolean $i$f$map = false;
            void var20_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                NativeTextWordBox nativeTextWordBox = (NativeTextWordBox)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                Rect rawRect = it2.getRect();
                Rect resultRect = new Rect(rawRect.left + finder.left, rawRect.top + finder.top, rawRect.right + finder.left, rawRect.bottom + finder.top);
                GenericTextWordBox genericTextWordBox = new GenericTextWordBox(it2.getText(), it2.getConfidenceValue(), resultRect);
                collection.add(genericTextWordBox);
            }
            collection = (List)destination$iv$iv;
            boolean bl5 = result.getValidationSuccessful();
            List list = collection;
            double d2 = d;
            String string2 = string;
            return new GenericTextRecognitionResult(string2, d2, list, bl5);
        }
        return null;
    }

    @Override
    public void setValidator(@Nullable String validator, @Nullable GenericTextRecognizer.GenericTextValidationCallback callback) {
        this.simpleValidator = validator;
        this.callbackValidator = callback;
        this.updateConfig();
    }

    @Override
    public void setCleaner(@Nullable GenericTextRecognizer.CleanRecognitionResultCallback callback) {
        this.callbackCleaner = callback;
        this.updateConfig();
    }

    @Override
    public void cleanRecognitionQueue() {
        this.nativeGenericTextRecognizer.cleanRecognitionQueue();
    }

    private final void updateConfig() {
        NativeGenericTextCleanerCallback nativeGenericTextCleanerCallback;
        NativeGenericTextValidationCallback nativeGenericTextValidationCallback;
        NativeGenericTextValidationCallback nativeGenericTextValidationCallback2;
        Object it;
        int n;
        int n2;
        int n3;
        boolean bl;
        String string;
        String string2;
        String string3;
        Object object;
        boolean bl2;
        boolean bl3;
        Object object2;
        int n4 = this.getMinimumNumberOfRequiredFramesWithEqualRecognitionResult();
        int n5 = this.getMaximumNumberOfAccumulatedFrames();
        int n6 = this.getOcrResolutionLimit();
        boolean bl4 = this.getMatchSubstringForPattern();
        String string4 = CollectionsKt.joinToString$default((Iterable)this.getAllowedSymbols(), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        String string5 = this.simpleValidator;
        String string6 = CollectionsKt.joinToString$default((Iterable)this.getSupportedLanguages(), (CharSequence)"+", null, null, (int)0, null, (Function1)updateConfig.config.1.INSTANCE, (int)30, null);
        GenericTextRecognizer.GenericTextValidationCallback genericTextValidationCallback = this.callbackValidator;
        if (genericTextValidationCallback != null) {
            object2 = genericTextValidationCallback;
            bl3 = false;
            bl2 = false;
            object = object2;
            string3 = string6;
            string2 = string5;
            string = string4;
            bl = bl4;
            n3 = n6;
            n2 = n5;
            n = n4;
            boolean bl5 = false;
            nativeGenericTextValidationCallback2 = new NativeGenericTextValidationCallback((GenericTextRecognizer.GenericTextValidationCallback)it){
                final /* synthetic */ GenericTextRecognizer.GenericTextValidationCallback $it;

                public final boolean validate(@NotNull String string) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                    return this.$it.validate(string);
                }
                {
                    this.$it = genericTextValidationCallback;
                }
            };
            n4 = n;
            n5 = n2;
            n6 = n3;
            bl4 = bl;
            string4 = string;
            string5 = string2;
            string6 = string3;
            nativeGenericTextValidationCallback = nativeGenericTextValidationCallback2;
        } else {
            nativeGenericTextValidationCallback = null;
        }
        GenericTextRecognizer.CleanRecognitionResultCallback cleanRecognitionResultCallback = this.callbackCleaner;
        if (cleanRecognitionResultCallback != null) {
            object2 = cleanRecognitionResultCallback;
            bl3 = false;
            bl2 = false;
            it = object2;
            nativeGenericTextValidationCallback2 = nativeGenericTextValidationCallback;
            string3 = string6;
            string2 = string5;
            string = string4;
            bl = bl4;
            n3 = n6;
            n2 = n5;
            n = n4;
            boolean bl6 = false;
            NativeGenericTextCleanerCallback nativeGenericTextCleanerCallback2 = new NativeGenericTextCleanerCallback((GenericTextRecognizer.CleanRecognitionResultCallback)it){
                final /* synthetic */ GenericTextRecognizer.CleanRecognitionResultCallback $it;

                @NotNull
                public final String process(@NotNull String string) {
                    Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                    return this.$it.process(string);
                }
                {
                    this.$it = cleanRecognitionResultCallback;
                }
            };
            n4 = n;
            n5 = n2;
            n6 = n3;
            bl4 = bl;
            string4 = string;
            string5 = string2;
            string6 = string3;
            nativeGenericTextValidationCallback = nativeGenericTextValidationCallback2;
            nativeGenericTextCleanerCallback = nativeGenericTextCleanerCallback2;
        } else {
            nativeGenericTextCleanerCallback = null;
        }
        object2 = nativeGenericTextCleanerCallback;
        NativeGenericTextValidationCallback nativeGenericTextValidationCallback3 = nativeGenericTextValidationCallback;
        String string7 = string6;
        object = string5;
        Object object3 = object2;
        NativeGenericTextValidationCallback nativeGenericTextValidationCallback4 = nativeGenericTextValidationCallback3;
        Object object4 = object;
        String string8 = string7;
        String string9 = string4;
        boolean bl7 = bl4;
        int n7 = n6;
        int n8 = n5;
        int n9 = n4;
        NativeGenericTextRecognizerConfig config2 = new NativeGenericTextRecognizerConfig(n9, n8, n7, bl7, string9, string8, (String)object4, nativeGenericTextValidationCallback4, (NativeGenericTextCleanerCallback)object3);
        this.nativeGenericTextRecognizer.setConfiguration(config2);
    }

    public DefaultGenericTextRecognizer(@NotNull BlobManager blobManager) {
        String tessDataPath;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        this.minimumNumberOfRequiredFramesWithEqualRecognitionResult = 2;
        this.maximumNumberOfAccumulatedFrames = 3;
        this.ocrResolutionLimit = 750;
        this.supportedLanguages = SetsKt.setOf((Object)Language.ENG);
        boolean bl = false;
        this.allowedSymbols = SetsKt.emptySet();
        try {
            String string3 = blobManager.getGenericTextRecognizerModelsFolderFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"blobManager.genericTextR\u2026izerModelsFolderFile.path");
            string2 = string3;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Generic text recognizer trained data is not available.");
        }
        String modelsFolderPath = string2;
        try {
            string = blobManager.getOcrBlobsDirectory().getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("OCR trained data is not available.");
        }
        String string4 = tessDataPath = string;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tessDataPath");
        this.nativeGenericTextRecognizer = new NativeGenericTextRecognizer(modelsFolderPath, string4);
    }
}

