/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.idcardscanner;

import android.graphics.Rect;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.idcardscanner.IdCardScanner;
import io.scanbot.sdk.idcardscanner.IdScanResult;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0002$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0015H\u0002J\u0006\u0010\u001a\u001a\u00020\u0012J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u00062\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0002J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/scanbot/sdk/idcardscanner/IdCardScannerFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "idCardScanner", "Lio/scanbot/sdk/idcardscanner/IdCardScanner;", "(Lio/scanbot/sdk/idcardscanner/IdCardScanner;)V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "resultHandlers", "", "Lio/scanbot/sdk/idcardscanner/IdCardScannerFrameHandler$ResultHandler;", "sapManager", "Lio/scanbot/sap/SapManager;", "addResultHandler", "", "resultHandler", "calculateSquareRect", "Landroid/graphics/Rect;", "width", "", "height", "origRect", "clearResultHandlers", "handleFrame", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/idcardscanner/IdScanResult;", "Lio/scanbot/sdk/SdkLicenseError;", "removeResultHandler", "Companion", "ResultHandler", "sdk-idcard_release"})
public final class IdCardScannerFrameHandler
implements FrameHandler {
    private final Set<ResultHandler> resultHandlers;
    private final SapManager sapManager;
    private final Logger logger;
    private boolean isEnabled;
    private final IdCardScanner idCardScanner;
    public static final Companion Companion = new Companion(null);

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        boolean bl;
        IdScanResult recognitionResult;
        Rect rect;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)previewFrame, (String)"previewFrame");
        this.logger.logMethod();
        if (!this.isEnabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.IdCardScanning).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<IdScanResult, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Failure((Object)new SdkLicenseError())));
            return false;
        }
        Rect rect2 = previewFrame.finderRect;
        if (rect2 != null) {
            Rect rect3 = rect2;
            boolean bl3 = false;
            bl2 = false;
            Rect it = rect3;
            boolean bl4 = false;
            int n = previewFrame.width;
            int n2 = previewFrame.height;
            Rect rect4 = previewFrame.finderRect;
            Intrinsics.checkExpressionValueIsNotNull((Object)rect4, (String)"previewFrame.finderRect");
            rect = this.calculateSquareRect(n, n2, rect4);
        } else {
            rect = null;
        }
        Rect rect5 = rect;
        Intrinsics.checkExpressionValueIsNotNull((Object)previewFrame.frame, (String)"previewFrame.frame");
        IdScanResult idScanResult = recognitionResult = this.idCardScanner.scanNv21(previewFrame.frame, previewFrame.width, previewFrame.height, previewFrame.frameOrientation, rect5, true);
        if (idScanResult != null) {
            IdScanResult idScanResult2 = idScanResult;
            bl2 = false;
            boolean bl5 = false;
            IdScanResult it = idScanResult2;
            boolean bl6 = false;
            bl = this.notifyHandlers((FrameHandlerResult<IdScanResult, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Success((Object)it)));
        } else {
            bl = true;
        }
        return bl;
    }

    private final Rect calculateSquareRect(int width, int height, Rect origRect) {
        int centerX = origRect.centerX();
        int centerY = origRect.centerY();
        boolean bl = false;
        int minSide = Math.min(width, height);
        return new Rect(RangesKt.coerceAtLeast((int)(centerX - minSide / 2), (int)0), RangesKt.coerceAtLeast((int)(centerY - minSide / 2), (int)0), RangesKt.coerceAtMost((int)(centerX + minSide / 2), (int)width), RangesKt.coerceAtMost((int)(centerY + minSide / 2), (int)height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler resultHandler) {
        Intrinsics.checkParameterIsNotNull((Object)resultHandler, (String)"resultHandler");
        Set<ResultHandler> set = this.resultHandlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.resultHandlers.add(resultHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler resultHandler) {
        Intrinsics.checkParameterIsNotNull((Object)resultHandler, (String)"resultHandler");
        Set<ResultHandler> set = this.resultHandlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.resultHandlers.remove(resultHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearResultHandlers() {
        Set<ResultHandler> set = this.resultHandlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            this.resultHandlers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean notifyHandlers(FrameHandlerResult<IdScanResult, SdkLicenseError> result) {
        boolean handled = false;
        Set<ResultHandler> set = this.resultHandlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            for (ResultHandler handler : this.resultHandlers) {
                handled |= handler.handle(result);
            }
            Unit unit = Unit.INSTANCE;
        }
        return handled;
    }

    public IdCardScannerFrameHandler(@NotNull IdCardScanner idCardScanner) {
        Intrinsics.checkParameterIsNotNull((Object)idCardScanner, (String)"idCardScanner");
        this.idCardScanner = idCardScanner;
        this.resultHandlers = new LinkedHashSet();
        this.sapManager = SapSingleton.getInstance();
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/idcardscanner/IdCardScannerFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/idcardscanner/IdScanResult;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-idcard_release"})
    public static interface ResultHandler
    extends BaseResultHandler<IdScanResult, SdkLicenseError> {
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/idcardscanner/IdCardScannerFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/idcardscanner/IdCardScannerFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "idCardScanner", "Lio/scanbot/sdk/idcardscanner/IdCardScanner;", "sdk-idcard_release"})
    public static final class Companion {
        @NotNull
        public final IdCardScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull IdCardScanner idCardScanner) {
            Intrinsics.checkParameterIsNotNull((Object)cameraView, (String)"cameraView");
            Intrinsics.checkParameterIsNotNull((Object)idCardScanner, (String)"idCardScanner");
            IdCardScannerFrameHandler frameHandler = new IdCardScannerFrameHandler(idCardScanner);
            cameraView.addFrameHandler((FrameHandler)frameHandler);
            return frameHandler;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

