/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.idcardscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.scanbot.idcardscanner.NativeIdCardScanner;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.idcardscanner.IdCardResultsMappingKt;
import io.scanbot.sdk.idcardscanner.IdCardScanner;
import io.scanbot.sdk.idcardscanner.IdScanResult;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J)\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ)\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJC\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0019\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R*\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a8\u0016@VX\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/idcardscanner/DefaultIdCardScanner;", "Lio/scanbot/sdk/idcardscanner/IdCardScanner;", "Landroid/graphics/Bitmap;", "bitmap", "", "shouldRecognize", "", "orientation", "Lio/scanbot/sdk/idcardscanner/IdScanResult;", "scanBitmap", "(Landroid/graphics/Bitmap;ZI)Lio/scanbot/sdk/idcardscanner/IdScanResult;", "", "jpeg", "scanJpeg", "([BZI)Lio/scanbot/sdk/idcardscanner/IdScanResult;", "nv21", "width", "height", "Landroid/graphics/Rect;", "finderRect", "scanNv21", "([BIIILandroid/graphics/Rect;Z)Lio/scanbot/sdk/idcardscanner/IdScanResult;", "Lio/scanbot/idcardscanner/NativeIdCardScanner;", "a", "Lio/scanbot/idcardscanner/NativeIdCardScanner;", "nativeIdCardScanner", "", "value", "b", "F", "getAcceptedSharpnessScore", "()F", "setAcceptedSharpnessScore", "(F)V", "acceptedSharpnessScore", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "<init>", "(Lio/scanbot/sdk/blob/BlobManager;)V", "sdk-idcard_release"})
public final class DefaultIdCardScanner
implements IdCardScanner {
    private NativeIdCardScanner a;
    private float b;

    public DefaultIdCardScanner(@NotNull BlobManager object) {
        DefaultIdCardScanner defaultIdCardScanner = string;
        BlobManager blobManager = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"blobManager");
        try {
            String string = blobManager.getIdCardScannerModelsFolderFile().getPath();
        }
        catch (IOException iOException) {
            throw new RuntimeException("IdCard scanner trained data is not available.");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blobManager.idCardScannerModelsFolderFile.path");
        try {
            object = blobManager.getOcrBlobsDirectory().getPath();
        }
        catch (IOException iOException) {
            throw new RuntimeException("OCR trained data is not available.");
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"tessDataPath");
        defaultIdCardScanner.a = new NativeIdCardScanner(string, (String)object);
    }

    @Override
    public float getAcceptedSharpnessScore() {
        return this.b;
    }

    @Override
    public void setAcceptedSharpnessScore(float f) {
        this.b = f;
        this.a.setAcceptedSharpnessScore(f);
    }

    @Override
    @Nullable
    public IdScanResult scanBitmap(@NotNull Bitmap bitmap, boolean bl, int n) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        return IdCardResultsMappingKt.mapIdCardScannerResultJniToSdk(this.a.scanBitmap(bitmap, bl, n));
    }

    @Override
    @Nullable
    public IdScanResult scanJpeg(@NotNull byte[] byArray, boolean bl, int n) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"jpeg");
        return IdCardResultsMappingKt.mapIdCardScannerResultJniToSdk(this.a.scanJpeg(byArray, bl, n));
    }

    @Override
    @Nullable
    public IdScanResult scanNv21(@NotNull byte[] byArray, int n, int n2, int n3, @Nullable Rect rect, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        return IdCardResultsMappingKt.mapIdCardScannerResultJniToSdk(this.a.scanNv21(byArray, n, n2, n3, rect, bl));
    }
}

