/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.graphics.Bitmap;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.process.BlurEstimator;
import io.scanbot.sdk.process.NativeBlurEstimator;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0010H\u0016J(\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/process/DefaultBlurEstimator;", "Lio/scanbot/sdk/process/BlurEstimator;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "blurEstimator", "Lio/scanbot/sdk/process/NativeBlurEstimator;", "getBlurEstimator", "()Lio/scanbot/sdk/process/NativeBlurEstimator;", "setBlurEstimator", "(Lio/scanbot/sdk/process/NativeBlurEstimator;)V", "estimate", "", "nv21", "", "width", "", "height", "orientation", "estimateInBGR", "bgr", "estimateInBitmap", "bitmap", "Landroid/graphics/Bitmap;", "estimateInJPEG", "jpeg", "sdk-imageprocessing_release"})
public final class DefaultBlurEstimator
implements BlurEstimator {
    @NotNull
    private NativeBlurEstimator blurEstimator;

    @NotNull
    public final NativeBlurEstimator getBlurEstimator() {
        return this.blurEstimator;
    }

    public final void setBlurEstimator(@NotNull NativeBlurEstimator nativeBlurEstimator) {
        Intrinsics.checkParameterIsNotNull((Object)nativeBlurEstimator, (String)"<set-?>");
        this.blurEstimator = nativeBlurEstimator;
    }

    @Override
    public float estimate(@NotNull byte[] nv21, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)nv21, (String)"nv21");
        return this.blurEstimator.estimate(nv21, width, height, orientation);
    }

    @Override
    public float estimateInBGR(@NotNull byte[] bgr, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)bgr, (String)"bgr");
        return this.blurEstimator.estimateInBGR(bgr, width, height, orientation);
    }

    @Override
    public float estimateInJPEG(@NotNull byte[] jpeg, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)jpeg, (String)"jpeg");
        return this.blurEstimator.estimateInJPEG(jpeg, width, height, orientation);
    }

    @Override
    public float estimateInBitmap(@NotNull Bitmap bitmap, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        return this.blurEstimator.estimateInBitmap(bitmap, orientation);
    }

    public DefaultBlurEstimator(@NotNull BlobManager blobManager) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        try {
            File file = blobManager.getBlurEstimatorModelFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.blurEstimatorModelFile");
            String string2 = file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"blobManager.blurEstimatorModelFile.path");
            string = string2;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Blur Estimator blob is not available.");
        }
        String traineddataPath = string;
        this.blurEstimator = new NativeBlurEstimator(traineddataPath);
    }
}

