/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.nfcscanner.passport;

import android.nfc.tech.IsoDep;
import androidx.annotation.WorkerThread;
import io.scanbot.core.ScanbotSdkInternal;
import io.scanbot.nfcscanner.passport.InternalPassportNfcScanner;
import io.scanbot.nfcscanner.passport.PassportNfcData;
import io.scanbot.nfcscanner.passport.PassportNfcLoadCallback;
import io.scanbot.nfcscanner.passport.PassportNfcLoadErrorType;
import io.scanbot.sdk.nfcscanner.passport.PassportNfcKey;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/scanbot/sdk/nfcscanner/passport/PassportNfcScanner;", "", "()V", "nfcDateFormat", "Ljava/text/SimpleDateFormat;", "extractData", "", "isoDep", "Landroid/nfc/tech/IsoDep;", "passportNfcKey", "Lio/scanbot/sdk/nfcscanner/passport/PassportNfcKey;", "callback", "Lio/scanbot/nfcscanner/passport/PassportNfcLoadCallback;", "sdk-nfc_release"})
public final class PassportNfcScanner {
    private final SimpleDateFormat nfcDateFormat = new SimpleDateFormat("yyMMdd", Locale.GERMAN);

    @WorkerThread
    public final void extractData(@NotNull IsoDep isoDep, @NotNull PassportNfcKey passportNfcKey, @NotNull PassportNfcLoadCallback callback) {
        Intrinsics.checkNotNullParameter((Object)isoDep, (String)"isoDep");
        Intrinsics.checkNotNullParameter((Object)passportNfcKey, (String)"passportNfcKey");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String passportNumber = passportNfcKey.getDocumentCode();
        String birthdate = this.nfcDateFormat.format(passportNfcKey.getBirthDate());
        String expiryDate = this.nfcDateFormat.format(passportNfcKey.getExpiryDate());
        String string = birthdate;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"birthdate");
        String string2 = expiryDate;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"expiryDate");
        InternalPassportNfcScanner scanner = new InternalPassportNfcScanner(isoDep, passportNumber, string, string2);
        scanner.extractData(new PassportNfcLoadCallback(scanner, callback){
            final /* synthetic */ InternalPassportNfcScanner $scanner;
            final /* synthetic */ PassportNfcLoadCallback $callback;

            public void onSuccess(@NotNull PassportNfcData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$scanner.clean();
                this.$callback.onSuccess(data);
            }

            public void onError(@NotNull PassportNfcLoadErrorType nfcLoadErrorType) {
                Intrinsics.checkNotNullParameter((Object)nfcLoadErrorType, (String)"nfcLoadErrorType");
                this.$scanner.clean();
                this.$callback.onError(nfcLoadErrorType);
            }
            {
                this.$scanner = $captured_local_variable$0;
                this.$callback = $captured_local_variable$1;
            }
        });
    }

    @ScanbotSdkInternal
    public PassportNfcScanner() {
    }
}

