/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.OcrPdfRenderer;
import net.doo.snap.intelligence.OcrSettings;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.OcrPerformer;
import net.doo.snap.process.OcrResult;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class SandwichingPdfOcrPerformer
implements OcrPerformer {
    private final Logger logger = LoggerProvider.getLogger();
    private final Set<Language> languages;
    private final OcrSettings ocrSettings;
    private final Document document;
    private final Page[] pages;
    private final SapManager sapManager;
    private final OcrPdfRenderer pdfRenderer;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final SimpleComposer simpleComposer;

    public SandwichingPdfOcrPerformer(SapManager sapManager, OcrPdfRenderer pdfRenderer, Set<Language> languages, DocumentStoreStrategy documentStoreStrategy, SimpleComposer simpleComposer, OcrSettings config, Document document, List<Page> pages) {
        this.document = document;
        this.pages = pages.toArray(new Page[pages.size()]);
        this.languages = languages;
        this.sapManager = sapManager;
        this.pdfRenderer = pdfRenderer;
        this.documentStoreStrategy = documentStoreStrategy;
        this.simpleComposer = simpleComposer;
        this.ocrSettings = config;
    }

    @Override
    public OcrResult recognize() throws IOException {
        OcrResult ocrResult = new OcrResult(null, null, Collections.emptyList());
        if (!this.sapManager.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return new OcrResult(this.document, null, new ArrayList<OcrResult.OCRPage>());
        }
        long ocrStartedMillis = SystemClock.elapsedRealtime();
        try {
            if (this.languages == null || this.languages.isEmpty()) {
                this.logger.d("OCR", "OCR languages blobs are not available - abort OCR");
                throw new IOException("OCR languages blobs are not available");
            }
            ocrResult = this.createPDF(this.document, this.pages, this.languages);
            StringBuilder recognizedText = new StringBuilder();
            for (OcrResult.OCRPage OCRPage2 : ocrResult.ocrPages) {
                recognizedText.append(OCRPage2.text);
            }
            this.saveMetaData(this.document, recognizedText.toString());
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
            this.simpleComposer.composeDocument(this.document, this.pages);
        }
        this.trackDuration(ocrStartedMillis);
        return ocrResult;
    }

    private void saveMetaData(Document document, String detectedText) {
        document.setOcrStatus(OcrStatus.DONE);
        document.setOcrText(detectedText);
        this.trackDocument(document);
    }

    private void trackDocument(Document document) {
        if (document.getLanguage() != null) {
            this.logger.d("OCR", "Document language assigned: " + document.getLanguage().getIsoCode());
        }
    }

    private OcrResult createPDF(Document document, Page[] pages, Set<Language> availableLanguages) throws IOException {
        OcrResult ocrResult = this.performOCR(document, pages, availableLanguages);
        return ocrResult;
    }

    private OcrResult performOCR(Document document, Page[] pages, Set<Language> availableLanguages) throws IOException {
        this.logger.d("OCR", "Starting OCR with languages: " + availableLanguages.toString());
        OcrResult ocrResult = this.ocrWithAvailableLanguages(document, pages, availableLanguages);
        return ocrResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OcrResult ocrWithAvailableLanguages(Document document, Page[] pages, Set<Language> availableLanguages) throws IOException {
        OcrPdfRenderer.RenderIterator renderIterator = this.pdfRenderer.startRender(document, pages, availableLanguages, this.ocrSettings);
        try {
            ArrayList<OcrResult.OCRPage> ocrPages = new ArrayList<OcrResult.OCRPage>(pages.length);
            while (renderIterator.renderNextPage()) {
                this.logger.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
                ocrPages.add(new OcrResult.OCRPage(renderIterator.getDetectedText(), renderIterator.getDetectedParagraphs(), renderIterator.getDetectedLines(), renderIterator.getDetectedWords()));
            }
            File documentFile = this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
            OcrResult ocrResult = new OcrResult(document, documentFile, ocrPages);
            return ocrResult;
        }
        finally {
            renderIterator.recycle();
        }
    }

    private void trackDuration(long ocrStartedMillis) {
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }
}

