/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.Page;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.OcrPerformer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.OcrResultBlock;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SimpleOcrPerformer
implements OcrPerformer {
    private final Logger logger = LoggerProvider.getLogger();
    private final OcrPdfRenderer.BitmapBinarizer bitmapBinarizer;
    private final Page[] pages;
    private final Set<Language> languages;
    private final SapManager sapManager;
    private final BlobStoreStrategy blobStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private final OcrSettings ocrSettings;

    public SimpleOcrPerformer(SapManager sapManager, Set<Language> languages, BlobStoreStrategy blobStoreStrategy, PageStoreStrategy pageStoreStrategy, OcrSettings ocrSettings, OcrPdfRenderer.BitmapBinarizer bitmapBinarizer, List<Page> pages) {
        this.pages = pages.toArray(new Page[pages.size()]);
        this.sapManager = sapManager;
        this.languages = languages;
        this.blobStoreStrategy = blobStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.ocrSettings = ocrSettings;
        this.bitmapBinarizer = bitmapBinarizer;
    }

    @Override
    public OcrResult recognize() {
        OcrResult ocrResult = new OcrResult(null, null, Collections.emptyList());
        if (!this.sapManager.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return new OcrResult(null, null, new ArrayList<OcrResult.OCRPage>());
        }
        long ocrStartedMillis = SystemClock.elapsedRealtime();
        try {
            ocrResult = this.performTessOCR(this.pages, this.languages);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
        this.trackDuration(ocrStartedMillis);
        return ocrResult;
    }

    private void trackDuration(long ocrStartedMillis) {
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }

    private OcrResult performTessOCR(Page[] pages, Set<Language> availableLanguages) throws IOException {
        this.logger.d("OCR", "Starting OCR with languages: " + availableLanguages.toString());
        OcrResult ocrResult = this.ocrWithAvailableLanguages(pages, availableLanguages);
        return ocrResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OcrResult ocrWithAvailableLanguages(Page[] pages, Set<Language> languages) throws IOException {
        TessBaseAPI tessBaseAPI = this.initTessApi(Language.languageCodes(languages));
        ArrayList<OcrResult.OCRPage> ocrPages = new ArrayList<OcrResult.OCRPage>(pages.length);
        try {
            for (Page page : pages) {
                File pageFile = this.pageToFile(page);
                if (!pageFile.exists()) continue;
                if (this.ocrSettings.getBinarizeImage()) {
                    tessBaseAPI.setImage(this.bitmapBinarizer.binarizeBitmap(BitmapFactory.decodeFile((String)pageFile.getAbsolutePath()), true));
                } else {
                    tessBaseAPI.setImage(pageFile);
                }
                ocrPages.add(new OcrResult.OCRPage(tessBaseAPI.getUTF8Text(), this.getBlocks(tessBaseAPI, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH), this.getBlocks(tessBaseAPI, 2, OcrResultBlock.OcrResultBlockType.LINE), this.getBlocks(tessBaseAPI, 3, OcrResultBlock.OcrResultBlockType.WORD)));
            }
        }
        finally {
            tessBaseAPI.end();
        }
        return new OcrResult(null, null, ocrPages);
    }

    private List<OcrResultBlock> getBlocks(TessBaseAPI tessBaseAPI, int pageIteratorLevel, OcrResultBlock.OcrResultBlockType blockType) {
        ArrayList<OcrResultBlock> blocks = new ArrayList<OcrResultBlock>();
        Pix thresholdedImage = tessBaseAPI.getThresholdedImage();
        ResultIterator resultIterator = tessBaseAPI.getResultIterator();
        resultIterator.begin();
        blocks.add(this.extractBlock(resultIterator, pageIteratorLevel, thresholdedImage, blockType));
        while (resultIterator.next(pageIteratorLevel)) {
            blocks.add(this.extractBlock(resultIterator, pageIteratorLevel, thresholdedImage, blockType));
        }
        return blocks;
    }

    private OcrResultBlock extractBlock(ResultIterator resultIterator, int pageIteratorLevel, Pix thresholdedImage, OcrResultBlock.OcrResultBlockType blockType) {
        String text = resultIterator.getUTF8Text(pageIteratorLevel);
        int[] boundingBoxArray = resultIterator.getBoundingBox(pageIteratorLevel);
        Rect boundingBoxWithImageSize = new Rect();
        RectF boundingBox = new RectF();
        if (boundingBoxArray.length == 4) {
            boundingBoxWithImageSize = new Rect(boundingBoxArray[0], boundingBoxArray[1], boundingBoxArray[2], boundingBoxArray[3]);
            if (thresholdedImage != null) {
                boundingBox = new RectF((float)boundingBoxArray[0] / (float)thresholdedImage.getWidth(), (float)boundingBoxArray[1] / (float)thresholdedImage.getHeight(), (float)boundingBoxArray[2] / (float)thresholdedImage.getWidth(), (float)boundingBoxArray[3] / (float)thresholdedImage.getHeight());
            }
        }
        return new OcrResultBlock(text, boundingBox, boundingBoxWithImageSize, Float.valueOf(resultIterator.confidence(pageIteratorLevel)), blockType);
    }

    private File pageToFile(Page page) throws IOException {
        return this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
    }

    private TessBaseAPI initTessApi(String ... languageCodes) throws IOException {
        TessBaseAPI tessBaseAPI = new TessBaseAPI();
        tessBaseAPI.init(this.blobStoreStrategy.getOCRDataDirectory().toString(), TextUtils.join((CharSequence)"+", (Object[])languageCodes));
        tessBaseAPI.setPageSegMode(1);
        return tessBaseAPI;
    }
}

