/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import io.scanbot.sap.SapManager;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.Page;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.intelligence.SandwichingPdfOcrPerformer;
import io.scanbot.sdk.ocr.intelligence.SimpleOcrPerformer;
import io.scanbot.sdk.ocr.process.TextRecognition;
import io.scanbot.sdk.ocr.process.TextRecognizer;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import java.util.List;
import java.util.Set;

public class TextRecognizerFactory
implements TextRecognition {
    private final SapManager sapManager;
    private final OcrPdfRenderer pdfRenderer;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final SimpleComposer simpleComposer;
    private final BlobStoreStrategy blobStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private final OcrSettings ocrSettings;
    private final OcrPdfRenderer.BitmapBinarizer bitmapBinarizer;

    public TextRecognizerFactory(SapManager sapManager, OcrPdfRenderer pdfRenderer, DocumentStoreStrategy documentStoreStrategy, SimpleComposer simpleComposer, BlobStoreStrategy blobStoreStrategy, PageStoreStrategy pageStoreStrategy, OcrSettings ocrSettings, OcrPdfRenderer.BitmapBinarizer bitmapBinarizer) {
        this.sapManager = sapManager;
        this.pdfRenderer = pdfRenderer;
        this.documentStoreStrategy = documentStoreStrategy;
        this.simpleComposer = simpleComposer;
        this.blobStoreStrategy = blobStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.ocrSettings = ocrSettings;
        this.bitmapBinarizer = bitmapBinarizer;
    }

    @Override
    public TextRecognizer withPDF(Document document, List<Page> pages, Set<Language> languages) {
        return new TextRecognizer(new SandwichingPdfOcrPerformer(this.sapManager, this.pdfRenderer, languages, this.documentStoreStrategy, this.simpleComposer, this.ocrSettings, document, pages));
    }

    @Override
    public TextRecognizer withoutPDF(List<Page> pages, Set<Language> languages) {
        return new TextRecognizer(new SimpleOcrPerformer(this.sapManager, languages, this.blobStoreStrategy, this.pageStoreStrategy, this.ocrSettings, this.bitmapBinarizer, pages));
    }
}

