/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.entity.Page;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Set;

public class OcrComposer
implements Composer {
    private final Logger logger = LoggerProvider.getLogger();
    private final DocumentStoreStrategy documentStoreStrategy;
    private final BlobManager blobManager;
    private final OcrPdfRenderer pdfRenderer;
    private final SimpleComposer simpleComposer;
    private final OcrSettings ocrSettings;
    private final SapManager sapManager;

    public OcrComposer(DocumentStoreStrategy documentStoreStrategy, BlobManager blobManager, OcrPdfRenderer pdfRenderer, SimpleComposer simpleComposer, SapManager sapManager, OcrSettings ocrSettings) {
        this.sapManager = sapManager;
        this.documentStoreStrategy = documentStoreStrategy;
        this.blobManager = blobManager;
        this.pdfRenderer = pdfRenderer;
        this.simpleComposer = simpleComposer;
        this.ocrSettings = ocrSettings;
    }

    public void composeDocument(Document document, Page ... pages) throws IOException {
        if (!this.sapManager.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            long ocrStartedMillis = SystemClock.elapsedRealtime();
            Set availableLanguages = this.blobManager.getAllLanguagesWithAvailableOcrBlobs();
            if (availableLanguages == null || availableLanguages.isEmpty()) {
                this.logger.d("OCR", "OCR languages blobs are not available - abort OCR");
                throw new IOException("OCR languages blobs are not available");
            }
            String detectedText = this.createPDF(document, pages, availableLanguages);
            this.saveMetaData(document, detectedText);
            this.trackDuration(document, ocrStartedMillis);
        }
        catch (IOException e) {
            this.simpleComposer.composeDocument(document, pages);
        }
    }

    private String createPDF(Document document, Page[] pages, Set<Language> availableLanguages) throws IOException {
        return this.performOCR(document, pages, availableLanguages);
    }

    private String performOCR(Document document, Page[] pages, Set<Language> availableLanguages) throws IOException {
        this.logger.d("OCR", "Starting OCR with languages: " + availableLanguages.toString());
        return this.ocrWithDefaultLanguage(document, pages, availableLanguages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String ocrWithDefaultLanguage(Document document, Page[] pages, Set<Language> availableLanguages) throws IOException {
        String detectedText = null;
        OcrPdfRenderer.RenderIterator renderIterator = this.pdfRenderer.startRender(document, pages, availableLanguages, this.ocrSettings);
        try {
            while (renderIterator.renderNextPage()) {
                this.logger.d("OCR", "Page rendered: " + renderIterator.getDetectedText());
            }
            detectedText = renderIterator.getDetectedText();
        }
        finally {
            renderIterator.recycle();
        }
        return detectedText;
    }

    private void saveMetaData(Document document, String detectedText) {
        document.setOcrStatus(OcrStatus.DONE);
        document.setOcrText(detectedText);
        this.trackDocument(document);
    }

    private void trackDuration(Document document, long ocrStartedMillis) {
        if (document.getLanguage() == null) {
            return;
        }
        long ocrDuration = SystemClock.elapsedRealtime() - ocrStartedMillis;
        this.logger.d("OCR", "Ocr total: " + (float)ocrDuration / 1000.0f + " sec");
    }

    private void trackDocument(Document document) {
        if (document.getLanguage() != null) {
            this.logger.d("OCR", "Document language assigned: " + document.getLanguage().getIsoCode());
        }
    }
}

