/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerConfig;
import io.scanbot.sdk.docprocessing.compose.SimpleComposer;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u001f\u001a\u00020\u001d\u0012\u0006\u0010*\u001a\u00020(\u0012\u0006\u0010#\u001a\u00020 \u0012\u0006\u0010'\u001a\u00020$\u0012\u0006\u0010.\u001a\u00020+\u0012\u0006\u00102\u001a\u00020/\u00a2\u0006\u0004\b3\u00104J5\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ5\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\fJ5\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ!\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u001f\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0014J\u0017\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0015J-\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001c\u001a\u00020\u001a8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001bR\u0016\u0010\u001f\u001a\u00020\u001d8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u001eR\u0016\u0010#\u001a\u00020 8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010'\u001a\u00020$8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010*\u001a\u00020(8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010)R\u0016\u0010.\u001a\u00020+8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u00102\u001a\u00020/8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00065"}, d2={"Lio/scanbot/sdk/ocr/process/compose/OcrComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "Lio/scanbot/sdk/entity/Document;", "document", "", "Lio/scanbot/sdk/persistence/Page;", "pages", "", "Lio/scanbot/sdk/entity/Language;", "availableLanguages", "", "a", "(Lio/scanbot/sdk/entity/Document;Ljava/util/List;Ljava/util/Set;)Ljava/lang/String;", "c", "b", "detectedText", "", "(Lio/scanbot/sdk/entity/Document;Ljava/lang/String;)V", "", "ocrStartedMillis", "(Lio/scanbot/sdk/entity/Document;J)V", "(Lio/scanbot/sdk/entity/Document;)V", "Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;", "config", "composeDocument", "(Lio/scanbot/sdk/entity/Document;Ljava/util/List;Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;)V", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "documentStoreStrategy", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "d", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;", "pdfRenderer", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "e", "Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "simpleComposer", "Lio/scanbot/sdk/blob/BlobManager;", "Lio/scanbot/sdk/blob/BlobManager;", "blobManager", "Lio/scanbot/sap/SapManager;", "f", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "g", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "<init>", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/blob/BlobManager;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer;Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;Lio/scanbot/sap/SapManager;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;)V", "sdk-ocr_release"})
public final class OcrComposer
implements Composer {
    private final Logger a;
    private final DocumentStoreStrategy b;
    private final BlobManager c;
    private final OcrPdfRenderer d;
    private final SimpleComposer e;
    private final SapManager f;
    private final OcrSettings g;

    private final String a(Document document, List<Page> list, Set<? extends Language> set) throws IOException {
        return this.c(document, list, set);
    }

    private final String c(Document document, List<Page> list, Set<? extends Language> set) throws IOException {
        this.a.d("OCR", "Starting OCR with languages: " + set);
        return this.b(document, list, set);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String b(Document object, List<Page> object2, Set<? extends Language> set) throws IOException {
        Object object3 = object2;
        object2 = this.d;
        Page[] pageArray = object3.toArray(new Page[0]);
        if (pageArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object4 = object2;
        Object object5 = object;
        object = pageArray;
        object2 = this.g;
        object = ((OcrPdfRenderer)object4).startRender((Document)object5, (Page[])object, set, (OcrSettings)object2);
        try {
            while (object.renderNextPage()) {
                this.a.d("OCR", "Page rendered: " + object.getDetectedText());
            }
            String string = object.getDetectedText();
            object.recycle();
            return string;
        }
        catch (Throwable throwable) {
            object.recycle();
            throw throwable;
        }
    }

    private final void a(Document document, String string) {
        document.ocrStatus = OcrStatus.DONE;
        document.ocrText = string;
        this.a(document);
    }

    private final void a(Document document, long l) {
        if (document.language == null) {
            return;
        }
        long l2 = SystemClock.elapsedRealtime() - l;
        this.a.d("OCR", "Ocr total: " + (float)l2 / 1000.0f + " sec");
    }

    private final void a(Document object) {
        if (object.language != null) {
            Document document = object;
            OcrComposer ocrComposer = ocrComposer.a;
            object = "OCR";
            StringBuilder stringBuilder = new StringBuilder().append("Document language assigned: ");
            Object object2 = document.language;
            object2 = object2 != null ? object2.getOcrBlobLanguageTag() : null;
            ocrComposer.d((String)object, stringBuilder.append((String)object2).toString());
        }
    }

    public OcrComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull BlobManager blobManager, @NotNull OcrPdfRenderer ocrPdfRenderer, @NotNull SimpleComposer simpleComposer, @NotNull SapManager sapManager, @NotNull OcrSettings ocrSettings) {
        OcrComposer ocrComposer = this;
        Intrinsics.checkNotNullParameter((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        Intrinsics.checkNotNullParameter((Object)ocrPdfRenderer, (String)"pdfRenderer");
        Intrinsics.checkNotNullParameter((Object)simpleComposer, (String)"simpleComposer");
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        this.b = documentStoreStrategy;
        this.c = blobManager;
        this.d = ocrPdfRenderer;
        this.e = simpleComposer;
        this.f = sapManager;
        ocrComposer.g = ocrSettings;
        ocrComposer.a = LoggerProvider.getLogger();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void composeDocument(@NotNull Document document, @NotNull List<Page> list, @NotNull ComposerConfig object) throws IOException {
        Set set;
        long l;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(list, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)object, (String)"config");
        if (!this.f.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return;
        }
        try {
            l = SystemClock.elapsedRealtime();
            set = this.c.getAllLanguagesWithAvailableOcrBlobs();
        }
        catch (IOException iOException) {
            Composer.DefaultImpls.composeDocument$default((Composer)this.e, (Document)document, list, null, (int)4, null);
            return;
        }
        {
            if (!set.isEmpty()) {
                this.a(document, this.a(document, CollectionsKt.toList(list), set));
                this.a(document, l);
                return;
            }
            this.a.d("OCR", "OCR languages blobs are not available - abort OCR");
            throw new IOException("OCR languages blobs are not available");
        }
    }
}

