/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.googlecode.leptonica.android.Pix;
import java.io.File;

public class ReadFile {
    private static final String LOG_TAG;

    public static Pix readMem(byte[] object) {
        BitmapFactory.Options options;
        if (object == null) {
            Log.e((String)LOG_TAG, (String)"Image data byte array must be non-null");
            return null;
        }
        object = options;
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)object);
        object = bitmap;
        Pix pix = ReadFile.readBitmap(bitmap);
        object.recycle();
        return pix;
    }

    public static Pix readBytes8(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            if (n > 0) {
                if (n2 > 0) {
                    if (byArray.length >= n * n2) {
                        long l = ReadFile.nativeReadBytes8(byArray, n, n2);
                        if (l != 0L) {
                            return new Pix(l);
                        }
                        throw new RuntimeException("Failed to read pix from memory");
                    }
                    throw new IllegalArgumentException("Array length does not match dimensions");
                }
                throw new IllegalArgumentException("Image height must be greater than 0");
            }
            throw new IllegalArgumentException("Image width must be greater than 0");
        }
        throw new IllegalArgumentException("Byte array must be non-null");
    }

    public static boolean replaceBytes8(Pix pix, byte[] byArray, int n, int n2) {
        if (pix != null) {
            if (byArray != null) {
                if (n > 0) {
                    if (n2 > 0) {
                        if (byArray.length >= n * n2) {
                            if (pix.getWidth() == n) {
                                if (pix.getHeight() == n2) {
                                    return ReadFile.nativeReplaceBytes8(pix.getNativePix(), byArray, n, n2);
                                }
                                throw new IllegalArgumentException("Source pix height does not match image height");
                            }
                            throw new IllegalArgumentException("Source pix width does not match image width");
                        }
                        throw new IllegalArgumentException("Array length does not match dimensions");
                    }
                    throw new IllegalArgumentException("Image height must be greater than 0");
                }
                throw new IllegalArgumentException("Image width must be greater than 0");
            }
            throw new IllegalArgumentException("Byte array must be non-null");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static Pix readFile(File file) {
        BitmapFactory.Options options;
        if (file == null) {
            Log.e((String)LOG_TAG, (String)"File must be non-null");
            return null;
        }
        if (!file.exists()) {
            Log.e((String)LOG_TAG, (String)"File does not exist");
            return null;
        }
        if (!file.canRead()) {
            Log.e((String)LOG_TAG, (String)"Cannot read file");
            return null;
        }
        long l = ReadFile.nativeReadFile(file.getAbsolutePath());
        if (l != 0L) {
            return new Pix(l);
        }
        File file2 = file;
        file = options;
        new BitmapFactory.Options().inPreferredConfig = Bitmap.Config.ARGB_8888;
        file = BitmapFactory.decodeFile((String)file2.getAbsolutePath(), (BitmapFactory.Options)file);
        if (file == null) {
            Log.e((String)LOG_TAG, (String)"Cannot decode bitmap");
            return null;
        }
        Pix pix = ReadFile.readBitmap((Bitmap)file);
        file.recycle();
        return pix;
    }

    public static Pix readBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            Log.e((String)LOG_TAG, (String)"Bitmap must be non-null");
            return null;
        }
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            Log.e((String)LOG_TAG, (String)"Bitmap config must be ARGB_8888");
            return null;
        }
        long l = ReadFile.nativeReadBitmap(bitmap);
        if (l == 0L) {
            Log.e((String)LOG_TAG, (String)"Failed to read pix from bitmap");
            return null;
        }
        return new Pix(l);
    }

    private static native long nativeReadMem(byte[] var0, int var1);

    private static native long nativeReadBytes8(byte[] var0, int var1, int var2);

    private static native boolean nativeReplaceBytes8(long var0, byte[] var2, int var3, int var4);

    private static native long nativeReadFile(String var0);

    private static native long nativeReadBitmap(Bitmap var0);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
        LOG_TAG = ReadFile.class.getSimpleName();
    }
}

