/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ocr.intelligence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ocr.intelligence.OcrBitmapInput;
import io.scanbot.sdk.ocr.intelligence.OcrInput;
import io.scanbot.sdk.ocr.intelligence.OcrPagesInput;
import io.scanbot.sdk.ocr.intelligence.OcrPdfRenderer;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.ocr.process.OcrPerformer;
import io.scanbot.sdk.ocr.process.OcrResult;
import io.scanbot.sdk.ocr.process.OcrResultBlock;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BE\u0012\u0006\u00108\u001a\u000206\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010@\u001a\u00020=\u0012\u0006\u0010<\u001a\u000209\u0012\u0006\u00103\u001a\u000200\u0012\u0006\u0010/\u001a\u00020,\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0005\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\u0005\u0010\u000eJ-\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0018J1\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u001dJ\u0017\u0010\u0005\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b\u0005\u0010!J\u001d\u0010\u0005\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u0016H\u0002\u00a2\u0006\u0004\b\u0005\u0010$J\u000f\u0010%\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b%\u0010&R\u0016\u0010)\u001a\u00020'8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010(R\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010/\u001a\u00020,8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0016\u00103\u001a\u0002008\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00108\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u00107R\u0016\u0010<\u001a\u0002098\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010@\u001a\u00020=8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?\u00a8\u0006C"}, d2={"Lio/scanbot/sdk/ocr/intelligence/SimpleOcrPerformer;", "Lio/scanbot/sdk/ocr/process/OcrPerformer;", "", "ocrStartedMillis", "", "a", "(J)V", "Lio/scanbot/sdk/ocr/intelligence/OcrInput;", "input", "", "Lio/scanbot/sdk/entity/Language;", "availableLanguages", "Lio/scanbot/sdk/ocr/process/OcrResult;", "b", "(Lio/scanbot/sdk/ocr/intelligence/OcrInput;Ljava/util/Set;)Lio/scanbot/sdk/ocr/process/OcrResult;", "languages", "Lcom/googlecode/tesseract/android/TessBaseAPI;", "tessBaseAPI", "", "pageIteratorLevel", "Lio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;", "blockType", "", "Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "(Lcom/googlecode/tesseract/android/TessBaseAPI;ILio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;)Ljava/util/List;", "Lcom/googlecode/tesseract/android/ResultIterator;", "resultIterator", "Lcom/googlecode/leptonica/android/Pix;", "thresholdedImage", "(Lcom/googlecode/tesseract/android/ResultIterator;ILcom/googlecode/leptonica/android/Pix;Lio/scanbot/sdk/ocr/process/OcrResultBlock$OcrResultBlockType;)Lio/scanbot/sdk/ocr/process/OcrResultBlock;", "Lio/scanbot/sdk/persistence/Page;", "page", "Ljava/io/File;", "(Lio/scanbot/sdk/persistence/Page;)Ljava/io/File;", "", "languageCodes", "(Ljava/util/List;)Lcom/googlecode/tesseract/android/TessBaseAPI;", "recognize", "()Lio/scanbot/sdk/ocr/process/OcrResult;", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "h", "Lio/scanbot/sdk/ocr/intelligence/OcrInput;", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "g", "Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;", "bitmapBinarizer", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "f", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "ocrSettings", "c", "Ljava/util/Set;", "Lio/scanbot/sap/SapManager;", "Lio/scanbot/sap/SapManager;", "sapManager", "Lio/scanbot/sdk/persistence/PageFileStorage;", "e", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageFileStorage", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "d", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "<init>", "(Lio/scanbot/sap/SapManager;Ljava/util/Set;Lio/scanbot/sdk/persistence/BlobStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/ocr/intelligence/OcrSettings;Lio/scanbot/sdk/ocr/intelligence/OcrPdfRenderer$BitmapBinarizer;Lio/scanbot/sdk/ocr/intelligence/OcrInput;)V", "sdk-ocr_release"})
public final class SimpleOcrPerformer
implements OcrPerformer {
    private final Logger a;
    private final SapManager b;
    private final Set<Language> c;
    private final BlobStoreStrategy d;
    private final PageFileStorage e;
    private final OcrSettings f;
    private final OcrPdfRenderer.BitmapBinarizer g;
    private final OcrInput h;

    private final void a(long l) {
        long l2 = SystemClock.elapsedRealtime() - l;
        this.a.d("OCR", "Ocr total: " + (float)l2 / 1000.0f + " sec");
    }

    private final OcrResult b(OcrInput ocrInput, Set<? extends Language> set) throws IOException {
        this.a.d("OCR", "Starting OCR with languages: " + set);
        return this.a(ocrInput, set);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final OcrResult a(OcrInput list, Set<? extends Language> object) throws IOException {
        Document document;
        Object object2;
        ArrayList<OcrResult.OCRPage> arrayList;
        block13: {
            block14: {
                Object object3;
                ArrayList<OcrResult.OCRPage> arrayList2;
                object = ((SimpleOcrPerformer)object2).a(Language.Companion.languageCodes((Collection)object));
                arrayList = arrayList2;
                arrayList2 = new ArrayList<OcrResult.OCRPage>();
                if (!(list instanceof OcrBitmapInput)) break block14;
                try {
                    OcrResult.OCRPage oCRPage;
                    if (((SimpleOcrPerformer)object2).f.getBinarizeImage()) {
                        ((TessBaseAPI)object).setImage(((SimpleOcrPerformer)object2).g.binarizeBitmap(((OcrBitmapInput)((Object)list)).getBitmap(), false));
                    } else {
                        ((TessBaseAPI)object).setImage(((OcrBitmapInput)((Object)list)).getBitmap());
                    }
                    object3 = object;
                    SimpleOcrPerformer simpleOcrPerformer = object2;
                    SimpleOcrPerformer simpleOcrPerformer2 = object2;
                    SimpleOcrPerformer simpleOcrPerformer3 = object2;
                    Object object4 = object;
                    object2 = ((TessBaseAPI)object4).getUTF8Text();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"tessBaseAPI.utF8Text");
                    list = simpleOcrPerformer3.a((TessBaseAPI)object4, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH);
                    List<OcrResultBlock> list2 = simpleOcrPerformer2.a((TessBaseAPI)object, 2, OcrResultBlock.OcrResultBlockType.LINE);
                    List<OcrResultBlock> list3 = simpleOcrPerformer.a((TessBaseAPI)object, 3, OcrResultBlock.OcrResultBlockType.WORD);
                    oCRPage((String)object2, list, list2, list3);
                    arrayList.add(oCRPage);
                }
                catch (Throwable throwable) {
                    ((TessBaseAPI)object).end();
                    throw throwable;
                }
                ((TessBaseAPI)object3).end();
                break block13;
            }
            if (list instanceof OcrPagesInput) {
                try {
                    list = ((OcrPagesInput)((Object)list)).getPages().iterator();
                    while (list.hasNext()) {
                        OcrResult.OCRPage oCRPage;
                        Object object5 = ((SimpleOcrPerformer)object2).a((Page)list.next());
                        if (!((File)object5).exists()) continue;
                        if (((SimpleOcrPerformer)object2).f.getBinarizeImage()) {
                            Bitmap bitmap = BitmapFactory.decodeFile((String)((File)object5).getAbsolutePath());
                            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeFile(pageFile.absolutePath)");
                            ((TessBaseAPI)object).setImage(((SimpleOcrPerformer)object2).g.binarizeBitmap(bitmap, true));
                        } else {
                            ((TessBaseAPI)object).setImage((File)object5);
                        }
                        Object object6 = object;
                        object5 = ((TessBaseAPI)object6).getUTF8Text();
                        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"tessBaseAPI.utF8Text");
                        List<OcrResultBlock> list4 = super.a((TessBaseAPI)object6, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH);
                        List<OcrResultBlock> list5 = super.a((TessBaseAPI)object, 2, OcrResultBlock.OcrResultBlockType.LINE);
                        List<OcrResultBlock> list6 = super.a((TessBaseAPI)object, 3, OcrResultBlock.OcrResultBlockType.WORD);
                        oCRPage((String)object5, list4, list5, list6);
                        arrayList.add(oCRPage);
                    }
                }
                catch (Throwable throwable) {
                    ((TessBaseAPI)object).end();
                    throw throwable;
                }
                {
                    continue;
                }
                ((TessBaseAPI)object).end();
            }
        }
        object2 = document;
        document = new Document();
        return new OcrResult((Document)object2, null, arrayList);
    }

    private final List<OcrResultBlock> a(TessBaseAPI object, int n, OcrResultBlock.OcrResultBlockType ocrResultBlockType) {
        ArrayList<OcrResultBlock> arrayList;
        ArrayList<OcrResultBlock> arrayList2 = arrayList;
        TessBaseAPI tessBaseAPI = object;
        arrayList2();
        object = tessBaseAPI.getThresholdedImage();
        ResultIterator resultIterator = tessBaseAPI.getResultIterator();
        resultIterator.begin();
        Intrinsics.checkNotNullExpressionValue((Object)resultIterator, (String)"resultIterator");
        arrayList.add(this.a(resultIterator, n, (Pix)object, ocrResultBlockType));
        while (resultIterator.next(n)) {
            arrayList2.add(this.a(resultIterator, n, (Pix)object, ocrResultBlockType));
        }
        return arrayList2;
    }

    private final OcrResultBlock a(ResultIterator resultIterator, int n, Pix pix, OcrResultBlock.OcrResultBlockType ocrResultBlockType) {
        RectF rectF;
        Rect rect;
        Object object = resultIterator.getUTF8Text(n);
        if (object == null) {
            object = "";
        }
        int[] nArray = resultIterator.getBoundingBox(n);
        Rect rect2 = rect;
        rect = new Rect();
        RectF rectF2 = rectF;
        rectF = new RectF();
        if (nArray.length == 4) {
            Rect rect3;
            rect2 = rect3;
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = nArray[3];
            rect3 = new Rect(n2, n3, n4, n5);
            if (pix != null) {
                RectF rectF3;
                rectF2 = rectF3;
                float f = (float)nArray[0] / (float)pix.getWidth();
                float f2 = (float)nArray[1] / (float)pix.getHeight();
                float f3 = (float)nArray[2] / (float)pix.getWidth();
                float f4 = (float)nArray[3] / (float)pix.getHeight();
                rectF3 = new RectF(f, f2, f3, f4);
            }
        }
        float f = resultIterator.confidence(n);
        return new OcrResultBlock((String)object, rectF2, rect2, f, ocrResultBlockType);
    }

    private final File a(Page page) throws IOException {
        File file;
        File file2;
        File file3 = file2;
        File file4 = file;
        file = new File(this.e.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL).getPath());
        if (new File(this.e.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath()).exists()) {
            file4 = file3;
        }
        return file4;
    }

    private final TessBaseAPI a(List<String> list) throws IOException {
        TessBaseAPI tessBaseAPI = new TessBaseAPI();
        tessBaseAPI.init(this.d.getOcrDataDirectory().toString(), TextUtils.join((CharSequence)"+", list));
        tessBaseAPI.setPageSegMode(1);
        return tessBaseAPI;
    }

    public SimpleOcrPerformer(@NotNull SapManager sapManager, @NotNull Set<? extends Language> set, @NotNull BlobStoreStrategy blobStoreStrategy, @NotNull PageFileStorage pageFileStorage, @NotNull OcrSettings ocrSettings, @NotNull OcrPdfRenderer.BitmapBinarizer bitmapBinarizer, @NotNull OcrInput ocrInput) {
        SimpleOcrPerformer simpleOcrPerformer = this;
        Intrinsics.checkNotNullParameter((Object)sapManager, (String)"sapManager");
        Intrinsics.checkNotNullParameter(set, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)blobStoreStrategy, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)ocrSettings, (String)"ocrSettings");
        Intrinsics.checkNotNullParameter((Object)bitmapBinarizer, (String)"bitmapBinarizer");
        Intrinsics.checkNotNullParameter((Object)ocrInput, (String)"input");
        this.b = sapManager;
        this.c = set;
        this.d = blobStoreStrategy;
        this.e = pageFileStorage;
        this.f = ocrSettings;
        this.g = bitmapBinarizer;
        simpleOcrPerformer.h = ocrInput;
        simpleOcrPerformer.a = LoggerProvider.getLogger();
    }

    @Override
    @NotNull
    public OcrResult recognize() {
        OcrResult ocrResult;
        OcrResult ocrResult2 = ocrResult;
        List list = CollectionsKt.emptyList();
        ocrResult = new OcrResult(null, null, list);
        if (!this.b.checkLicenseStatus(SdkFeature.OCR).booleanValue()) {
            return ocrResult2;
        }
        SimpleOcrPerformer simpleOcrPerformer = this;
        long l = SystemClock.elapsedRealtime();
        OcrInput ocrInput = simpleOcrPerformer.h;
        try {
            ocrResult2 = simpleOcrPerformer.b(ocrInput, simpleOcrPerformer.c);
        }
        catch (IOException iOException) {
            this.a.logException((Throwable)iOException);
        }
        this.a(l);
        return ocrResult2;
    }
}

