/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class AdaptiveMap {
    private static final int NORM_REDUCTION = 16;
    private static final int NORM_SIZE = 3;
    private static final int NORM_BG_VALUE = 200;
    public static final int DEFAULT_TILE_WIDTH = 10;
    public static final int DEFAULT_TILE_HEIGHT = 15;
    public static final int DEFAULT_MIN_COUNT = 40;
    public static final int DEFAULT_X_SMOOTH_SIZE = 2;
    public static final int DEFAULT_Y_SMOOTH_SIZE = 1;

    public static Pix backgroundNormMorph(Pix pixs) {
        return AdaptiveMap.backgroundNormMorph(pixs, 16, 3, 200);
    }

    /*
     * WARNING - void declaration
     */
    public static Pix backgroundNormMorph(Pix pixs, int normReduction, int normSize, int normBgValue) {
        if (pixs != null) {
            void var3_4;
            void var2_3;
            void var1_2;
            Pix pix;
            long l = AdaptiveMap.nativeBackgroundNormMorph(pix.getNativePix(), (int)var1_2, (int)var2_3, (int)var3_4);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new RuntimeException("Failed to normalize image background");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    public static Pix pixContrastNorm(Pix pixs) {
        return AdaptiveMap.pixContrastNorm(pixs, 10, 15, 40, 2, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static Pix pixContrastNorm(Pix pixs, int sizeX, int sizeY, int minDiff, int smoothX, int smoothY) {
        if (pixs != null) {
            void var5_6;
            void var4_5;
            void var3_4;
            void var2_3;
            void var1_2;
            Pix pix;
            long l = AdaptiveMap.nativePixContrastNorm(pix.getNativePix(), (int)var1_2, (int)var2_3, (int)var3_4, (int)var4_5, (int)var5_6);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new RuntimeException("Failed to normalize image contrast");
        }
        throw new IllegalArgumentException("Source pix must be non-null");
    }

    private static native long nativeBackgroundNormMorph(long var0, int var2, int var3, int var4);

    private static native long nativePixContrastNorm(long var0, int var2, int var3, int var4, int var5, int var6);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }
}

