/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import androidx.annotation.ColorInt;
import androidx.annotation.Size;

public class Pix {
    public static final int INDEX_W = 0;
    public static final int INDEX_H = 1;
    public static final int INDEX_D = 2;
    private final long mNativePix;
    private boolean mRecycled;

    /*
     * WARNING - void declaration
     */
    public Pix(long nativePix) {
        void var1_1;
        this.mNativePix = var1_1;
        this.mRecycled = false;
    }

    /*
     * WARNING - void declaration
     */
    public Pix(int width, int height, int depth) {
        void var2_2;
        if (width > 0 && var2_2 > 0) {
            void var1_1;
            void var3_3;
            if (var3_3 != true && var3_3 != 2 && var3_3 != 4 && var3_3 != 8 && var3_3 != 16 && var3_3 != 24 && var3_3 != 32) {
                throw new IllegalArgumentException("Depth must be one of 1, 2, 4, 8, 16, or 32");
            }
            Pix pix = this;
            pix.mNativePix = Pix.nativeCreatePix((int)var1_1, (int)var2_2, (int)var3_3);
            pix.mRecycled = false;
            return;
        }
        throw new IllegalArgumentException("Pix width and height must be > 0");
    }

    /*
     * WARNING - void declaration
     */
    public static Pix createFromPix(byte[] pixData, int width, int height, int depth) {
        void var3_4;
        void var2_3;
        void var1_2;
        long l = Pix.nativeCreateFromData(pixData, (int)var1_2, (int)var2_3, (int)var3_4);
        if (l != 0L) {
            return new Pix(l);
        }
        throw new OutOfMemoryError();
    }

    private static native int nativeGetRefCount(long var0);

    private static native long nativeCreatePix(int var0, int var1, int var2);

    private static native long nativeCreateFromData(byte[] var0, int var1, int var2, int var3);

    private static native byte[] nativeGetData(long var0);

    private static native long nativeClone(long var0);

    private static native long nativeCopy(long var0);

    private static native boolean nativeInvert(long var0);

    private static native void nativeDestroy(long var0);

    private static native boolean nativeGetDimensions(long var0, int[] var2);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native int nativeGetDepth(long var0);

    private static native int nativeGetPixel(long var0, int var2, int var3);

    private static native void nativeSetPixel(long var0, int var2, int var3, int var4);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
    }

    public long getNativePix() {
        if (!this.mRecycled) {
            return this.mNativePix;
        }
        throw new IllegalStateException();
    }

    public byte[] getData() {
        if (!((Pix)this_).mRecycled) {
            byte[] byArray = Pix.nativeGetData(((Pix)this_).mNativePix);
            Object this_ = byArray;
            if (byArray != null) {
                return this_;
            }
            throw new RuntimeException("native getData failed");
        }
        throw new IllegalStateException();
    }

    public int[] getDimensions() {
        if (!((Pix)this_).mRecycled) {
            Pix pix = this_;
            int[] nArray = new int[3];
            Object this_ = nArray;
            if (pix.getDimensions(nArray)) {
                return this_;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public boolean getDimensions(@Size(min=3L) int[] dimensions) {
        if (!this.mRecycled) {
            void var1_1;
            return Pix.nativeGetDimensions(this.mNativePix, (int[])var1_1);
        }
        throw new IllegalStateException();
    }

    public Pix clone() {
        if (!this.mRecycled) {
            long l = Pix.nativeClone(this.mNativePix);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    public Pix copy() {
        if (!this.mRecycled) {
            long l = Pix.nativeCopy(this.mNativePix);
            if (l != 0L) {
                return new Pix(l);
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    public boolean invert() {
        if (!this.mRecycled) {
            return Pix.nativeInvert(this.mNativePix);
        }
        throw new IllegalStateException();
    }

    public void recycle() {
        if (!this.mRecycled) {
            Pix.nativeDestroy(this.mNativePix);
            this.mRecycled = true;
        }
    }

    public Rect getRect() {
        Pix pix = this;
        int n = pix.getWidth();
        int n2 = pix.getHeight();
        return new Rect(0, 0, n, n2);
    }

    public int getWidth() {
        if (!this.mRecycled) {
            return Pix.nativeGetWidth(this.mNativePix);
        }
        throw new IllegalStateException();
    }

    public int getHeight() {
        if (!this.mRecycled) {
            return Pix.nativeGetHeight(this.mNativePix);
        }
        throw new IllegalStateException();
    }

    public int getDepth() {
        if (!this.mRecycled) {
            return Pix.nativeGetDepth(this.mNativePix);
        }
        throw new IllegalStateException();
    }

    public int getRefCount() {
        return Pix.nativeGetRefCount(this.mNativePix);
    }

    /*
     * WARNING - void declaration
     */
    public int getPixel(int x, int y) {
        if (!this.mRecycled) {
            void var1_1;
            if (var1_1 >= 0 && var1_1 < this.getWidth()) {
                void var2_2;
                if (var2_2 >= 0 && var2_2 < this.getHeight()) {
                    return Pix.nativeGetPixel(this.mNativePix, (int)var1_1, (int)var2_2);
                }
                throw new IllegalArgumentException("Supplied y coordinate exceeds image bounds");
            }
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void setPixel(int x, int y, @ColorInt int color) {
        if (!this.mRecycled) {
            void var1_1;
            if (var1_1 >= 0 && var1_1 < this.getWidth()) {
                void var2_2;
                if (var2_2 >= 0 && var2_2 < this.getHeight()) {
                    void var3_3;
                    Pix.nativeSetPixel(this.mNativePix, (int)var1_1, (int)var2_2, (int)var3_3);
                    return;
                }
                throw new IllegalArgumentException("Supplied y coordinate exceeds image bounds");
            }
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        throw new IllegalStateException();
    }
}

