/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.payformscanner;

import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.core.payformscanner.DetectionResult;
import io.scanbot.sdk.core.payformscanner.PayFormRecogniser;
import io.scanbot.sdk.core.payformscanner.model.PayFormRecognitionResult;
import io.scanbot.sdk.payformscanner.PayFormScanner;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J*\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/payformscanner/DefaultPayFormScanner;", "Lio/scanbot/sdk/payformscanner/PayFormScanner;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "payFormRecogniser", "Lio/scanbot/sdk/core/payformscanner/PayFormRecogniser;", "preVerifyForm", "Lio/scanbot/sdk/core/payformscanner/DetectionResult;", "nv21", "", "previewWidth", "", "previewHeight", "orientation", "preVerifyFormBGR", "bgr", "recognizeForm", "Lio/scanbot/sdk/core/payformscanner/model/PayFormRecognitionResult;", "width", "height", "recognizeFormBGR", "recognizeFormJPEG", "jpeg", "sdk-payform_release"})
public final class DefaultPayFormScanner
implements PayFormScanner {
    private final PayFormRecogniser payFormRecogniser;

    @Override
    @Nullable
    public PayFormRecognitionResult recognizeForm(@NotNull byte[] nv21, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)nv21, (String)"nv21");
        return this.payFormRecogniser.recognizeForm(nv21, width, height, orientation);
    }

    @Override
    @Nullable
    public PayFormRecognitionResult recognizeFormBGR(@NotNull byte[] bgr, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)bgr, (String)"bgr");
        return this.payFormRecogniser.recognizeFormBGR(bgr, width, height, orientation);
    }

    @Override
    @Nullable
    public PayFormRecognitionResult recognizeFormJPEG(@NotNull byte[] jpeg, int width, int height, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)jpeg, (String)"jpeg");
        return this.payFormRecogniser.recognizeFormJPEG(jpeg, width, height, orientation);
    }

    @Override
    @Nullable
    public DetectionResult preVerifyForm(@NotNull byte[] nv21, int previewWidth, int previewHeight, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)nv21, (String)"nv21");
        return this.payFormRecogniser.preVerifyForm(nv21, previewWidth, previewHeight, orientation);
    }

    @Override
    @Nullable
    public DetectionResult preVerifyFormBGR(@NotNull byte[] bgr, int previewWidth, int previewHeight, int orientation) {
        Intrinsics.checkParameterIsNotNull((Object)bgr, (String)"bgr");
        return this.payFormRecogniser.preVerifyFormBGR(bgr, previewWidth, previewHeight, orientation);
    }

    public DefaultPayFormScanner(@NotNull BlobManager blobManager) {
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        String ocrBlobsPath = null;
        try {
            string2 = blobManager.getOcrBlobsDirectory().getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("OCR blobs directory is not available.");
        }
        ocrBlobsPath = string2;
        String banksDataFilePath = null;
        try {
            string = blobManager.getBanksDataFile().getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Banks data file is not available.");
        }
        banksDataFilePath = string;
        String string3 = ocrBlobsPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ocrBlobsPath");
        String string4 = banksDataFilePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"banksDataFilePath");
        this.payFormRecogniser = new PayFormRecogniser(string3, string4);
    }
}

