/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.process;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.net.Uri;
import android.provider.MediaStore;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.FilterOperation;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.Operation;
import io.scanbot.sdk.process.RotateOperation;
import io.scanbot.sdk.process.TuneOperation;
import io.scanbot.sdk.utils.PolygonHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.util.bitmap.BitmapUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J$\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012J:\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001c2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u001f\u001a\u00020\u0015H\u0002J\u000e\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010!\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ,\u0010!\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015J2\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0015J0\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010-\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/scanbot/sdk/process/PageProcessor;", "", "context", "Landroid/content/Context;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "contourDetector", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "imageProcessor", "Lio/scanbot/sdk/process/ImageProcessor;", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/core/contourdetector/ContourDetector;Lio/scanbot/sdk/process/ImageProcessor;)V", "applyFilter", "Lio/scanbot/sdk/persistence/Page;", "page", "filter", "Lio/scanbot/sdk/process/ImageFilterType;", "applyFilterTunes", "tunes", "", "Lio/scanbot/sdk/process/TuneOperation;", "filterOrder", "", "calculateRotationDegree", "times", "cropAndRotate", "polygon", "Landroid/graphics/PointF;", "cropApplyFiltersTunesFromPage", "Landroid/graphics/Bitmap;", "processor", "originalBitmap", "degrees", "detectDocument", "generateFilteredPreview", "getOperationsForFilterAndTunes", "Lio/scanbot/sdk/process/Operation;", "rotate", "rotateAndSavePageImage", "", "bitmap", "rotationDegree", "pageId", "", "pageType", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "scaleBitmapIfNeeded", "imageSizeLimit", "Lio/scanbot/sdk/persistence/Page$Size;", "sdk-persistence_release"})
public final class PageProcessor {
    private Context context;
    private final PageFileStorage pageFileStorage;
    private final ContourDetector contourDetector;
    private final ImageProcessor imageProcessor;

    @NotNull
    public final Page applyFilter(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        return this.applyFilterTunes(page, filter, page.getTunes(), page.getFilterOrder());
    }

    @NotNull
    public final Page applyFilterTunes(@NotNull Page page, @NotNull ImageFilterType filter, @NotNull List<TuneOperation> tunes, int filterOrder) throws IOException {
        Bitmap unfilteredDocumentBitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(tunes, (String)"tunes");
        Uri unfilteredDocumentImageURI = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (!new File(unfilteredDocumentImageURI.getPath()).exists()) {
            throw (Throwable)new IOException("Unfiltered document image does not exists for this page.");
        }
        Bitmap bitmap = unfilteredDocumentBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)unfilteredDocumentImageURI);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"unfilteredDocumentBitmap");
        Bitmap bitmap2 = ImageProcessor.process$default((ImageProcessor)this.imageProcessor, (Bitmap)bitmap, this.getOperationsForFilterAndTunes(filterOrder, filter, tunes), (boolean)false, (int)4, null);
        if (bitmap2 == null) {
            throw (Throwable)new IOException("Unable to apply filter and tunes");
        }
        Bitmap filteredBitmap = bitmap2;
        this.pageFileStorage.setImageForId(filteredBitmap, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        filteredBitmap.recycle();
        return Page.copy$default(page, null, null, null, filter, null, null, 0, 119, null);
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        return this.generateFilteredPreview(page, filter, page.getTunes(), page.getFilterOrder());
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType filter, @NotNull List<TuneOperation> tunes, int filterOrder) throws IOException {
        Bitmap unfilteredDocumentBitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(tunes, (String)"tunes");
        Uri unfilteredDocumentImageURI = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (!new File(unfilteredDocumentImageURI.getPath()).exists()) {
            throw (Throwable)new IOException("Unfiltered document image does not exists for this page.");
        }
        Bitmap bitmap = unfilteredDocumentBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)unfilteredDocumentImageURI);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"unfilteredDocumentBitmap");
        Bitmap bitmap2 = ImageProcessor.process$default((ImageProcessor)this.imageProcessor, (Bitmap)bitmap, this.getOperationsForFilterAndTunes(filterOrder, filter, tunes), (boolean)false, (int)4, null);
        if (bitmap2 == null) {
            throw (Throwable)new IOException("Unable to generate filtered preview");
        }
        Bitmap filteredBitmap = bitmap2;
        Bitmap generatedPreview = this.pageFileStorage.generateAndSetFilteredPreviewForId(filteredBitmap, page.getPageId(), filter);
        unfilteredDocumentBitmap.recycle();
        filteredBitmap.recycle();
        return generatedPreview;
    }

    @NotNull
    public final Page detectDocument(@NotNull Page page) throws IOException {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri originalImageURI = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(originalImageURI.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        Bitmap originalBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)originalImageURI);
        DetectionResult detectionResult = this.contourDetector.detect(originalBitmap);
        if (detectionResult == null) {
            return page;
        }
        DetectionResult detectionResult2 = detectionResult;
        Bitmap bitmap2 = originalBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"originalBitmap");
        List list = this.contourDetector.getPolygonF();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"contourDetector.polygonF");
        Bitmap documentBitmapBeforeScaling = PageProcessor.cropApplyFiltersTunesFromPage$default(this, this.imageProcessor, bitmap2, list, page, 0, 16, null);
        Bitmap bitmap3 = page.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && page.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE ? BitmapUtils.scaleIfNeeded((Bitmap)documentBitmapBeforeScaling, (int)page.getDocumentImageSizeLimit().getWidth(), (int)page.getDocumentImageSizeLimit().getHeight()) : documentBitmapBeforeScaling;
        if (bitmap3 == null) {
            throw (Throwable)new IOException("Unable to scale image");
        }
        Bitmap documentBitmap = bitmap3;
        if (page.getFilter() != ImageFilterType.NONE) {
            List list2 = this.contourDetector.getPolygonF();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"contourDetector.polygonF");
            bitmap = ImageProcessor.process$default((ImageProcessor)this.imageProcessor, (Bitmap)originalBitmap, (List)CollectionsKt.listOf((Object)new CropOperation(list2)), (boolean)false, (int)4, null);
        } else {
            bitmap = documentBitmap;
        }
        if (bitmap == null) {
            throw (Throwable)new IOException("Unable to crop image");
        }
        Bitmap unfilteredDocumentBitmap = bitmap;
        this.pageFileStorage.setImageForId(documentBitmap, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        this.pageFileStorage.setImageForId(unfilteredDocumentBitmap, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        this.pageFileStorage.removeFilteredPreviewImages(page.getPageId());
        originalBitmap.recycle();
        documentBitmap.recycle();
        unfilteredDocumentBitmap.recycle();
        Bitmap bitmap4 = documentBitmapBeforeScaling;
        if (bitmap4 != null) {
            bitmap4.recycle();
        }
        List list3 = this.contourDetector.getPolygonF();
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"contourDetector.polygonF");
        return Page.copy$default(page, null, list3, detectionResult2, null, null, null, 0, 121, null);
    }

    @NotNull
    public final Page rotate(@NotNull Page page, int times) throws IOException {
        Bitmap originalBitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Uri originalImageURI = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(originalImageURI.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        int rotationDegree = this.calculateRotationDegree(times);
        Bitmap bitmap = originalBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)originalImageURI);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"originalBitmap");
        this.rotateAndSavePageImage(bitmap, rotationDegree, page.getPageId(), PageFileStorage.PageFileType.ORIGINAL, this.imageProcessor);
        originalBitmap.recycle();
        Uri documentImageURI = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
        if (new File(documentImageURI.getPath()).exists()) {
            Bitmap documentBitmap;
            Bitmap bitmap2 = documentBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)documentImageURI);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"documentBitmap");
            this.rotateAndSavePageImage(bitmap2, rotationDegree, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT, this.imageProcessor);
            documentBitmap.recycle();
        }
        Uri unfilteredDocumentImageURI = this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(documentImageURI.getPath()).exists()) {
            Bitmap unfilteredDocumentBitmap;
            Bitmap bitmap3 = unfilteredDocumentBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)unfilteredDocumentImageURI);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"unfilteredDocumentBitmap");
            this.rotateAndSavePageImage(bitmap3, rotationDegree, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT, this.imageProcessor);
            unfilteredDocumentBitmap.recycle();
        }
        this.pageFileStorage.removeFilteredPreviewImages(page.getPageId());
        List pagePolygon = page.getPolygon();
        Collection collection = pagePolygon;
        boolean bl = false;
        if (!collection.isEmpty()) {
            pagePolygon = PolygonHelper.Companion.rotatePolygon(page.getPolygon(), (float)rotationDegree);
        }
        return Page.copy$default(page, null, pagePolygon, null, null, null, null, 0, 125, null);
    }

    @NotNull
    public final Page cropAndRotate(@NotNull Page page, int times, @NotNull List<? extends PointF> polygon) throws IOException {
        Bitmap originalBitmap;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull(polygon, (String)"polygon");
        String pageId = page.getPageId();
        Uri originalImageURI = this.pageFileStorage.getImageURI(pageId, PageFileStorage.PageFileType.ORIGINAL);
        if (!new File(originalImageURI.getPath()).exists()) {
            throw (Throwable)new IOException("Original image does not exists for this page.");
        }
        int rotationDegree = this.calculateRotationDegree(times);
        Bitmap bitmap = originalBitmap = MediaStore.Images.Media.getBitmap((ContentResolver)this.context.getContentResolver(), (Uri)originalImageURI);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"originalBitmap");
        Bitmap bitmap2 = ImageProcessor.process$default((ImageProcessor)this.imageProcessor, (Bitmap)bitmap, (List)CollectionsKt.listOf((Object[])new Operation[]{(Operation)new CropOperation(polygon), (Operation)new RotateOperation(rotationDegree)}), (boolean)false, (int)4, null);
        if (bitmap2 == null) {
            throw (Throwable)new IOException("Unable to crop and rotate");
        }
        Bitmap unfilteredDocumentBitmap = bitmap2;
        unfilteredDocumentBitmap = this.scaleBitmapIfNeeded(unfilteredDocumentBitmap, page.getDocumentImageSizeLimit());
        this.pageFileStorage.setImageForId(unfilteredDocumentBitmap, pageId, PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        unfilteredDocumentBitmap.recycle();
        Bitmap bitmap3 = this.cropApplyFiltersTunesFromPage(this.imageProcessor, originalBitmap, polygon, page, rotationDegree);
        if (bitmap3 == null) {
            throw (Throwable)new IOException("Unable to filter");
        }
        Bitmap documentBitmap = bitmap3;
        documentBitmap = this.scaleBitmapIfNeeded(documentBitmap, page.getDocumentImageSizeLimit());
        this.pageFileStorage.setImageForId(documentBitmap, pageId, PageFileStorage.PageFileType.DOCUMENT);
        documentBitmap.recycle();
        this.rotateAndSavePageImage(originalBitmap, rotationDegree, pageId, PageFileStorage.PageFileType.ORIGINAL, this.imageProcessor);
        originalBitmap.recycle();
        this.pageFileStorage.removeFilteredPreviewImages(pageId);
        List pagePolygon = polygon;
        Collection collection = pagePolygon;
        boolean bl = false;
        if (!collection.isEmpty()) {
            pagePolygon = PolygonHelper.Companion.rotatePolygon(polygon, (float)rotationDegree);
        }
        return Page.copy$default(page, null, pagePolygon, null, null, null, null, 0, 125, null);
    }

    private final Bitmap cropApplyFiltersTunesFromPage(ImageProcessor processor, Bitmap originalBitmap, List<? extends PointF> polygon, Page page, int degrees) {
        List operations = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object)new CropOperation(polygon)));
        operations.addAll((Collection)this.getOperationsForFilterAndTunes(page.getFilterOrder(), page.getFilter(), page.getTunes()));
        if (degrees != 0) {
            operations.add(new RotateOperation(degrees));
        }
        return ImageProcessor.process$default((ImageProcessor)processor, (Bitmap)originalBitmap, (List)operations, (boolean)false, (int)4, null);
    }

    static /* synthetic */ Bitmap cropApplyFiltersTunesFromPage$default(PageProcessor pageProcessor, ImageProcessor imageProcessor, Bitmap bitmap, List list, Page page, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return pageProcessor.cropApplyFiltersTunesFromPage(imageProcessor, bitmap, list, page, n);
    }

    private final List<Operation> getOperationsForFilterAndTunes(int filterOrder, ImageFilterType filter, List<TuneOperation> tunes) {
        boolean bl = false;
        List result = new ArrayList();
        result.addAll(CollectionsKt.take((Iterable)tunes, (int)filterOrder));
        result.add(new FilterOperation(filter));
        result.addAll(CollectionsKt.takeLast(tunes, (int)(tunes.size() - filterOrder)));
        return result;
    }

    static /* synthetic */ List getOperationsForFilterAndTunes$default(PageProcessor pageProcessor, int n, ImageFilterType imageFilterType, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            imageFilterType = ImageFilterType.NONE;
        }
        if ((n2 & 4) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        return pageProcessor.getOperationsForFilterAndTunes(n, imageFilterType, list);
    }

    private final int calculateRotationDegree(int times) {
        int n;
        int rawDegrees = -1 * times * 90;
        if (rawDegrees < 0) {
            int n2 = 360;
            boolean bl = false;
            int n3 = Math.abs(rawDegrees);
            n = n2 - n3 % 360;
        } else {
            n = rawDegrees % 360;
        }
        return n;
    }

    private final void rotateAndSavePageImage(Bitmap bitmap, int rotationDegree, String pageId, PageFileStorage.PageFileType pageType, ImageProcessor imageProcessor) {
        Bitmap bitmap2 = ImageProcessor.process$default((ImageProcessor)imageProcessor, (Bitmap)bitmap, (List)CollectionsKt.listOf((Object)new RotateOperation(rotationDegree)), (boolean)false, (int)4, null);
        if (bitmap2 == null) {
            throw (Throwable)new IOException("Unable to rotate");
        }
        Bitmap rotatedBitmap = bitmap2;
        this.pageFileStorage.setImageForId(rotatedBitmap, pageId, pageType);
        rotatedBitmap.recycle();
    }

    private final Bitmap scaleBitmapIfNeeded(Bitmap bitmap, Page.Size imageSizeLimit) {
        Bitmap bitmap2;
        if (imageSizeLimit.getHeight() != Integer.MAX_VALUE && imageSizeLimit.getWidth() != Integer.MAX_VALUE) {
            Bitmap bitmap3 = BitmapUtils.scaleIfNeeded((Bitmap)bitmap, (int)imageSizeLimit.getWidth(), (int)imageSizeLimit.getHeight());
            bitmap2 = bitmap3;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"BitmapUtils.scaleIfNeede\u2026h, imageSizeLimit.height)");
        } else {
            bitmap2 = bitmap;
        }
        return bitmap2;
    }

    public PageProcessor(@NotNull Context context, @NotNull PageFileStorage pageFileStorage, @NotNull ContourDetector contourDetector, @NotNull ImageProcessor imageProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkParameterIsNotNull((Object)contourDetector, (String)"contourDetector");
        Intrinsics.checkParameterIsNotNull((Object)imageProcessor, (String)"imageProcessor");
        this.context = context;
        this.pageFileStorage = pageFileStorage;
        this.contourDetector = contourDetector;
        this.imageProcessor = imageProcessor;
    }
}

