/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.media.ExifInterface;
import io.scanbot.sdk.entity.PageEntity;
import io.scanbot.sdk.entity.RotationType;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.util.bitmap.BitmapLruCache;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PageFactory {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final BitmapLruCache bitmapLruCache;
    private final PageStoreStrategy pageStoreStrategy;
    private final Logger logger = LoggerProvider.getLogger();

    public PageFactory(BitmapLruCache bitmapLruCache, PageStoreStrategy pageStoreStrategy) {
        this.bitmapLruCache = bitmapLruCache;
        this.pageStoreStrategy = pageStoreStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final Result buildPage(Bitmap image, int screenWidth, int screenHeight) throws IOException {
        PageEntity page = new PageEntity();
        File pageDir = this.pageStoreStrategy.getPageDir(page.id);
        FileUtils.forceMkdir((File)pageDir);
        File filteredDir = FileUtils.getFile((File)pageDir, (String[])new String[]{"filtered"});
        FileUtils.forceMkdir((File)filteredDir);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(pageDir, PageEntity.ImageType.ORIGINAL.getFileName()));
            image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        final Bitmap preview = BitmapUtils.createPreview((Bitmap)image, (int)screenWidth, (int)screenHeight);
        page.setImageSize(PageEntity.ImageType.PREVIEW, preview.getWidth(), preview.getHeight());
        final String previewPath = this.pageStoreStrategy.getImageFile(page.id, PageEntity.ImageType.PREVIEW).getPath();
        this.bitmapLruCache.put((Object)previewPath, (Object)preview);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(previewPath);
                    preview.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
                }
                catch (IOException e) {
                    try {
                        PageFactory.this.logger.logException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
        return new Result(page, preview);
    }

    @Deprecated
    public Result buildPage(byte[] image, int screenWidth, int screenHeight) throws IOException {
        return this.buildPage(UUID.randomUUID().toString(), image, screenWidth, screenHeight);
    }

    @Deprecated
    public Result buildPage(String pageId, byte[] image, int screenWidth, int screenHeight) throws IOException {
        PageEntity page = new PageEntity(pageId);
        File pageDir = this.pageStoreStrategy.getPageDir(page.id);
        FileUtils.forceMkdir((File)pageDir);
        File filteredDir = FileUtils.getFile((File)pageDir, (String[])new String[]{"filtered"});
        FileUtils.forceMkdir((File)filteredDir);
        FileUtils.writeByteArrayToFile((File)new File(pageDir, PageEntity.ImageType.ORIGINAL.getFileName()), (byte[])image);
        final Bitmap preview = BitmapUtils.createPreview((byte[])image, (int)screenWidth, (int)screenHeight);
        page.setImageSize(PageEntity.ImageType.PREVIEW, preview.getWidth(), preview.getHeight());
        final String previewPath = this.pageStoreStrategy.getImageFile(page.id, PageEntity.ImageType.PREVIEW).getPath();
        this.bitmapLruCache.put((Object)previewPath, (Object)preview);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(previewPath);
                    preview.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
                }
                catch (IOException e) {
                    try {
                        PageFactory.this.logger.logException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
        return new Result(page, preview);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Result buildPageWithPreview(Bitmap image, int screenWidth, int screenHeight) throws IOException {
        PageEntity page = new PageEntity();
        File pageDir = this.pageStoreStrategy.getPageDir(page.id);
        FileUtils.forceMkdir((File)pageDir);
        File filteredDir = FileUtils.getFile((File)pageDir, (String[])new String[]{"filtered"});
        FileUtils.forceMkdir((File)filteredDir);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(pageDir, PageEntity.ImageType.OPTIMIZED.getFileName()));
            image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        final Bitmap preview = BitmapUtils.createPreview((Bitmap)image, (int)screenWidth, (int)screenHeight);
        page.setImageSize(PageEntity.ImageType.OPTIMIZED_PREVIEW, preview.getWidth(), preview.getHeight());
        final String previewPath = this.pageStoreStrategy.getImageFile(page.id, PageEntity.ImageType.OPTIMIZED_PREVIEW).getPath();
        this.bitmapLruCache.put((Object)previewPath, (Object)preview);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(previewPath);
                    preview.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
                }
                catch (IOException e) {
                    try {
                        PageFactory.this.logger.logException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
        return new Result(page, preview);
    }

    public Result buildPageWithPreview(byte[] image, int screenWidth, int screenHeight) throws IOException {
        return this.buildPageWithPreview(UUID.randomUUID().toString(), image, screenWidth, screenHeight);
    }

    public Result buildPageWithPreview(String pageId, byte[] image, int screenWidth, int screenHeight) throws IOException {
        PageEntity page = new PageEntity(pageId);
        File pageDir = this.pageStoreStrategy.getPageDir(page.id);
        FileUtils.forceMkdir((File)pageDir);
        File filteredDir = FileUtils.getFile((File)pageDir, (String[])new String[]{"filtered"});
        FileUtils.forceMkdir((File)filteredDir);
        FileUtils.writeByteArrayToFile((File)new File(pageDir, PageEntity.ImageType.OPTIMIZED.getFileName()), (byte[])image);
        final Bitmap preview = BitmapUtils.createPreview((byte[])image, (int)screenWidth, (int)screenHeight);
        page.setImageSize(PageEntity.ImageType.OPTIMIZED_PREVIEW, preview.getWidth(), preview.getHeight());
        final String previewPath = this.pageStoreStrategy.getImageFile(page.id, PageEntity.ImageType.OPTIMIZED_PREVIEW).getPath();
        this.bitmapLruCache.put((Object)previewPath, (Object)preview);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(previewPath);
                    preview.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)out);
                }
                catch (IOException e) {
                    try {
                        PageFactory.this.logger.logException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
        return new Result(page, preview);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PageEntity buildPage(Bitmap image) throws IOException {
        PageEntity page = new PageEntity();
        File pageDir = this.pageStoreStrategy.getPageDir(page.id);
        FileUtils.forceMkdir((File)pageDir);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(pageDir, PageEntity.ImageType.OPTIMIZED.getFileName()));
            image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
        return page;
    }

    public PageEntity buildPage(byte[] image) throws IOException {
        PageEntity page = new PageEntity();
        File pageDir = this.pageStoreStrategy.getPageDir(page.id);
        FileUtils.forceMkdir((File)pageDir);
        FileUtils.writeByteArrayToFile((File)new File(pageDir, PageEntity.ImageType.OPTIMIZED.getFileName()), (byte[])image);
        return page;
    }

    public final PageEntity buildPage(File image) throws IOException {
        return this.buildPage(UUID.randomUUID().toString(), image);
    }

    public final PageEntity buildPage(String pageId, File image) throws IOException {
        RotationType rotationType;
        PageEntity page = new PageEntity(pageId);
        File pageDir = this.pageStoreStrategy.getPageDir(page.id);
        FileUtils.forceMkdir((File)pageDir);
        FileUtils.copyFile((File)image, (File)new File(pageDir, PageEntity.ImageType.OPTIMIZED.getFileName()));
        ExifInterface exif = new ExifInterface(image.getPath());
        page.rotationType = rotationType = PageFactory.exifToOrientation(exif.getAttributeInt("Orientation", 0));
        return page;
    }

    private static RotationType exifToOrientation(int exifOrientation) {
        if (exifOrientation == 6) {
            return RotationType.ROTATION_90;
        }
        if (exifOrientation == 3) {
            return RotationType.ROTATION_180;
        }
        if (exifOrientation == 8) {
            return RotationType.ROTATION_270;
        }
        return RotationType.ROTATION_0;
    }

    public static class Result {
        public final PageEntity page;
        public final Bitmap preview;

        public Result(PageEntity page, Bitmap preview) {
            this.page = page;
            this.preview = preview;
        }
    }
}

