/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Looper;
import io.scanbot.sdk.entity.Page;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.util.FileUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PageStoreStrategy {
    public static final String FILTERED_FOLDER = "filtered";
    public static final String SDK_SNAPPING_PAGES_DIR_NAME = "sdk_snapping_pages";
    private final Application context;
    private final SharedPreferences preferences;
    private final Logger logger = LoggerProvider.getLogger();

    public PageStoreStrategy(Application context, SharedPreferences preferences) {
        this.context = context;
        this.preferences = preferences;
    }

    @NotNull
    public File getPagesDir() throws IOException {
        String dirPath = this.preferences.getString("CUSTOM_SDK_FILES_PATH", "");
        if (!dirPath.isEmpty()) {
            return FileUtils.getFilesDirOrShowError((String)dirPath, (String)SDK_SNAPPING_PAGES_DIR_NAME);
        }
        return FileUtils.getFilesDirOrShowError((String)FileUtils.getAppFilesDirOrShowError((Context)this.context, (String)"scanbot-sdk").getPath(), (String)SDK_SNAPPING_PAGES_DIR_NAME);
    }

    @NotNull
    public File getPageDir(String pageId) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId});
    }

    @NotNull
    public File getImageFile(@NotNull String pageId, @NotNull Page.ImageType imageType) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getPagesDir(), (String[])new String[]{pageId, imageType.getFileName()});
    }

    public File getFilteredPreviewFile(@NotNull String pageId, @NotNull ImageFilterType imageFilterType) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getPageDir(pageId), (String[])new String[]{FILTERED_FOLDER, imageFilterType.getFilterName()});
    }

    public void erasePage(String pageId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<String, Void, Void>(){

                protected Void doInBackground(String ... params) {
                    String pageId = params[0];
                    PageStoreStrategy.this.erasePageSync(pageId);
                    return null;
                }
            }.execute((Object[])new String[]{pageId});
        } else {
            this.erasePageSync(pageId);
        }
    }

    public void eraseTempPageData(String pageId) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            new AsyncTask<String, Void, Void>(){

                protected Void doInBackground(String ... params) {
                    String pageId = params[0];
                    PageStoreStrategy.this.eraseTempPageDataSync(pageId);
                    return null;
                }
            }.execute((Object[])new String[]{pageId});
        } else {
            this.eraseTempPageDataSync(pageId);
        }
    }

    private void eraseTempPageDataSync(String pageId) {
        try {
            File original = this.getImageFile(pageId, Page.ImageType.ORIGINAL);
            if (original.exists()) {
                org.apache.commons.io.FileUtils.deleteQuietly((File)original);
            }
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
    }

    private void erasePageSync(String pageId) {
        try {
            File pageDir = this.getPageDir(pageId);
            if (pageDir.exists() && pageDir.isDirectory()) {
                org.apache.commons.io.FileUtils.deleteDirectory((File)pageDir);
            }
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
    }
}

