/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.entity;

import android.content.Context;
import io.scanbot.sdk.common.R;
import java.util.HashMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public enum DocumentType implements Cloneable
{
    ACADEMIA("academia"),
    ACCOUNTING("accounting"),
    APPLICATION("application"),
    BUSINESS_CARD("businesscard"),
    CASE_FILE("casefile"),
    CERTIFICATE("certificate"),
    CONFIRMATION("confirmation"),
    CONTRACT("contract"),
    DELIVERY_NOTE("deliverynote"),
    DISCOUNT("discount"),
    FORM("form"),
    HEALTH("health"),
    HOME("home"),
    INFO("info"),
    INVOICE("invoice"),
    MANUAL("manual"),
    OFFER("offer"),
    ORDER("order"),
    PAYMENT_REMINDER("paymentreminder"),
    PAY_SLIP("payslip"),
    POLICY("policy"),
    POWER_OFF_ATTORNEY("powerofattorney"),
    PRESS_RELEASE("pressrelease"),
    RECEIPT("receipt"),
    REPORT("report"),
    STATEMENT("statement"),
    STUDIES("studies"),
    TAC("tac"),
    TAX("tax"),
    TERMINATION("termination"),
    TICKET("ticket"),
    UNKNOWN("unknown"),
    WILL("will");

    private static String[] displayNames;
    private static Locale currentLocale;
    private final String mimeType;
    private static final HashMap<String, DocumentType> mimeTypeToDocType;

    private static String[] getDisplayNames(Context context) {
        Locale newLocale = context.getResources().getConfiguration().locale;
        if (newLocale != currentLocale || displayNames == null) {
            currentLocale = newLocale;
            displayNames = context.getResources().getStringArray(R.array.document_types);
        }
        return displayNames;
    }

    private DocumentType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDisplayName(Context context) {
        return DocumentType.getDisplayNames(context)[this.ordinal()];
    }

    @NotNull
    public static DocumentType getByMimeType(String mimeType) {
        return mimeTypeToDocType.containsKey(mimeType) ? mimeTypeToDocType.get(mimeType) : UNKNOWN;
    }

    static {
        mimeTypeToDocType = new HashMap();
        for (DocumentType type : DocumentType.values()) {
            mimeTypeToDocType.put(type.getMimeType(), type);
        }
    }
}

