/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.entity;

import android.graphics.Point;
import android.graphics.PointF;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import io.scanbot.sdk.entity.RotationType;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.PDFPageSize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Page
implements Parcelable {
    public static final String FILTERED_FOLDER = "filtered";
    private final String id;
    private final Bundle parameters;
    private ImageFilterType imageFilterType = ImageFilterType.NONE;
    private RotationType rotationType = RotationType.ROTATION_0;
    private List<PointF> polygon = new ArrayList<PointF>(){
        {
            this.add(new PointF(0.0f, 0.0f));
            this.add(new PointF(1.0f, 0.0f));
            this.add(new PointF(1.0f, 1.0f));
            this.add(new PointF(0.0f, 1.0f));
        }
    };
    private SparseArray<Point> imageSizes = new SparseArray();
    private boolean processed = false;
    private PDFPageSize pageSize = PDFPageSize.FROM_IMAGE;
    public static Parcelable.Creator<Page> CREATOR = new Parcelable.Creator<Page>(){

        public Page createFromParcel(Parcel source) {
            return new Page(source);
        }

        public Page[] newArray(int size) {
            return new Page[size];
        }
    };

    public Page() {
        this.id = UUID.randomUUID().toString();
        this.parameters = new Bundle();
    }

    public Page(String id) {
        this.id = id;
        this.parameters = new Bundle();
    }

    public String getId() {
        return this.id;
    }

    public ImageFilterType getImageFilterType() {
        return this.imageFilterType;
    }

    public void setImageFilterType(ImageFilterType imageFilterType) {
        this.imageFilterType = imageFilterType;
    }

    public RotationType getRotationType() {
        return this.rotationType;
    }

    public void setRotationType(RotationType rotationType) {
        this.rotationType = rotationType;
    }

    public List<PointF> getPolygon() {
        if (this.polygon == null) {
            return Collections.emptyList();
        }
        return this.polygon;
    }

    public void setPolygon(List<PointF> polygon) {
        if (polygon == null || polygon.size() != 4) {
            return;
        }
        this.polygon = polygon;
    }

    public void setImageSize(ImageType imageType, int width, int height) {
        this.imageSizes.put(imageType.ordinal(), (Object)new Point(width, height));
    }

    public Point getImageSize(ImageType imageType) {
        return (Point)this.imageSizes.get(imageType.ordinal());
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public Bundle getParameters() {
        return this.parameters;
    }

    public void setPageSize(PDFPageSize pageSize) {
        this.pageSize = pageSize;
    }

    public PDFPageSize getPageSize() {
        return this.pageSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page page = (Page)o;
        return this.id.equals(page.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeBundle(this.parameters);
        dest.writeInt(this.imageFilterType == null ? -1 : this.imageFilterType.ordinal());
        dest.writeInt(this.rotationType == null ? -1 : this.rotationType.ordinal());
        dest.writeTypedList(this.polygon);
        dest.writeSparseArray(this.imageSizes);
    }

    private Page(Parcel in) {
        this.id = in.readString();
        this.parameters = in.readBundle();
        int tmpImageFilterType = in.readInt();
        this.imageFilterType = tmpImageFilterType == -1 ? null : ImageFilterType.values()[tmpImageFilterType];
        int tmpRotationType = in.readInt();
        this.rotationType = tmpRotationType == -1 ? null : RotationType.values()[tmpRotationType];
        in.readTypedList(this.polygon, PointF.CREATOR);
        this.imageSizes = in.readSparseArray(SparseArray.class.getClassLoader());
    }

    public static enum ImageType {
        ORIGINAL("original"),
        PREVIEW("preview"),
        OPTIMIZED_PREVIEW("optimized_preview"),
        OPTIMIZED("optimized"),
        OVERLAY("overlay"),
        OVERLAY_TMP("overlay_tmp");

        private String fileName;

        private ImageType(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }
}

