/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageProcessor$WhenMappings;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.utils.PolygonHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fJ\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor;", "", "contourDetector", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "imageProcessor", "Lio/scanbot/sdk/process/ImageProcessor;", "(Lio/scanbot/sdk/core/contourdetector/ContourDetector;Lio/scanbot/sdk/persistence/PageStorage;Lio/scanbot/sdk/persistence/PageStorageSettings;Lio/scanbot/sdk/process/ImageProcessor;)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "createPage", "Lio/scanbot/sdk/persistence/Page;", "srcImage", "Landroid/graphics/Bitmap;", "configuration", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "createPage$sdk_persistence_release", "", "createPreviewTo", "previewFile", "Ljava/io/File;", "bitmap", "image", "erasePageData", "", "page", "saveBitmapTo", "file", "Configuration", "sdk-persistence_release"})
public final class PageStorageProcessor {
    private final Logger logger;
    private final ContourDetector contourDetector;
    private final PageStorage pageStorage;
    private final PageStorageSettings pageStorageSettings;
    private final ImageProcessor imageProcessor;

    @NotNull
    public final Page createPage$sdk_persistence_release(@NotNull byte[] srcImage, @NotNull Configuration configuration) {
        Bitmap originalBitmap;
        Intrinsics.checkParameterIsNotNull((Object)srcImage, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap = originalBitmap = BitmapFactory.decodeByteArray((byte[])srcImage, (int)0, (int)srcImage.length, (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"originalBitmap");
        return this.createPage$sdk_persistence_release(bitmap, configuration);
    }

    @NotNull
    public final Page createPage$sdk_persistence_release(@NotNull Bitmap srcImage, @NotNull Configuration configuration) {
        int n;
        double d;
        Intrinsics.checkParameterIsNotNull((Object)srcImage, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
        String pageId = string;
        File pageDir = this.pageStorage.getPageDir(pageId);
        FileUtils.forceMkdir((File)pageDir);
        Bitmap originalBitmap = srcImage;
        if (configuration.getImageOrientation() > 0 || configuration.getImageScale() != 1.0f) {
            Matrix matrix = new Matrix();
            if (configuration.getImageOrientation() > 0) {
                matrix.setRotate((float)configuration.getImageOrientation(), (float)originalBitmap.getWidth() / 2.0f, (float)originalBitmap.getHeight() / 2.0f);
            }
            if (configuration.getImageScale() != 1.0f) {
                matrix.postScale(configuration.getImageScale(), configuration.getImageScale());
            }
            Bitmap bitmap = Bitmap.createBitmap((Bitmap)originalBitmap, (int)0, (int)0, (int)originalBitmap.getWidth(), (int)originalBitmap.getHeight(), (Matrix)matrix, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createBitmap(orig\u2026ap.height, matrix, false)");
            originalBitmap = bitmap;
        }
        this.saveBitmapTo(this.pageStorage.getOriginalImage(pageId), originalBitmap);
        if (configuration.getCreatePreview()) {
            int n2 = originalBitmap.getHeight();
            int n3 = originalBitmap.getWidth();
            d = this.pageStorageSettings.getPreviewTargetMax();
            boolean bl = false;
            n = Math.max(n2, n3);
            double previewScale = d / (double)n;
            Bitmap preview = Bitmap.createScaledBitmap((Bitmap)originalBitmap, (int)((int)((double)originalBitmap.getWidth() * previewScale)), (int)((int)((double)originalBitmap.getHeight() * previewScale)), (boolean)false);
            File file = this.pageStorage.getOriginalImagePreview(pageId);
            Bitmap bitmap = preview;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"preview");
            this.saveBitmapTo(file, bitmap);
        }
        List polygonF = PolygonHelper.Companion.getFulPolygon();
        DetectionResult detectionStatus = DetectionResult.ERROR_NOTHING_DETECTED;
        if (configuration.getCreateDocument()) {
            Bitmap bitmap;
            this.contourDetector.setRequiredAspectRatios(configuration.getRequiredAspectRatios());
            this.contourDetector.setRectOfInterest(configuration.getRectOfInterest());
            detectionStatus = this.contourDetector.detect(originalBitmap);
            if (detectionStatus != DetectionResult.ERROR_NOTHING_DETECTED && detectionStatus != DetectionResult.ERROR_TOO_DARK && detectionStatus != DetectionResult.ERROR_TOO_NOISY) {
                polygonF = this.contourDetector.getPolygonF();
            }
            CropOperation crop = new CropOperation(polygonF);
            Bitmap bitmap2 = ImageProcessor.process$default((ImageProcessor)this.imageProcessor, (Bitmap)originalBitmap, (List)CollectionsKt.listOf((Object)crop), (boolean)false, (int)4, null);
            if (bitmap2 == null) {
                return new Page(null, null, null, 7, null);
            }
            Bitmap documentBitmapBeforeScaling = bitmap2;
            if (configuration.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && configuration.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE) {
                Bitmap bitmap3 = BitmapUtils.scaleIfNeeded((Bitmap)documentBitmapBeforeScaling, (int)configuration.getDocumentImageSizeLimit().getWidth(), (int)configuration.getDocumentImageSizeLimit().getHeight());
                bitmap = bitmap3;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"BitmapUtils.scaleIfNeede\u2026entImageSizeLimit.height)");
            } else {
                bitmap = documentBitmapBeforeScaling;
            }
            Bitmap documentBitmap = bitmap;
            this.saveBitmapTo(this.pageStorage.getDocumentImage(pageId), documentBitmap);
            this.saveBitmapTo(this.pageStorage.getUnfilteredDocumentImage(pageId), documentBitmap);
            if (configuration.getCreatePreview()) {
                int n4 = documentBitmap.getHeight();
                int n5 = documentBitmap.getWidth();
                d = this.pageStorageSettings.getPreviewTargetMax();
                boolean bl = false;
                n = Math.max(n4, n5);
                double previewScale = d / (double)n;
                Bitmap preview = Bitmap.createScaledBitmap((Bitmap)documentBitmap, (int)((int)((double)documentBitmap.getWidth() * previewScale)), (int)((int)((double)documentBitmap.getHeight() * previewScale)), (boolean)false);
                File file = this.pageStorage.getDocumentImagePreview(pageId);
                Bitmap bitmap4 = preview;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"preview");
                this.saveBitmapTo(file, bitmap4);
                this.saveBitmapTo(this.pageStorage.getUnfilteredDocumentImagePreview(pageId), preview);
            }
        }
        int n6 = 0;
        List list = null;
        DetectionResult detectionResult = detectionStatus;
        ImageFilterType imageFilterType = null;
        Page.Size size = new Page.Size(configuration.getDocumentImageSizeLimit().getWidth(), configuration.getDocumentImageSizeLimit().getHeight());
        return new Page(pageId, polygonF, detectionResult, imageFilterType, size, list, n6, 104, null);
    }

    public final void saveBitmapTo(@NotNull File file, @NotNull byte[] bitmap) {
        Bitmap originalBitmap;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap2 = originalBitmap = BitmapFactory.decodeByteArray((byte[])bitmap, (int)0, (int)bitmap.length, (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"originalBitmap");
        this.saveBitmapTo(file, bitmap2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveBitmapTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        FileOutputStream out = null;
        try {
            Bitmap.CompressFormat compressFormat;
            out = new FileOutputStream(file);
            switch (PageStorageProcessor$WhenMappings.$EnumSwitchMapping$0[this.pageStorageSettings.getImageFormat().ordinal()]) {
                case 1: {
                    compressFormat = Bitmap.CompressFormat.JPEG;
                    break;
                }
                case 2: {
                    compressFormat = Bitmap.CompressFormat.PNG;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Bitmap.CompressFormat compression = compressFormat;
            bitmap.compress(compression, this.pageStorageSettings.getImageQuality(), (OutputStream)out);
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File previewFile, @NotNull byte[] image) {
        Bitmap preview;
        Intrinsics.checkParameterIsNotNull((Object)previewFile, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        double d = this.pageStorageSettings.getPreviewTargetMax();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        int n = bitmap2.getHeight();
        int n2 = bitmap.getWidth();
        double d2 = d;
        boolean bl = false;
        int n3 = Math.max(n, n2);
        double scale = d2 / (double)n3;
        Bitmap bitmap3 = preview = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * scale)), (int)((int)((double)bitmap.getHeight() * scale)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"preview");
        this.saveBitmapTo(previewFile, bitmap3);
        return preview;
    }

    @NotNull
    public final Bitmap createPreviewTo(@NotNull File previewFile, @NotNull Bitmap bitmap) {
        Bitmap preview;
        Intrinsics.checkParameterIsNotNull((Object)previewFile, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int n = bitmap.getHeight();
        int n2 = bitmap.getWidth();
        double d = this.pageStorageSettings.getPreviewTargetMax();
        boolean bl = false;
        int n3 = Math.max(n, n2);
        double scale = d / (double)n3;
        Bitmap bitmap2 = preview = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * scale)), (int)((int)((double)bitmap.getHeight() * scale)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"preview");
        this.saveBitmapTo(previewFile, bitmap2);
        return preview;
    }

    public final void erasePageData(@NotNull Page page) {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        try {
            File pageDir = this.pageStorage.getPageDir(page.getPageId());
            if (pageDir.exists() && pageDir.isDirectory()) {
                FileUtils.deleteDirectory((File)pageDir);
            }
        }
        catch (IOException e) {
            this.logger.logException((Throwable)e);
        }
    }

    public PageStorageProcessor(@NotNull ContourDetector contourDetector, @NotNull PageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull ImageProcessor imageProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)contourDetector, (String)"contourDetector");
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        Intrinsics.checkParameterIsNotNull((Object)imageProcessor, (String)"imageProcessor");
        this.contourDetector = contourDetector;
        this.pageStorage = pageStorage;
        this.pageStorageSettings = pageStorageSettings;
        this.imageProcessor = imageProcessor;
        this.logger = LoggerProvider.getLogger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0002+,BQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000fH\u00c6\u0003JU\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\nH\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006-"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "createPreview", "", "createDocument", "documentImageSizeLimit", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "imageScale", "", "imageOrientation", "", "requiredAspectRatios", "", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "rectOfInterest", "Landroid/graphics/RectF;", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;)V", "getCreateDocument", "()Z", "getCreatePreview", "getDocumentImageSizeLimit", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "getImageOrientation", "()I", "getImageScale", "()F", "getRectOfInterest", "()Landroid/graphics/RectF;", "getRequiredAspectRatios", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "Size", "sdk-persistence_release"})
    public static final class Configuration {
        private final boolean createPreview;
        private final boolean createDocument;
        @NotNull
        private final Size documentImageSizeLimit;
        private final float imageScale;
        private final int imageOrientation;
        @NotNull
        private final List<PageAspectRatio> requiredAspectRatios;
        @NotNull
        private final RectF rectOfInterest;
        public static final Companion Companion = new Companion(null);

        public final boolean getCreatePreview() {
            return this.createPreview;
        }

        public final boolean getCreateDocument() {
            return this.createDocument;
        }

        @NotNull
        public final Size getDocumentImageSizeLimit() {
            return this.documentImageSizeLimit;
        }

        public final float getImageScale() {
            return this.imageScale;
        }

        public final int getImageOrientation() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF getRectOfInterest() {
            return this.rectOfInterest;
        }

        public Configuration(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<PageAspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest) {
            Intrinsics.checkParameterIsNotNull((Object)documentImageSizeLimit, (String)"documentImageSizeLimit");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)rectOfInterest, (String)"rectOfInterest");
            this.createPreview = createPreview;
            this.createDocument = createDocument;
            this.documentImageSizeLimit = documentImageSizeLimit;
            this.imageScale = imageScale;
            this.imageOrientation = imageOrientation;
            this.requiredAspectRatios = requiredAspectRatios;
            this.rectOfInterest = rectOfInterest;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            if ((n2 & 4) != 0) {
                size = new Size(0, 0, 3, null);
            }
            if ((n2 & 8) != 0) {
                f = 1.0f;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                list = new ArrayList();
            }
            if ((n2 & 0x40) != 0) {
                rectF = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            }
            this(bl, bl2, size, f, n, list, rectF);
        }

        public Configuration() {
            this(false, false, null, 0.0f, 0, null, null, 127, null);
        }

        public final boolean component1() {
            return this.createPreview;
        }

        public final boolean component2() {
            return this.createDocument;
        }

        @NotNull
        public final Size component3() {
            return this.documentImageSizeLimit;
        }

        public final float component4() {
            return this.imageScale;
        }

        public final int component5() {
            return this.imageOrientation;
        }

        @NotNull
        public final List<PageAspectRatio> component6() {
            return this.requiredAspectRatios;
        }

        @NotNull
        public final RectF component7() {
            return this.rectOfInterest;
        }

        @NotNull
        public final Configuration copy(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<PageAspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest) {
            Intrinsics.checkParameterIsNotNull((Object)documentImageSizeLimit, (String)"documentImageSizeLimit");
            Intrinsics.checkParameterIsNotNull(requiredAspectRatios, (String)"requiredAspectRatios");
            Intrinsics.checkParameterIsNotNull((Object)rectOfInterest, (String)"rectOfInterest");
            return new Configuration(createPreview, createDocument, documentImageSizeLimit, imageScale, imageOrientation, requiredAspectRatios, rectOfInterest);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = configuration.createPreview;
            }
            if ((n2 & 2) != 0) {
                bl2 = configuration.createDocument;
            }
            if ((n2 & 4) != 0) {
                size = configuration.documentImageSizeLimit;
            }
            if ((n2 & 8) != 0) {
                f = configuration.imageScale;
            }
            if ((n2 & 0x10) != 0) {
                n = configuration.imageOrientation;
            }
            if ((n2 & 0x20) != 0) {
                list = configuration.requiredAspectRatios;
            }
            if ((n2 & 0x40) != 0) {
                rectF = configuration.rectOfInterest;
            }
            return configuration.copy(bl, bl2, size, f, n, list, rectF);
        }

        @NotNull
        public String toString() {
            return "Configuration(createPreview=" + this.createPreview + ", createDocument=" + this.createDocument + ", documentImageSizeLimit=" + this.documentImageSizeLimit + ", imageScale=" + this.imageScale + ", imageOrientation=" + this.imageOrientation + ", requiredAspectRatios=" + this.requiredAspectRatios + ", rectOfInterest=" + this.rectOfInterest + ")";
        }

        public int hashCode() {
            int n = this.createPreview ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.createDocument ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            Size size = this.documentImageSizeLimit;
            List<PageAspectRatio> list = this.requiredAspectRatios;
            RectF rectF = this.rectOfInterest;
            return (((((n2 + n3) * 31 + (size != null ? ((Object)size).hashCode() : 0)) * 31 + Float.hashCode(this.imageScale)) * 31 + Integer.hashCode(this.imageOrientation)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (rectF != null ? rectF.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    Configuration configuration = (Configuration)object;
                    if (this.createPreview != configuration.createPreview || this.createDocument != configuration.createDocument || !Intrinsics.areEqual((Object)this.documentImageSizeLimit, (Object)configuration.documentImageSizeLimit) || Float.compare(this.imageScale, configuration.imageScale) != 0 || this.imageOrientation != configuration.imageOrientation || !Intrinsics.areEqual(this.requiredAspectRatios, configuration.requiredAspectRatios) || !Intrinsics.areEqual((Object)this.rectOfInterest, (Object)configuration.rectOfInterest)) break block3;
                }
                return true;
            }
            return false;
        }

        @JvmStatic
        @NotNull
        public static final Configuration DEFAULT() {
            return Companion.DEFAULT();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "Ljava/io/Serializable;", "width", "", "height", "(II)V", "getHeight", "()I", "getWidth", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "sdk-persistence_release"})
        public static final class Size
        implements Serializable {
            private final int width;
            private final int height;

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            public Size(int width, int height) {
                this.width = width;
                this.height = height;
            }

            public /* synthetic */ Size(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    n = Integer.MAX_VALUE;
                }
                if ((n3 & 2) != 0) {
                    n2 = Integer.MAX_VALUE;
                }
                this(n, n2);
            }

            public Size() {
                this(0, 0, 3, null);
            }

            public final int component1() {
                return this.width;
            }

            public final int component2() {
                return this.height;
            }

            @NotNull
            public final Size copy(int width, int height) {
                return new Size(width, height);
            }

            public static /* synthetic */ Size copy$default(Size size, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = size.width;
                }
                if ((n3 & 2) != 0) {
                    n2 = size.height;
                }
                return size.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "Size(width=" + this.width + ", height=" + this.height + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.width) * 31 + Integer.hashCode(this.height);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Size)) break block3;
                        Size size = (Size)object;
                        if (this.width != size.width || this.height != size.height) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Companion;", "", "()V", "DEFAULT", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "sdk-persistence_release"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Configuration DEFAULT() {
                return new Configuration(false, false, null, 0.0f, 0, null, null, 127, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

