/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.entity;

import android.os.Parcel;
import android.os.Parcelable;
import io.scanbot.sdk.entity.DocumentType;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.entity.OcrStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Document
implements Parcelable {
    private String id;
    private String name;
    private long date;
    private int pagesCount;
    private long size = -1L;
    private String thumbnailUri;
    private OcrStatus ocrStatus = OcrStatus.NOT_SCHEDULED;
    private Language language;
    private String ocrText;
    private DocumentType documentType = DocumentType.UNKNOWN;
    public static final Parcelable.Creator<Document> CREATOR = new Parcelable.Creator<Document>(){

        public Document createFromParcel(Parcel in) {
            return new Document(in);
        }

        public Document[] newArray(int size) {
            return new Document[size];
        }
    };

    public Document() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public String getThumbnailUri() {
        return this.thumbnailUri;
    }

    public void setThumbnailUri(String thumbnailUri) {
        this.thumbnailUri = thumbnailUri;
    }

    public int getPagesCount() {
        return this.pagesCount;
    }

    public void setPagesCount(int pagesCount) {
        this.pagesCount = pagesCount;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @NotNull
    public OcrStatus getOcrStatus() {
        return this.ocrStatus;
    }

    public void setOcrStatus(@NotNull OcrStatus ocrStatus) {
        this.ocrStatus = ocrStatus;
    }

    @Nullable
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(@Nullable Language language) {
        this.language = language;
    }

    @NotNull
    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(@NotNull DocumentType documentType) {
        this.documentType = documentType;
    }

    public String getOcrText() {
        return this.ocrText;
    }

    public void setOcrText(String text) {
        this.ocrText = text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        return this.id.equals(document.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Document{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", date=" + this.date + ", pagesCount=" + this.pagesCount + ", size=" + this.size + ", thumbnailUri='" + this.thumbnailUri + '\'' + ", ocrStatus=" + (Object)((Object)this.ocrStatus) + ", language=" + this.language + ", documentType=" + this.documentType + '}';
    }

    protected Document(Parcel in) {
        this.id = in.readString();
        this.name = in.readString();
        this.date = in.readLong();
        this.pagesCount = in.readInt();
        this.size = in.readLong();
        this.thumbnailUri = in.readString();
        this.ocrStatus = (OcrStatus)((Object)in.readValue(OcrStatus.class.getClassLoader()));
        this.language = (Language)in.readValue(Language.class.getClassLoader());
        this.documentType = (DocumentType)in.readValue(DocumentType.class.getClassLoader());
        this.ocrText = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.name);
        dest.writeLong(this.date);
        dest.writeInt(this.pagesCount);
        dest.writeLong(this.size);
        dest.writeString(this.thumbnailUri);
        dest.writeValue((Object)this.ocrStatus);
        dest.writeValue((Object)this.language);
        dest.writeValue((Object)this.documentType);
        dest.writeString(this.ocrText);
    }
}

