/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.cleanup;

import android.util.Pair;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.persistence.cleanup.UnreferencedSourcesProvider;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class BaseUnreferencedSourcesProvider
implements UnreferencedSourcesProvider {
    private final Logger logger = LoggerProvider.getLogger();
    private final PageStoreStrategy pageStoreStrategy;

    @Inject
    public BaseUnreferencedSourcesProvider(PageStoreStrategy pageStoreStrategy) {
        this.pageStoreStrategy = pageStoreStrategy;
    }

    @Override
    public Collection<Pair<String, String>> getUnreferencedDocuments() {
        return Collections.EMPTY_LIST;
    }

    @Override
    @NotNull
    public Collection<String> getUnreferencedSDKPages() {
        List<String> ids = null;
        try {
            ids = Arrays.asList(this.pageStoreStrategy.getPagesDir().list());
            return ids == null ? Collections.EMPTY_LIST : ids;
        }
        catch (IOException e) {
            try {
                this.logger.logException((Throwable)e);
                return ids == null ? Collections.EMPTY_LIST : ids;
            }
            catch (Throwable throwable) {
                return ids == null ? Collections.EMPTY_LIST : ids;
            }
        }
    }
}

