/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.cleanup;

import android.util.Pair;
import io.scanbot.sdk.docprocessing.ProcessingInfoProvider;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.entity.DocumentDraft;
import io.scanbot.sdk.entity.PageEntity;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.persistence.PageStoreStrategy;
import io.scanbot.sdk.persistence.cleanup.UnreferencedSourcesProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\u0014\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "", "unreferencedSourcesProvider", "Lio/scanbot/sdk/persistence/cleanup/UnreferencedSourcesProvider;", "pageStoreStrategy", "Lio/scanbot/sdk/persistence/PageStoreStrategy;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "processingInfoProvider", "Lio/scanbot/sdk/docprocessing/ProcessingInfoProvider;", "pageStorageProcessor", "Lio/scanbot/sdk/persistence/PageStorageProcessor;", "(Lio/scanbot/sdk/persistence/cleanup/UnreferencedSourcesProvider;Lio/scanbot/sdk/persistence/PageStoreStrategy;Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/docprocessing/ProcessingInfoProvider;Lio/scanbot/sdk/persistence/PageStorageProcessor;)V", "cleanUp", "", "cleanUpDocumentData", "document", "Lio/scanbot/sdk/entity/Document;", "cleanUpDocumentThumbnail", "cleanUpPages", "pages", "", "Lio/scanbot/sdk/entity/PageEntity;", "cleanUpPagesData", "Lio/scanbot/sdk/persistence/Page;", "sdk-persistence_release"})
public final class Cleaner {
    private final UnreferencedSourcesProvider unreferencedSourcesProvider;
    private final PageStoreStrategy pageStoreStrategy;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final ProcessingInfoProvider processingInfoProvider;
    private final PageStorageProcessor pageStorageProcessor;

    public final void cleanUp() {
        for (Pair<String, String> docInfo : this.unreferencedSourcesProvider.getUnreferencedDocuments()) {
            this.documentStoreStrategy.eraseDocument((String)docInfo.first, (String)docInfo.second);
        }
        for (String pageId : this.unreferencedSourcesProvider.getUnreferencedSDKPages()) {
            this.pageStoreStrategy.erasePage(pageId);
        }
        for (DocumentDraft document : this.processingInfoProvider.getProcessedDocuments()) {
            this.cleanUpPages(document.getPages());
        }
    }

    public final void cleanUpPages(@NotNull List<PageEntity> pages) {
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        for (PageEntity page : pages) {
            this.pageStoreStrategy.eraseTempPageData(page.id);
        }
    }

    public final void cleanUpPagesData(@NotNull List<Page> pages) {
        Intrinsics.checkParameterIsNotNull(pages, (String)"pages");
        for (Page page : pages) {
            this.pageStorageProcessor.erasePageData(page);
        }
    }

    public final void cleanUpDocumentData(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        this.documentStoreStrategy.eraseDocument(document.id, document.name);
    }

    public final void cleanUpDocumentThumbnail(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        this.documentStoreStrategy.eraseDocumentThumbnail(document.id);
    }

    public Cleaner(@NotNull UnreferencedSourcesProvider unreferencedSourcesProvider, @NotNull PageStoreStrategy pageStoreStrategy, @NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull ProcessingInfoProvider processingInfoProvider, @NotNull PageStorageProcessor pageStorageProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)unreferencedSourcesProvider, (String)"unreferencedSourcesProvider");
        Intrinsics.checkParameterIsNotNull((Object)pageStoreStrategy, (String)"pageStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkParameterIsNotNull((Object)processingInfoProvider, (String)"processingInfoProvider");
        Intrinsics.checkParameterIsNotNull((Object)pageStorageProcessor, (String)"pageStorageProcessor");
        this.unreferencedSourcesProvider = unreferencedSourcesProvider;
        this.pageStoreStrategy = pageStoreStrategy;
        this.documentStoreStrategy = documentStoreStrategy;
        this.processingInfoProvider = processingInfoProvider;
        this.pageStorageProcessor = pageStorageProcessor;
    }
}

