/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.util.FileUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class DocumentStoreStrategy {
    private static final String d = "thumbnail";
    private static final String e = "snapping_documents";
    private static final String f = "%s(%d)%s";
    private static final String g = " (1).";
    private final Context a;
    private final SharedPreferences b;
    private final Logger c = LoggerProvider.getLogger();

    public DocumentStoreStrategy(Context context, SharedPreferences sharedPreferences) {
        this.a = context;
        this.b = sharedPreferences;
    }

    public boolean ensureDocumentDir(File file) {
        return file != null && file.exists() && (this = file.listFiles()) != null && this.length >= 1;
    }

    public File getDocumentsDir() throws IOException {
        String string = this.b.getString("CUSTOM_SDK_FILES_PATH", "");
        if (!string.isEmpty()) {
            return FileUtils.getFilesDirOrShowError((String)string, (String)e);
        }
        return FileUtils.getFilesDirOrShowError((String)FileUtils.getAppFilesDirOrShowError((Context)this.a, (String)"scanbot-sdk").getPath(), (String)e);
    }

    public File getDocumentDir(String string) throws IOException {
        return FileUtils.getFilesDirOrShowError((String)this.getDocumentsDir().getPath(), (String)string);
    }

    public void ensureDocumentDirectory(String string) throws IOException {
        org.apache.commons.io.FileUtils.forceMkdir((File)this.getDocumentDir(string));
    }

    public File getDocumentFile(String string, String string2) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getDocumentDir(string), (String[])new String[]{string2});
    }

    public List<File> getDocumentsFiles() throws IOException {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        File[] fileArray = this.getDocumentsDir().listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.addAll(Arrays.asList(fileArray[i].listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".jpg") || string.endsWith(".pdf");
                }
            })));
        }
        return arrayList2;
    }

    public File getThumbnailFile(String string) throws IOException {
        return org.apache.commons.io.FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{string, d});
    }

    public void eraseDocument(String string, String string2) {
        DocumentStoreStrategy documentStoreStrategy = this;
        String string3 = string;
        org.apache.commons.io.FileUtils.deleteQuietly((File)this.getDocumentFile(string, string2));
        try {
            org.apache.commons.io.FileUtils.deleteQuietly((File)documentStoreStrategy.getDocumentDir(string3));
        }
        catch (IOException iOException) {
            this.c.logException((Throwable)iOException);
        }
    }

    public void eraseDocumentThumbnail(String string) {
        try {
            org.apache.commons.io.FileUtils.deleteQuietly((File)this.getThumbnailFile(string));
        }
        catch (IOException iOException) {
            this.c.logException((Throwable)iOException);
        }
    }

    public boolean renameDocument(String string, String string2, String string3) throws IOException {
        DocumentStoreStrategy documentStoreStrategy = file;
        File file = ((DocumentStoreStrategy)((Object)file)).getDocumentFile(string, ((DocumentStoreStrategy)((Object)file)).getUniqueName(string3));
        return documentStoreStrategy.getDocumentFile(string, string2).renameTo(file);
    }

    /*
     * Loose catch block
     */
    public String getUniqueName(String string) {
        block15: {
            while (true) {
                int n;
                block14: {
                    String string2;
                    string2 = TextUtils.isEmpty((CharSequence)(string2 = FilenameUtils.getExtension((String)string))) ? "" : "." + string2;
                    String string3 = FilenameUtils.getBaseName((String)string);
                    n = string3.lastIndexOf("(");
                    int n2 = string3.lastIndexOf(")");
                    Integer n3 = 0;
                    String string4 = FilenameUtils.getBaseName((String)string);
                    if (n >= 0 && n2 >= 0 && n2 > n) {
                        try {
                            n3 = Integer.valueOf(string3.substring(n + 1, n2));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        string4 = string3.substring(0, n - 1);
                    }
                    n = 0;
                    Iterator<File> iterator = this.getDocumentsFiles().iterator();
                    while (true) {
                        if (!iterator.hasNext()) break block14;
                        if (!FilenameUtils.getBaseName((String)iterator.next().getName()).equals(string3)) continue;
                        break;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append(string4).append(" (");
                    int n4 = n3;
                    string = stringBuilder.append(n4 + 1).append(")").append(string2).toString();
                    n = 1;
                }
                if (n != 0) {
                    continue;
                }
                break block15;
                break;
            }
            catch (IOException iOException) {
                this.c.logException((Throwable)iOException);
            }
        }
        return string;
    }

    public String getPageImagePath(int n, Document document) throws IOException {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        DocumentStoreStrategy documentStoreStrategy = string;
        Document document2 = document;
        String string = document2.id;
        objectArray2[0] = FilenameUtils.removeExtension((String)documentStoreStrategy.getDocumentFile(string, document2.name).getPath());
        objectArray[1] = n;
        objectArray[2] = ".jpg";
        return String.format(f, objectArray2);
    }

    /*
     * Unable to fully structure code
     */
    public void migrateDocuments(String var1_1, List<Document> var2_2) {
        var2_3 = TextUtils.isEmpty((CharSequence)var1_1) ^ true;
        for (Document v0 : var2_2) {
            block14: {
                block13: {
                    v1 = v0;
                    var4_5 = v0.name;
                    var5_7 = v1.id;
                    if (!var2_3) ** GOTO lbl13
                    var6_8 = v2;
                    v2 = new File(var1_1);
                    break block13;
lbl13:
                    // 1 sources

                    var6_8 = this.getDocumentDir(var5_7);
                }
                if (!org.apache.commons.io.FileUtils.getFile((File)var6_8, (String[])new String[]{var4_5}).exists()) break block14;
                v3 = this;
                v4 = var5_7;
                v5 = var4_5;
                v6 = v5;
                v7 = v5;
                var4_5 = FilenameUtils.getExtension((String)v5);
                var7_9 = FilenameUtils.getBaseName((String)v7);
                var4_5 = var7_9 + " (1)." + var4_5;
                v3.renameDocument(v4, v6, var4_5);
            }
            try {
                org.apache.commons.io.FileUtils.moveFileToDirectory((File)this.getDocumentFile(var5_7, var4_5), (File)var6_8, (boolean)true);
            }
            catch (IOException var4_6) {
                this.c.logException((Throwable)var4_6);
            }
        }
    }
}

