/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.fileio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.persistence.fileio.PageFileIOProcessor;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\"\u001a\u00020\u001d\u0012\u0006\u0010\u001c\u001a\u00020\u0017\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\f\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0016\u001a\u00020\u00138\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0019\u0010\u001c\u001a\u00020\u00178\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\"\u001a\u00020\u001d8\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/persistence/fileio/DefaultPageFileIOProcessor;", "Lio/scanbot/sdk/persistence/fileio/PageFileIOProcessor;", "Landroid/graphics/Bitmap;", "bitmap", "Ljava/io/File;", "destination", "", "write", "(Landroid/graphics/Bitmap;Ljava/io/File;)V", "source", "Landroid/graphics/BitmapFactory$Options;", "options", "read", "(Ljava/io/File;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "Landroid/net/Uri;", "sourceUri", "(Landroid/net/Uri;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "copyTo", "(Ljava/io/File;Ljava/io/File;)V", "Lio/scanbot/sdk/util/log/Logger;", "a", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "c", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "getPageStorageSettings", "()Lio/scanbot/sdk/persistence/PageStorageSettings;", "pageStorageSettings", "Landroid/content/Context;", "b", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageStorageSettings;)V", "sdk-persistence_release"})
public final class DefaultPageFileIOProcessor
implements PageFileIOProcessor {
    private final Logger a;
    @NotNull
    private final Context b;
    @NotNull
    private final PageStorageSettings c;

    public DefaultPageFileIOProcessor(@NotNull Context context, @NotNull PageStorageSettings pageStorageSettings) {
        DefaultPageFileIOProcessor defaultPageFileIOProcessor = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pageStorageSettings, (String)"pageStorageSettings");
        this.b = context;
        defaultPageFileIOProcessor.c = pageStorageSettings;
        defaultPageFileIOProcessor.a = LoggerProvider.getLogger();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void write(@NotNull Bitmap bitmap, @NotNull File file) {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block10: {
            FileOutputStream fileOutputStream2;
            FileOutputStream fileOutputStream3;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)file, (String)"destination");
            Object var3_5 = null;
            fileOutputStream = fileOutputStream3;
            fileOutputStream3 = new FileOutputStream(file);
            try {
                Bitmap.CompressFormat compressFormat;
                block9: {
                    int n = this.c.getImageFormat().ordinal();
                    if (n != 0) {
                        if (n == 1) {
                            compressFormat = Bitmap.CompressFormat.PNG;
                            break block9;
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    compressFormat = Bitmap.CompressFormat.JPEG;
                }
                Bitmap.CompressFormat compressFormat2 = compressFormat;
                fileOutputStream2 = fileOutputStream;
                bitmap.compress(compressFormat2, this.c.getImageQuality(), (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable2) {}
            IOUtils.closeQuietly((OutputStream)fileOutputStream2);
            return;
            break block10;
            catch (Throwable throwable2) {
                fileOutputStream = var3_5;
            }
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        throw throwable2;
    }

    @Override
    @Nullable
    public Bitmap read(@NotNull File file, @Nullable BitmapFactory.Options options) {
        File file2 = file;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"source");
        Uri uri = Uri.fromFile((File)file2);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(source)");
        return this.read(uri, options);
    }

    @Override
    @Nullable
    public Bitmap read(@NotNull Uri uri, @Nullable BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"sourceUri");
        if (new File(uri.getPath()).exists()) {
            return BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
        }
        throw new IOException("Source image does not exists for this page.");
    }

    @Override
    public void copyTo(@NotNull File file, @NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"source");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"destination");
        if (file.exists()) {
            FileUtils.copyFile((File)file, (File)file2);
            return;
        }
        throw new IOException("Source image does not exists for this page.");
    }

    @NotNull
    public final Context getContext() {
        return this.b;
    }

    @NotNull
    public final PageStorageSettings getPageStorageSettings() {
        return this.c;
    }
}

