/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.persistence.DraftPageStorage;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageImageSource;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001BB7\u0012\u0006\u0010?\u001a\u00020<\u0012\u0006\u0010(\u001a\u00020\u0006\u0012\u0006\u00103\u001a\u000200\u0012\u0006\u00107\u001a\u000204\u0012\u0006\u0010;\u001a\u000208\u0012\u0006\u0010,\u001a\u00020)\u00a2\u0006\u0004\b@\u0010AJ'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\f\u0010\u000fJ\u001f\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0010\u0010\rJ\u001f\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001d\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001eJ\u0015\u0010 \u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\"\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b\"\u0010!J\r\u0010#\u001a\u00020\u0015\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\b\u00a2\u0006\u0004\b%\u0010!R\u0016\u0010(\u001a\u00020\u00068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010,\u001a\u00020)8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010/\u001a\u00020-8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010.R\u0016\u00103\u001a\u0002008\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00107\u001a\u0002048\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u0010;\u001a\u0002088\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0016\u0010?\u001a\u00020<8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>\u00a8\u0006C"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor;", "", "Landroid/graphics/Bitmap;", "srcImage", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "configuration", "Lio/scanbot/sdk/persistence/PageStorage;", "destinationPageStorage", "Lio/scanbot/sdk/persistence/Page;", "a", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;Lio/scanbot/sdk/persistence/PageStorage;)Lio/scanbot/sdk/persistence/Page;", "", "createPage$sdk_persistence_release", "([BLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;)Lio/scanbot/sdk/persistence/Page;", "createPage", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;)Lio/scanbot/sdk/persistence/Page;", "createDraftPage$sdk_persistence_release", "createDraftPage", "Ljava/io/File;", "file", "bitmap", "", "saveByteArrayTo", "(Ljava/io/File;[B)V", "saveBitmapTo", "(Ljava/io/File;Landroid/graphics/Bitmap;)V", "previewFile", "image", "createPreviewTo", "(Ljava/io/File;[B)Landroid/graphics/Bitmap;", "(Ljava/io/File;Landroid/graphics/Bitmap;)Landroid/graphics/Bitmap;", "page", "erasePageData", "(Lio/scanbot/sdk/persistence/Page;)V", "eraseDraftPageData", "eraseAllDraftPagesData", "()V", "finalizeDraftPage", "c", "Lio/scanbot/sdk/persistence/PageStorage;", "pageStorage", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "g", "Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;", "imageFileIOProcessor", "Lio/scanbot/sdk/util/log/Logger;", "Lio/scanbot/sdk/util/log/Logger;", "logger", "Lio/scanbot/sdk/persistence/DraftPageStorage;", "d", "Lio/scanbot/sdk/persistence/DraftPageStorage;", "draftPageStorage", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "e", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "pageStorageSettings", "Lio/scanbot/sdk/process/ImageProcessor;", "f", "Lio/scanbot/sdk/process/ImageProcessor;", "imageProcessor", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "b", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "contourDetector", "<init>", "(Lio/scanbot/sdk/core/contourdetector/ContourDetector;Lio/scanbot/sdk/persistence/PageStorage;Lio/scanbot/sdk/persistence/DraftPageStorage;Lio/scanbot/sdk/persistence/PageStorageSettings;Lio/scanbot/sdk/process/ImageProcessor;Lio/scanbot/sdk/persistence/fileio/ImageFileIOProcessor;)V", "Configuration", "sdk-persistence_release"})
public final class PageStorageProcessor {
    private final Logger a;
    private final ContourDetector b;
    private final PageStorage c;
    private final DraftPageStorage d;
    private final PageStorageSettings e;
    private final ImageProcessor f;
    private final ImageFileIOProcessor g;

    /*
     * WARNING - void declaration
     */
    private final Page a(Bitmap srcImage, Configuration configuration, PageStorage destinationPageStorage) {
        Page.Size size;
        Object object;
        Object object2;
        Bitmap bitmap;
        PageImageSource pageImageSource;
        void var2_2;
        void var3_3;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UUID.randomUUID().toString()");
        FileUtils.forceMkdir((File)var3_3.getPageDir(string));
        int n = configuration.getImageOrientation();
        if (n <= 0 && var2_2.getImageScale() == 1.0f) {
            bitmap = pageImageSource;
        } else {
            Matrix matrix;
            object2 = matrix;
            matrix = new Matrix();
            if (n > 0) {
                void v1 = pageImageSource;
                float f = (float)v1.getWidth() / 2.0f;
                object2.setRotate((float)n, f, (float)v1.getHeight() / 2.0f);
            }
            if (var2_2.getImageScale() != 1.0f) {
                void v2 = var2_2;
                float f = v2.getImageScale();
                object2.postScale(f, v2.getImageScale());
            }
            void v3 = pageImageSource;
            n = v3.getWidth();
            int n2 = v3.getHeight();
            bitmap = Bitmap.createBitmap((Bitmap)v3, (int)0, (int)0, (int)n, (int)n2, (Matrix)object2, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(orig\u2026ap.height, matrix, false)");
        }
        ((PageStorageProcessor)object).saveBitmapTo(var3_3.getOriginalImage(string), bitmap);
        if (var2_2.getCreatePreview()) {
            void v4 = bitmap;
            double d = (double)((PageStorageProcessor)object).e.getPreviewTargetMax() / (double)Math.max(bitmap.getHeight(), bitmap.getWidth());
            object2 = Bitmap.createScaledBitmap((Bitmap)v4, (int)((int)((double)v4.getWidth() * d)), (int)((int)((double)bitmap.getHeight() * d)), (boolean)false);
            File file = var3_3.getOriginalImagePreview(string);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"preview");
            ((PageStorageProcessor)object).saveBitmapTo(file, (Bitmap)object2);
            object2.recycle();
        }
        object2 = PolygonHelper.Companion.getFullPolygon();
        DetectionResult detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
        if (var2_2.getCreateDocument()) {
            CropOperation cropOperation;
            PageStorageProcessor pageStorageProcessor = object;
            pageStorageProcessor.b.setRequiredAspectRatios(var2_2.getRequiredAspectRatios());
            pageStorageProcessor.b.setRectOfInterest(var2_2.getRectOfInterest());
            detectionResult = pageStorageProcessor.b.detect(bitmap);
            if (detectionResult == null) {
                detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
            }
            if (detectionResult != DetectionResult.ERROR_NOTHING_DETECTED && detectionResult != DetectionResult.ERROR_TOO_DARK && detectionResult != DetectionResult.ERROR_TOO_NOISY && (object2 = ((PageStorageProcessor)object).b.getPolygonF()) == null) {
                object2 = CollectionsKt.emptyList();
            }
            CropOperation cropOperation2 = cropOperation;
            cropOperation = new CropOperation((List)object2);
            if (object2.isEmpty() ^ true && Intrinsics.areEqual((Object)object2, (Object)PolygonHelper.Companion.getFullPolygon()) ^ true) {
                if ((cropOperation2 = ImageProcessor.processBitmap$default((ImageProcessor)((PageStorageProcessor)object).f, (Bitmap)bitmap, (List)CollectionsKt.listOf((Object)cropOperation2), (boolean)false, (int)4, null)) == null) {
                    return new Page(null, null, null, 7, null);
                }
            } else {
                cropOperation2 = bitmap;
            }
            Object object3 = var2_2.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && var2_2.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE ? BitmapUtils.scaleIfNeeded((Bitmap)cropOperation2, (int)var2_2.getDocumentImageSizeLimit().getWidth(), (int)var2_2.getDocumentImageSizeLimit().getHeight()) : cropOperation2;
            ((PageStorageProcessor)object).saveBitmapTo(var3_3.getDocumentImage(string), (Bitmap)object3);
            ((PageStorageProcessor)object).saveBitmapTo(var3_3.getUnfilteredDocumentImage(string), (Bitmap)object3);
            if (var2_2.getCreatePreview()) {
                CropOperation cropOperation3 = object3;
                double d = (double)((PageStorageProcessor)object).e.getPreviewTargetMax() / (double)Math.max(object3.getHeight(), object3.getWidth());
                Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)cropOperation3, (int)((int)((double)cropOperation3.getWidth() * d)), (int)((int)((double)object3.getHeight() * d)), (boolean)false);
                Object object4 = object;
                Object object5 = object;
                object = var3_3.getDocumentImagePreview(string);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"preview");
                ((PageStorageProcessor)object5).saveBitmapTo((File)object, bitmap2);
                ((PageStorageProcessor)object4).saveBitmapTo(var3_3.getUnfilteredDocumentImagePreview(string), bitmap2);
                bitmap2.recycle();
            }
            if (object3 != pageImageSource) {
                object3.recycle();
            }
            if (cropOperation2 != pageImageSource) {
                cropOperation2.recycle();
            }
            if (bitmap != pageImageSource) {
                bitmap.recycle();
            }
        }
        object = size;
        size = new Page.Size(var2_2.getDocumentImageSizeLimit().getWidth(), var2_2.getDocumentImageSizeLimit().getHeight());
        pageImageSource = var2_2.getPageImageSource();
        return new Page(string, (List)object2, detectionResult, null, (Page.Size)object, null, 0, pageImageSource, 104, null);
    }

    /*
     * WARNING - void declaration
     */
    public PageStorageProcessor(@NotNull ContourDetector contourDetector, @NotNull PageStorage pageStorage, @NotNull DraftPageStorage draftPageStorage, @NotNull PageStorageSettings pageStorageSettings, @NotNull ImageProcessor imageProcessor, @NotNull ImageFileIOProcessor imageFileIOProcessor) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        PageStorageProcessor pageStorageProcessor = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"contourDetector");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"draftPageStorage");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"pageStorageSettings");
        Intrinsics.checkNotNullParameter((Object)var5_5, (String)"imageProcessor");
        Intrinsics.checkNotNullParameter((Object)var6_6, (String)"imageFileIOProcessor");
        this.b = var1_1;
        this.c = var2_2;
        this.d = var3_3;
        this.e = var4_4;
        this.f = var5_5;
        pageStorageProcessor.g = var6_6;
        pageStorageProcessor.a = LoggerProvider.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page createPage$sdk_persistence_release(@NotNull byte[] srcImage, @NotNull Configuration configuration) {
        BitmapFactory.Options options;
        void var2_2;
        PageStorage pageStorage;
        PageStorageProcessor pageStorageProcessor = this_;
        void v1 = pageStorage;
        Intrinsics.checkNotNullParameter((Object)pageStorage, (String)"srcImage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"configuration");
        PageStorageProcessor this_ = options;
        options = new BitmapFactory.Options();
        this_ = BitmapFactory.decodeByteArray((byte[])v1, (int)0, (int)((void)v1).length, (BitmapFactory.Options)this_);
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"originalBitmap");
        pageStorage = pageStorageProcessor.c;
        Page page = pageStorageProcessor.a((Bitmap)this_, (Configuration)var2_2, pageStorage);
        this_.recycle();
        return page;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page createPage$sdk_persistence_release(@NotNull Bitmap srcImage, @NotNull Configuration configuration) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"srcImage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"configuration");
        return this.a((Bitmap)var1_1, (Configuration)var2_2, this.c);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page createDraftPage$sdk_persistence_release(@NotNull byte[] srcImage, @NotNull Configuration configuration) {
        BitmapFactory.Options options;
        void var2_2;
        DraftPageStorage draftPageStorage;
        PageStorageProcessor pageStorageProcessor = this_;
        void v1 = draftPageStorage;
        Intrinsics.checkNotNullParameter((Object)draftPageStorage, (String)"srcImage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"configuration");
        PageStorageProcessor this_ = options;
        options = new BitmapFactory.Options();
        this_ = BitmapFactory.decodeByteArray((byte[])v1, (int)0, (int)((void)v1).length, (BitmapFactory.Options)this_);
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"originalBitmap");
        draftPageStorage = pageStorageProcessor.d;
        Page page = pageStorageProcessor.a((Bitmap)this_, (Configuration)var2_2, draftPageStorage);
        this_.recycle();
        return page;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page createDraftPage$sdk_persistence_release(@NotNull Bitmap srcImage, @NotNull Configuration configuration) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"srcImage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"configuration");
        return this.a((Bitmap)var1_1, (Configuration)var2_2, this.d);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveByteArrayTo(@NotNull File file, @NotNull byte[] bitmap) {
        BitmapFactory.Options options;
        void var1_1;
        void var2_2;
        PageStorageProcessor pageStorageProcessor = this_;
        void v1 = var2_2;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"file");
        Intrinsics.checkNotNullParameter((Object)v1, (String)"bitmap");
        PageStorageProcessor this_ = options;
        options = new BitmapFactory.Options();
        this_ = BitmapFactory.decodeByteArray((byte[])v1, (int)0, (int)((void)v1).length, (BitmapFactory.Options)this_);
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"originalBitmap");
        pageStorageProcessor.saveBitmapTo((File)var1_1, (Bitmap)this_);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void saveBitmapTo(@NotNull File file, @NotNull Bitmap bitmap) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"file");
        Intrinsics.checkNotNullParameter((Object)var2_3, (String)"bitmap");
        try {
            Bitmap.CompressFormat compressFormat;
            int n = this.e.getImageFormat().ordinal();
            if (n != 0) {
                if (n != 1) throw new NoWhenBranchMatchedException();
                compressFormat = Bitmap.CompressFormat.PNG;
            } else {
                compressFormat = Bitmap.CompressFormat.JPEG;
            }
            Bitmap.CompressFormat compressFormat2 = compressFormat;
            this.g.writeImage((Bitmap)var2_3, compressFormat2, this.e.getImageQuality(), (File)var1_1);
            return;
        }
        catch (IOException iOException) {
            this.a.logException((Throwable)iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap createPreviewTo(@NotNull File previewFile, @NotNull byte[] image) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"previewFile");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        double d = this.e.getPreviewTargetMax();
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        double d2 = d / (double)Math.max(bitmap2.getHeight(), bitmap.getWidth());
        Bitmap bitmap3 = bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d2)), (int)((int)((double)bitmap.getHeight() * d2)), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"preview");
        this.saveBitmapTo((File)var1_1, bitmap3);
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap createPreviewTo(@NotNull File previewFile, @NotNull Bitmap bitmap) {
        Bitmap bitmap2;
        void var1_1;
        Bitmap bitmap3 = bitmap;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"previewFile");
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
        double d = (double)this.e.getPreviewTargetMax() / (double)Math.max(bitmap2.getHeight(), bitmap2.getWidth());
        Bitmap bitmap4 = bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap3, (int)((int)((double)bitmap3.getWidth() * d)), (int)((int)((double)bitmap2.getHeight() * d)), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap4, (String)"preview");
        this.saveBitmapTo((File)var1_1, bitmap4);
        return bitmap2;
    }

    public final void erasePageData(@NotNull Page page) {
        block5: {
            File file;
            Intrinsics.checkNotNullParameter((Object)file, (String)"page");
            file = this.c.getPageDir(((Page)((Object)file)).getPageId());
            if (!file.exists()) break block5;
            if (!file.isDirectory()) break block5;
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException iOException) {
                this.a.logException((Throwable)iOException);
            }
        }
    }

    public final void eraseDraftPageData(@NotNull Page page) {
        block5: {
            File file;
            Intrinsics.checkNotNullParameter((Object)file, (String)"page");
            file = this.d.getPageDir(((Page)((Object)file)).getPageId());
            if (!file.exists()) break block5;
            if (!file.isDirectory()) break block5;
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException iOException) {
                this.a.logException((Throwable)iOException);
            }
        }
    }

    public final void eraseAllDraftPagesData() {
        block5: {
            File file = this.d.getPagesDirectory();
            if (!file.exists()) break block5;
            if (!file.isDirectory()) break block5;
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException iOException) {
                this.a.logException((Throwable)iOException);
            }
        }
    }

    public final void finalizeDraftPage(@NotNull Page page) {
        block6: {
            File file;
            Intrinsics.checkNotNullParameter((Object)file, (String)"page");
            File file2 = this.d.getPageDir(((Page)((Object)file)).getPageId());
            file = this.c.getPageDir(((Page)((Object)file)).getPageId());
            if (!file2.exists()) break block6;
            if (!file2.isDirectory()) break block6;
            try {
                FileUtils.moveDirectory((File)file2, (File)file);
            }
            catch (IOException iOException) {
                this.a.logException((Throwable)iOException);
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\"\b\u0086\b\u0018\u0000 C2\u00020\u0001:\u0002CDB]\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u001b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u001c\u001a\u00020\t\u0012\b\b\u0002\u0010\u001d\u001a\u00020\f\u0012\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u001f\u001a\u00020\u0013\u0012\b\b\u0002\u0010 \u001a\u00020\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\fH\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018Jf\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\u00022\b\b\u0002\u0010\u001b\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\t2\b\b\u0002\u0010\u001d\u001a\u00020\f2\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u001f\u001a\u00020\u00132\b\b\u0002\u0010 \u001a\u00020\u0016H\u00c6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010$\u001a\u00020#H\u00d6\u0001\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\fH\u00d6\u0001\u00a2\u0006\u0004\b&\u0010\u000eJ\u001a\u0010(\u001a\u00020\u00022\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b(\u0010)R\u0019\u0010\u001c\u001a\u00020\t8\u0006@\u0006\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010\u000bR\u0019\u0010\u001d\u001a\u00020\f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u0010\u000eR\u0019\u0010\u001f\u001a\u00020\u00138\u0006@\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u0010\u0015R\u0019\u0010 \u001a\u00020\u00168\u0006@\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u0010\u0018R\u0019\u0010\u001b\u001a\u00020\u00068\u0006@\u0006\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u0010\bR\u001f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006@\u0006\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010\u0012R\u0019\u0010\u001a\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b<\u0010=\u001a\u0004\b>\u0010\u0004R\u0019\u0010\u0019\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b?\u0010=\u001a\u0004\b@\u0010\u0004\u00a8\u0006E"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "", "component1", "()Z", "component2", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "component3", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "", "component4", "()F", "", "component5", "()I", "", "Lio/scanbot/sdk/core/contourdetector/PageAspectRatio;", "component6", "()Ljava/util/List;", "Landroid/graphics/RectF;", "component7", "()Landroid/graphics/RectF;", "Lio/scanbot/sdk/persistence/PageImageSource;", "component8", "()Lio/scanbot/sdk/persistence/PageImageSource;", "createPreview", "createDocument", "documentImageSizeLimit", "imageScale", "imageOrientation", "requiredAspectRatios", "rectOfInterest", "pageImageSource", "copy", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;Lio/scanbot/sdk/persistence/PageImageSource;)Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "", "toString", "()Ljava/lang/String;", "hashCode", "other", "equals", "(Ljava/lang/Object;)Z", "d", "F", "getImageScale", "e", "I", "getImageOrientation", "g", "Landroid/graphics/RectF;", "getRectOfInterest", "h", "Lio/scanbot/sdk/persistence/PageImageSource;", "getPageImageSource", "c", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "getDocumentImageSizeLimit", "f", "Ljava/util/List;", "getRequiredAspectRatios", "b", "Z", "getCreateDocument", "a", "getCreatePreview", "<init>", "(ZZLio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;FILjava/util/List;Landroid/graphics/RectF;Lio/scanbot/sdk/persistence/PageImageSource;)V", "Companion", "Size", "sdk-persistence_release"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean a;
        private final boolean b;
        @NotNull
        private final Size c;
        private final float d;
        private final int e;
        @NotNull
        private final List<PageAspectRatio> f;
        @NotNull
        private final RectF g;
        @NotNull
        private final PageImageSource h;

        /*
         * WARNING - void declaration
         */
        public Configuration(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<PageAspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest, @NotNull PageImageSource pageImageSource) {
            void var5_5;
            void var4_4;
            void var2_2;
            void var1_1;
            void var8_8;
            void var7_7;
            void var6_6;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"documentImageSizeLimit");
            Intrinsics.checkNotNullParameter((Object)var6_6, (String)"requiredAspectRatios");
            Intrinsics.checkNotNullParameter((Object)var7_7, (String)"rectOfInterest");
            Intrinsics.checkNotNullParameter((Object)var8_8, (String)"pageImageSource");
            this.a = var1_1;
            this.b = var2_2;
            this.c = var3_3;
            this.d = var4_4;
            this.e = var5_5;
            this.f = var6_6;
            this.g = var7_7;
            this.h = var8_8;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, PageImageSource pageImageSource, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = true;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            if ((n2 & 4) != 0) {
                Size size2;
                size = size2;
                size2 = new Size(0, 0, 3, null);
            }
            if ((n2 & 8) != 0) {
                f = 1.0f;
            }
            if ((n2 & 0x10) != 0) {
                n = 0;
            }
            if ((n2 & 0x20) != 0) {
                ArrayList arrayList;
                list = arrayList;
                arrayList = new ArrayList();
            }
            if ((n2 & 0x40) != 0) {
                RectF rectF2;
                rectF = rectF2;
                rectF2 = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
            }
            if ((n2 & 0x80) != 0) {
                pageImageSource = PageImageSource.UNDEFINED;
            }
            this(bl, bl2, size, f, n, list, rectF, pageImageSource);
        }

        public Configuration() {
            this(false, false, null, 0.0f, 0, null, null, null, 255, null);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, boolean bl2, Size size, float f, int n, List list, RectF rectF, PageImageSource pageImageSource, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = configuration.a;
            }
            if ((n2 & 2) != 0) {
                bl2 = configuration.b;
            }
            if ((n2 & 4) != 0) {
                size = configuration.c;
            }
            if ((n2 & 8) != 0) {
                f = configuration.d;
            }
            if ((n2 & 0x10) != 0) {
                n = configuration.e;
            }
            if ((n2 & 0x20) != 0) {
                list = configuration.f;
            }
            if ((n2 & 0x40) != 0) {
                rectF = configuration.g;
            }
            if ((n2 & 0x80) != 0) {
                pageImageSource = configuration.h;
            }
            return configuration.copy(bl, bl2, size, f, n, list, rectF, pageImageSource);
        }

        @JvmStatic
        @NotNull
        public static final Configuration DEFAULT() {
            return Companion.DEFAULT();
        }

        public final boolean getCreatePreview() {
            return this.a;
        }

        public final boolean getCreateDocument() {
            return this.b;
        }

        @NotNull
        public final Size getDocumentImageSizeLimit() {
            return this.c;
        }

        public final float getImageScale() {
            return this.d;
        }

        public final int getImageOrientation() {
            return this.e;
        }

        @NotNull
        public final List<PageAspectRatio> getRequiredAspectRatios() {
            return this.f;
        }

        @NotNull
        public final RectF getRectOfInterest() {
            return this.g;
        }

        @NotNull
        public final PageImageSource getPageImageSource() {
            return this.h;
        }

        public final boolean component1() {
            return this.a;
        }

        public final boolean component2() {
            return this.b;
        }

        @NotNull
        public final Size component3() {
            return this.c;
        }

        public final float component4() {
            return this.d;
        }

        public final int component5() {
            return this.e;
        }

        @NotNull
        public final List<PageAspectRatio> component6() {
            return this.f;
        }

        @NotNull
        public final RectF component7() {
            return this.g;
        }

        @NotNull
        public final PageImageSource component8() {
            return this.h;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Configuration copy(boolean createPreview, boolean createDocument, @NotNull Size documentImageSizeLimit, float imageScale, int imageOrientation, @NotNull List<PageAspectRatio> requiredAspectRatios, @NotNull RectF rectOfInterest, @NotNull PageImageSource pageImageSource) {
            void var8_8;
            void var5_5;
            void var4_4;
            void var2_2;
            void var1_1;
            void var7_7;
            void var6_6;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"documentImageSizeLimit");
            Intrinsics.checkNotNullParameter((Object)var6_6, (String)"requiredAspectRatios");
            Intrinsics.checkNotNullParameter((Object)var7_7, (String)"rectOfInterest");
            Intrinsics.checkNotNullParameter((Object)((Object)pageImageSource), (String)"pageImageSource");
            return new Configuration((boolean)var1_1, (boolean)var2_2, (Size)var3_3, (float)var4_4, (int)var5_5, (List<PageAspectRatio>)var6_6, (RectF)var7_7, (PageImageSource)var8_8);
        }

        @NotNull
        public String toString() {
            return "Configuration(createPreview=" + this.a + ", createDocument=" + this.b + ", documentImageSizeLimit=" + this.c + ", imageScale=" + this.d + ", imageOrientation=" + this.e + ", requiredAspectRatios=" + this.f + ", rectOfInterest=" + this.g + ", pageImageSource=" + (Object)((Object)this.h) + ")";
        }

        public int hashCode() {
            int n = this.a ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            n *= 31;
            int n2 = this.b ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            n = (n + n2) * 31;
            Size size = this.c;
            int n3 = size != null ? size.hashCode() : 0;
            n = (((n + n3) * 31 + Float.hashCode(this.d)) * 31 + Integer.hashCode(this.e)) * 31;
            List<PageAspectRatio> list = this.f;
            int n4 = list != null ? ((Object)list).hashCode() : 0;
            n = (n + n4) * 31;
            RectF rectF = this.g;
            int n5 = rectF != null ? rectF.hashCode() : 0;
            int n6 = (n + n5) * 31;
            PageImageSource pageImageSource = this.h;
            int n7 = pageImageSource != null ? ((Object)((Object)pageImageSource)).hashCode() : 0;
            return n6 + n7;
        }

        public boolean equals(@Nullable Object object) {
            block2: {
                block3: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    object = (Configuration)object;
                    if (this.a == ((Configuration)object).a && this.b == ((Configuration)object).b && Intrinsics.areEqual((Object)this.c, (Object)((Configuration)object).c) && Float.compare(this.d, ((Configuration)object).d) == 0 && this.e == ((Configuration)object).e && Intrinsics.areEqual(this.f, ((Configuration)object).f) && Intrinsics.areEqual((Object)this.g, (Object)((Configuration)object).g) && Intrinsics.areEqual((Object)((Object)this.h), (Object)((Object)((Configuration)object).h))) break block2;
                }
                return false;
            }
            return true;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000b\u001a\u00020\nH\u00d6\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\r\u0010\u0004J\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0007\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0004R\u0019\u0010\u0006\u001a\u00020\u00028\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0014\u001a\u0004\b\u0017\u0010\u0004\u00a8\u0006\u001a"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "Ljava/io/Serializable;", "", "component1", "()I", "component2", "width", "height", "copy", "(II)Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Size;", "", "toString", "()Ljava/lang/String;", "hashCode", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "b", "I", "getHeight", "a", "getWidth", "<init>", "(II)V", "sdk-persistence_release"})
        public static final class Size
        implements Serializable {
            private final int a;
            private final int b;

            /*
             * WARNING - void declaration
             */
            public Size(int width, int height) {
                void var2_2;
                void var1_1;
                this.a = var1_1;
                this.b = var2_2;
            }

            public /* synthetic */ Size(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 1) != 0) {
                    n = Integer.MAX_VALUE;
                }
                if ((n3 & 2) != 0) {
                    n2 = Integer.MAX_VALUE;
                }
                this(n, n2);
            }

            public Size() {
                this(0, 0, 3, null);
            }

            public static /* synthetic */ Size copy$default(Size size, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = size.a;
                }
                if ((n3 & 2) != 0) {
                    n2 = size.b;
                }
                return size.copy(n, n2);
            }

            public final int getWidth() {
                return this.a;
            }

            public final int getHeight() {
                return this.b;
            }

            public final int component1() {
                return this.a;
            }

            public final int component2() {
                return this.b;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Size copy(int width, int height) {
                void var2_2;
                void var1_1;
                return new Size((int)var1_1, (int)var2_2);
            }

            @NotNull
            public String toString() {
                return "Size(width=" + this.a + ", height=" + this.b + ")";
            }

            public int hashCode() {
                return Integer.hashCode(this.a) * 31 + Integer.hashCode(this.b);
            }

            public boolean equals(@Nullable Object object) {
                block2: {
                    block3: {
                        if (this == object) break block2;
                        if (!(object instanceof Size)) break block3;
                        object = (Size)object;
                        if (this.a == ((Size)object).a && this.b == ((Size)object).b) break block2;
                    }
                    return false;
                }
                return true;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration$Companion;", "", "Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "DEFAULT", "()Lio/scanbot/sdk/persistence/PageStorageProcessor$Configuration;", "<init>", "()V", "sdk-persistence_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @JvmStatic
            @NotNull
            public final Configuration DEFAULT() {
                return new Configuration(false, false, null, 0.0f, 0, null, null, null, 255, null);
            }
        }
    }
}

