/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.utils;

import android.content.Context;
import android.media.MediaPlayer;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import io.scanbot.sdk.ui.base.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\u000bJ\b\u0010\r\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0007J\u0010\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u0006J\u0014\u0010\u0011\u001a\u00020\u000b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\u0012\u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/ui/utils/ScanBeeper;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "enabled", "", "mediaPlayer", "Landroid/media/MediaPlayer;", "onBeepCompleteAction", "Lkotlin/Function0;", "", "beep", "doSetUp", "release", "setEnabled", "enable", "setOnBeepCompleteAction", "setUp", "rtu-ui-base_release"})
public final class ScanBeeper
implements LifecycleObserver {
    @NotNull
    private final Context context;
    private boolean enabled;
    @Nullable
    private MediaPlayer mediaPlayer;
    @Nullable
    private Function0<Unit> onBeepCompleteAction;

    public ScanBeeper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public final void setUp() {
        if (this.enabled) {
            this.doSetUp();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public final void release() {
        MediaPlayer mediaPlayer = this.mediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.release();
        }
        this.mediaPlayer = null;
    }

    public final void setOnBeepCompleteAction(@NotNull Function0<Unit> onBeepCompleteAction) {
        Intrinsics.checkNotNullParameter(onBeepCompleteAction, (String)"onBeepCompleteAction");
        this.onBeepCompleteAction = onBeepCompleteAction;
    }

    public final void setEnabled(boolean enable) {
        if (!this.enabled || !enable) {
            if (!this.enabled && enable) {
                this.doSetUp();
            } else if (!enable) {
                this.release();
            }
        }
        this.enabled = enable;
    }

    public static /* synthetic */ void setEnabled$default(ScanBeeper scanBeeper, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        scanBeeper.setEnabled(bl);
    }

    public final void beep() {
        block2: {
            if (this.enabled) {
                MediaPlayer mediaPlayer = this.mediaPlayer;
                if (mediaPlayer != null) {
                    mediaPlayer.start();
                }
            }
            Function0<Unit> function0 = this.onBeepCompleteAction;
            if (function0 == null) break block2;
            function0.invoke();
        }
    }

    private final void doSetUp() {
        this.mediaPlayer = MediaPlayer.create((Context)this.context, (int)R.raw.bleep);
    }
}

