/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.camera.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.Px;
import androidx.annotation.RequiresApi;
import com.google.gson.Gson;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonCameraModule;
import io.scanbot.sdk.ui.configuration.json.JsonColor;
import io.scanbot.sdk.ui.configuration.json.JsonInterfaceOrientation;
import io.scanbot.sdk.ui.configuration.json.JsonSize;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.camera.configuration.DocumentScannerAccessibilityConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.DocumentScannerConfigurationParams;
import io.scanbot.sdk.ui.view.camera.configuration.json.DocumentJsonExtensionsKt;
import io.scanbot.sdk.ui.view.camera.configuration.json.DocumentScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.camera.configuration.json.JsonDocumentScannerAccessibilityConfiguration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b;\u0018\u0000 \u008f\u00012\u00020\u0001:\u0002\u008f\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\n2\b\b\u0001\u0010#\u001a\u00020\fJ\u0010\u0010$\u001a\u00020\n2\b\b\u0001\u0010%\u001a\u00020\fJ\u0010\u0010&\u001a\u00020\n2\b\b\u0001\u0010'\u001a\u00020\fJ\u000e\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u0005J\u000e\u00100\u001a\u00020\n2\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\f2\u0006\u00105\u001a\u00020\fJ\u000e\u00106\u001a\u00020\n2\u0006\u00107\u001a\u00020\u001aJ\u000e\u00108\u001a\u00020\n2\u0006\u00109\u001a\u00020\u0005J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\u0005J\u000e\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020\u001aJ\u000e\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\u0005J\u000e\u0010@\u001a\u00020\n2\u0006\u0010A\u001a\u00020\u001aJ\u000e\u0010B\u001a\u00020\n2\u0006\u0010C\u001a\u00020\u001aJ\u000e\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u00020\u001aJ\u000e\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020\n2\u0006\u0010J\u001a\u00020!J\u000e\u0010K\u001a\u00020\n2\u0006\u0010L\u001a\u00020\fJ\u000e\u0010M\u001a\u00020\n2\u0006\u0010N\u001a\u00020\u001aJ\u000e\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020\u0005J\u000e\u0010Q\u001a\u00020\n2\u0006\u0010R\u001a\u00020\u001aJ\u000e\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020UJ\u000e\u0010V\u001a\u00020\n2\u0006\u0010W\u001a\u00020\u0005J\u0010\u0010X\u001a\u00020\n2\b\b\u0001\u0010Y\u001a\u00020\fJ\u000e\u0010Z\u001a\u00020\n2\u0006\u0010C\u001a\u00020\u001aJ\u0010\u0010[\u001a\u00020\n2\b\b\u0001\u0010\\\u001a\u00020\fJ\u0010\u0010]\u001a\u00020\n2\b\b\u0001\u0010^\u001a\u00020\fJ\u0010\u0010_\u001a\u00020\n2\b\b\u0001\u0010`\u001a\u00020\fJ\u0010\u0010a\u001a\u00020\n2\b\b\u0001\u0010b\u001a\u00020\fJ\u0010\u0010c\u001a\u00020\n2\b\b\u0001\u0010d\u001a\u00020\fJ\u0010\u0010e\u001a\u00020\n2\b\b\u0001\u0010f\u001a\u00020\fJ\u0010\u0010g\u001a\u00020\n2\b\b\u0001\u0010h\u001a\u00020\fJ\u0010\u0010i\u001a\u00020\n2\b\b\u0001\u0010j\u001a\u00020\fJ\u0010\u0010k\u001a\u00020\n2\b\b\u0001\u0010l\u001a\u00020\fJ\u000e\u0010m\u001a\u00020\n2\u0006\u0010n\u001a\u00020\u001aJ\u0010\u0010o\u001a\u00020\n2\b\b\u0001\u0010p\u001a\u00020\fJ\u0010\u0010q\u001a\u00020\n2\b\b\u0001\u0010r\u001a\u00020\fJ\u0010\u0010s\u001a\u00020\n2\u0006\u0010t\u001a\u00020\u001aH\u0007J\u000e\u0010u\u001a\u00020\n2\u0006\u0010v\u001a\u00020\u0005J\u000e\u0010w\u001a\u00020\n2\u0006\u0010x\u001a\u00020\u0005J\u000e\u0010y\u001a\u00020\n2\u0006\u0010z\u001a\u00020\u0005J\u000e\u0010{\u001a\u00020\n2\u0006\u0010|\u001a\u00020\u0005J\u000e\u0010}\u001a\u00020\n2\u0006\u0010~\u001a\u00020\u0005J\u000f\u0010\u007f\u001a\u00020\n2\u0007\u0010\u0080\u0001\u001a\u00020\u0005J\u0010\u0010\u0081\u0001\u001a\u00020\n2\u0007\u0010\u0082\u0001\u001a\u00020\u0005J\u0012\u0010\u0083\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0084\u0001\u001a\u00020\fJ\u0012\u0010\u0085\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0086\u0001\u001a\u00020\fJ\u0012\u0010\u0087\u0001\u001a\u00020\n2\t\b\u0001\u0010\u0088\u0001\u001a\u00020\fJ\u0010\u0010\u0089\u0001\u001a\u00020\n2\u0007\u0010\u008a\u0001\u001a\u00020\u001aJ\u0012\u0010\u008b\u0001\u001a\u00020\n2\t\b\u0001\u0010\u008c\u0001\u001a\u00020\fJ\u0012\u0010\u008d\u0001\u001a\u00020\n2\t\b\u0001\u0010\u008e\u0001\u001a\u00020\fR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0090\u0001"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerConfiguration;", "", "()V", "cameraConfiguration", "", "", "Ljava/io/Serializable;", "getCameraConfiguration", "()Ljava/util/Map;", "enableHardwareSnapButton", "", "key", "", "modifyFromJsonConfiguration", "jsonConfig", "Lio/scanbot/sdk/ui/view/camera/configuration/json/DocumentScannerJsonConfiguration;", "setAcceptedAngleScore", "acceptedAngleScore", "", "setAcceptedSizeScore", "acceptedSizeScore", "setAccessibilityConfiguration", "accessibilityConfiguration", "Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerAccessibilityConfiguration;", "setAutoSnappingButtonHidden", "autoSnappingButtonHidden", "", "setAutoSnappingButtonTitle", "autoSnappingButtonTitle", "setAutoSnappingEnabled", "autoSnappingEnabled", "setAutoSnappingSensitivity", "autoSnappingSensitivity", "", "setBottomBarBackgroundColor", "bottomBarBackgroundColor", "setBottomBarButtonsColor", "bottomBarButtonsColor", "setCameraBackgroundColor", "cameraBackgroundColor", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonTitle", "cancelButtonTitle", "setDelayAfterFocusCompleteMs", "delay", "", "setDocumentImageSizeLimit", "documentImageHeightLimit", "documentImageWidthLimit", "setDrawPolygonShadows", "drawPolygonShadows", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFlashButtonHidden", "flashButtonHidden", "setFlashButtonTitle", "flashButtonTitle", "setFlashEnabled", "flashEnabled", "setForceMaxSnappingSize", "enabled", "setIgnoreBadAspectRatio", "ignoreBadAspectRatio", "setImageFilterType", "imageFilterType", "Lio/scanbot/sdk/process/ImageFilterType;", "setImageScale", "imageScale", "setMaxNumberOfPages", "maxNumberOfPages", "setMultiPageButtonHidden", "multiPageButtonHidden", "setMultiPageButtonTitle", "multiPageButtonTitle", "setMultiPageEnabled", "multiPageEnabled", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setPageCounterButtonTitle", "pageCounterButtonTitle", "setPolygonAutoSnapProgressColor", "polygonAutoSnapProgressColor", "setPolygonAutoSnapProgressEnabled", "setPolygonAutoSnapProgressLineWidth", "polygonProgressLineWidth", "setPolygonBackgroundColor", "polygonBackgroundColor", "setPolygonBackgroundColorOK", "polygonBackgroundColorOK", "setPolygonColor", "polygonColor", "setPolygonColorOK", "polygonColorOK", "setPolygonCornerRadius", "polygonCornerRadius", "setPolygonLineWidth", "polygonLineWidth", "setShutterButtonAutoInnerColor", "shutterButtonAutoInnerColor", "setShutterButtonAutoOuterColor", "shutterButtonAutoOuterColor", "setShutterButtonHidden", "shutterButtonHidden", "setShutterButtonManualInnerColor", "shutterButtonManualInnerColor", "setShutterButtonManualOuterColor", "shutterButtonManualOuterColor", "setShutterSoundEnabled", "shutterSoundEnabled", "setTextHintBadAngles", "textBadAngles", "setTextHintBadAspectRatio", "textHintBadAspectRatio", "setTextHintNothingDetected", "textHintNothingDetected", "setTextHintOK", "textHintDontMove", "setTextHintTooDark", "textHintTooDark", "setTextHintTooNoisy", "textHintTooNoisy", "setTextHintTooSmall", "textHintTooSmall", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsActiveColor", "topBarButtonsActiveColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "setUserGuidanceBackgroundColor", "userGuidanceBackgroundColor", "setUserGuidanceTextColor", "userGuidanceTextColor", "Companion", "rtu-ui-docdetector_release"})
public final class DocumentScannerConfiguration {
    @NotNull
    private final Map<String, Serializable> cameraConfiguration = new HashMap();
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Serializable> getCameraConfiguration() {
        return this.cameraConfiguration;
    }

    public final void setImageFilterType(@NotNull ImageFilterType imageFilterType) {
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"imageFilterType");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IMAGE_FILTER_TYPE.getKey(), (Serializable)imageFilterType);
    }

    public final void setDelayAfterFocusCompleteMs(long delay) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), Long.valueOf(delay));
    }

    public final void setAutoSnappingEnabled(boolean autoSnappingEnabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_ENABLED.getKey(), Boolean.valueOf(autoSnappingEnabled));
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_ENABLED.getKey(), Boolean.valueOf(flashEnabled));
    }

    public final void setMultiPageEnabled(boolean multiPageEnabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_ENABLED.getKey(), Boolean.valueOf(multiPageEnabled));
    }

    public final void setMaxNumberOfPages(int maxNumberOfPages) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MAX_NUMBER_OF_PAGES.getKey(), Integer.valueOf(maxNumberOfPages));
    }

    public final void setAutoSnappingSensitivity(float autoSnappingSensitivity) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_SENSITIVITY.getKey(), Float.valueOf(autoSnappingSensitivity));
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_MODULE.getKey(), (Serializable)cameraModule);
    }

    public final void enableHardwareSnapButton(int key) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.HARDWARE_SNAP_BUTTON.getKey(), Integer.valueOf(key));
    }

    public static /* synthetic */ void enableHardwareSnapButton$default(DocumentScannerConfiguration documentScannerConfiguration, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 25;
        }
        documentScannerConfiguration.enableHardwareSnapButton(n);
    }

    public final void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IGNORE_BAD_ASPECT_RATIO.getKey(), Boolean.valueOf(ignoreBadAspectRatio));
    }

    public final void setAcceptedAngleScore(double acceptedAngleScore) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCEPTED_ANGLE_SCORE.getKey(), Double.valueOf(acceptedAngleScore));
    }

    public final void setAcceptedSizeScore(double acceptedSizeScore) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCEPTED_SIZE_SCORE.getKey(), Double.valueOf(acceptedSizeScore));
    }

    public final void setImageScale(float imageScale) {
        float f = 0.0f;
        boolean bl = false;
        f = Math.max(f, imageScale);
        float f2 = 1.0f;
        boolean bl2 = false;
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.IMAGE_SCALE.getKey(), Float.valueOf(Math.min(f, f2)));
    }

    public final void setDocumentImageSizeLimit(int documentImageHeightLimit, int documentImageWidthLimit) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.DOCUMENT_IMAGE_SIZE_LIMIT.getKey(), (Serializable)new PageStorageProcessor.Configuration.Size(documentImageWidthLimit, documentImageHeightLimit));
    }

    public final void setPolygonColor(@ColorInt int polygonColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_COLOR.getKey(), Integer.valueOf(polygonColor));
    }

    public final void setPolygonColorOK(@ColorInt int polygonColorOK) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_COLOR_OK.getKey(), Integer.valueOf(polygonColorOK));
    }

    public final void setPolygonLineWidth(@Px int polygonLineWidth) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_LINE_WIDTH.getKey(), Integer.valueOf(polygonLineWidth));
    }

    public final void setPolygonAutoSnapProgressColor(@ColorInt int polygonAutoSnapProgressColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_COLOR.getKey(), Integer.valueOf(polygonAutoSnapProgressColor));
    }

    public final void setPolygonAutoSnapProgressLineWidth(@Px int polygonProgressLineWidth) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_LINE_WIDTH.getKey(), Integer.valueOf(polygonProgressLineWidth));
    }

    public final void setPolygonAutoSnapProgressEnabled(boolean enabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_PROGRESS_ENABLED.getKey(), Boolean.valueOf(enabled));
    }

    public final void setPolygonCornerRadius(@Px int polygonCornerRadius) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_CORNER_RADIUS.getKey(), Integer.valueOf(polygonCornerRadius));
    }

    public final void setPolygonBackgroundColor(@ColorInt int polygonBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR.getKey(), Integer.valueOf(polygonBackgroundColor));
    }

    public final void setPolygonBackgroundColorOK(@ColorInt int polygonBackgroundColorOK) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_BACKGROUND_COLOR_OK.getKey(), Integer.valueOf(polygonBackgroundColorOK));
    }

    public final void setDrawPolygonShadows(boolean drawPolygonShadows) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.POLYGON_DRAW_SHADOWS.getKey(), Boolean.valueOf(drawPolygonShadows));
    }

    public final void setShutterButtonAutoOuterColor(@ColorInt int shutterButtonAutoOuterColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_OUTER_COLOR.getKey(), Integer.valueOf(shutterButtonAutoOuterColor));
    }

    public final void setShutterButtonAutoInnerColor(@ColorInt int shutterButtonAutoInnerColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_AUTO_INNER_COLOR.getKey(), Integer.valueOf(shutterButtonAutoInnerColor));
    }

    public final void setShutterButtonManualOuterColor(@ColorInt int shutterButtonManualOuterColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_OUTER_COLOR.getKey(), Integer.valueOf(shutterButtonManualOuterColor));
    }

    public final void setShutterButtonManualInnerColor(@ColorInt int shutterButtonManualInnerColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_MANUAL_INNER_COLOR.getKey(), Integer.valueOf(shutterButtonManualInnerColor));
    }

    @RequiresApi(api=17)
    public final void setShutterSoundEnabled(boolean shutterSoundEnabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_SOUND_ENABLED.getKey(), Boolean.valueOf(shutterSoundEnabled));
    }

    public final void setUserGuidanceBackgroundColor(@ColorInt int userGuidanceBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USER_GUIDANCE_BACKGROUND_COLOR.getKey(), Integer.valueOf(userGuidanceBackgroundColor));
    }

    public final void setUserGuidanceTextColor(@ColorInt int userGuidanceTextColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USER_GUIDANCE_TEXT_COLOR.getKey(), Integer.valueOf(userGuidanceTextColor));
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), Integer.valueOf(topBarBackgroundColor));
    }

    public final void setTopBarButtonsActiveColor(@ColorInt int topBarButtonsActiveColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BUTTONS_ACTIVE_COLOR.getKey(), Integer.valueOf(topBarButtonsActiveColor));
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), Integer.valueOf(topBarButtonsInactiveColor));
    }

    public final void setBottomBarBackgroundColor(@ColorInt int bottomBarBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.BOTTOM_BAR_BACKGROUND_COLOR.getKey(), Integer.valueOf(bottomBarBackgroundColor));
    }

    public final void setBottomBarButtonsColor(@ColorInt int bottomBarButtonsColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.BOTTOM_BAR_BUTTONS_COLOR.getKey(), Integer.valueOf(bottomBarButtonsColor));
    }

    public final void setCameraBackgroundColor(@ColorInt int cameraBackgroundColor) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CAMERA_BACKGROUND_COLOR.getKey(), Integer.valueOf(cameraBackgroundColor));
    }

    public final void setMultiPageButtonHidden(boolean multiPageButtonHidden) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_BUTTON_HIDDEN.getKey(), Boolean.valueOf(multiPageButtonHidden));
    }

    public final void setFlashButtonHidden(boolean flashButtonHidden) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_BUTTON_HIDDEN.getKey(), Boolean.valueOf(flashButtonHidden));
    }

    public final void setAutoSnappingButtonHidden(boolean autoSnappingButtonHidden) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_BUTTON_HIDDEN.getKey(), Boolean.valueOf(autoSnappingButtonHidden));
    }

    public final void setShutterButtonHidden(boolean shutterButtonHidden) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.SHUTTER_BUTTON_HIDDEN.getKey(), Boolean.valueOf(shutterButtonHidden));
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setPageCounterButtonTitle(@NotNull String pageCounterButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)pageCounterButtonTitle, (String)"pageCounterButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.PAGE_COUNTER_BUTTON_TITLE.getKey(), (Serializable)((Object)pageCounterButtonTitle));
    }

    public final void setTextHintOK(@NotNull String textHintDontMove) {
        Intrinsics.checkNotNullParameter((Object)textHintDontMove, (String)"textHintDontMove");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_OK.getKey(), (Serializable)((Object)textHintDontMove));
    }

    public final void setTextHintTooSmall(@NotNull String textHintTooSmall) {
        Intrinsics.checkNotNullParameter((Object)textHintTooSmall, (String)"textHintTooSmall");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_SMALL.getKey(), (Serializable)((Object)textHintTooSmall));
    }

    public final void setTextHintBadAngles(@NotNull String textBadAngles) {
        Intrinsics.checkNotNullParameter((Object)textBadAngles, (String)"textBadAngles");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_BAD_ANGLES.getKey(), (Serializable)((Object)textBadAngles));
    }

    public final void setTextHintBadAspectRatio(@NotNull String textHintBadAspectRatio) {
        Intrinsics.checkNotNullParameter((Object)textHintBadAspectRatio, (String)"textHintBadAspectRatio");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_BAD_ASPECT_RATIO.getKey(), (Serializable)((Object)textHintBadAspectRatio));
    }

    public final void setTextHintNothingDetected(@NotNull String textHintNothingDetected) {
        Intrinsics.checkNotNullParameter((Object)textHintNothingDetected, (String)"textHintNothingDetected");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_NOTHING_DETECTED.getKey(), (Serializable)((Object)textHintNothingDetected));
    }

    public final void setTextHintTooNoisy(@NotNull String textHintTooNoisy) {
        Intrinsics.checkNotNullParameter((Object)textHintTooNoisy, (String)"textHintTooNoisy");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_NOISY.getKey(), (Serializable)((Object)textHintTooNoisy));
    }

    public final void setTextHintTooDark(@NotNull String textHintTooDark) {
        Intrinsics.checkNotNullParameter((Object)textHintTooDark, (String)"textHintTooDark");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.TEXT_HINT_TOO_DARK.getKey(), (Serializable)((Object)textHintTooDark));
    }

    public final void setMultiPageButtonTitle(@NotNull String multiPageButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)multiPageButtonTitle, (String)"multiPageButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.MULTI_PAGE_BUTTON_TITLE.getKey(), (Serializable)((Object)multiPageButtonTitle));
    }

    public final void setFlashButtonTitle(@NotNull String flashButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)flashButtonTitle, (String)"flashButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FLASH_BUTTON_TITLE.getKey(), (Serializable)((Object)flashButtonTitle));
    }

    public final void setAutoSnappingButtonTitle(@NotNull String autoSnappingButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)autoSnappingButtonTitle, (String)"autoSnappingButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.AUTO_SNAPPING_BUTTON_TITLE.getKey(), (Serializable)((Object)autoSnappingButtonTitle));
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey(), Boolean.valueOf(allCaps));
    }

    public final void setAccessibilityConfiguration(@NotNull DocumentScannerAccessibilityConfiguration accessibilityConfiguration) {
        Intrinsics.checkNotNullParameter((Object)accessibilityConfiguration, (String)"accessibilityConfiguration");
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.ACCESSIBILITY_CONFIGURATION.getKey(), accessibilityConfiguration);
    }

    public final void setForceMaxSnappingSize(boolean enabled) {
        this.cameraConfiguration.put(DocumentScannerConfigurationParams.FORCE_MAX_SNAPPING_SIZE.getKey(), Boolean.valueOf(enabled));
    }

    public final void modifyFromJsonConfiguration(@NotNull DocumentScannerJsonConfiguration jsonConfig) {
        Unit unit;
        Unit unit2;
        Unit unit3;
        Unit unit4;
        Unit unit5;
        Unit unit6;
        Unit unit7;
        Unit unit8;
        Unit unit9;
        Unit unit10;
        Unit unit11;
        Unit unit12;
        Unit unit13;
        Unit unit14;
        Unit unit15;
        Unit unit16;
        Unit unit17;
        Unit unit18;
        Unit unit19;
        Unit unit20;
        Unit unit21;
        Unit unit22;
        Unit unit23;
        Unit unit24;
        Unit unit25;
        Unit unit26;
        Unit unit27;
        Unit unit28;
        Unit unit29;
        Unit unit30;
        Unit unit31;
        Unit unit32;
        Unit unit33;
        Unit unit34;
        Unit unit35;
        Unit unit36;
        Unit unit37;
        Unit unit38;
        Unit unit39;
        Unit unit40;
        Unit unit41;
        Unit unit42;
        Unit unit43;
        Unit unit44;
        Unit unit45;
        Unit unit46;
        Unit unit47;
        Unit unit48;
        Unit unit49;
        Unit unit50;
        Unit unit51;
        Unit unit52;
        Unit unit53;
        Unit unit54;
        double it;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
        Double d = jsonConfig.getAcceptedAngleScore();
        if (d != null) {
            object = d;
            bl2 = false;
            bl = false;
            it = ((Number)object).doubleValue();
            boolean bl3 = false;
            this.setAcceptedAngleScore(it);
            unit54 = Unit.INSTANCE;
        } else {
            unit54 = null;
        }
        Double d2 = jsonConfig.getAcceptedSizeScore();
        if (d2 != null) {
            object = d2;
            bl2 = false;
            bl = false;
            it = ((Number)object).doubleValue();
            boolean bl4 = false;
            this.setAcceptedSizeScore(it);
            unit53 = Unit.INSTANCE;
        } else {
            unit53 = null;
        }
        JsonDocumentScannerAccessibilityConfiguration jsonDocumentScannerAccessibilityConfiguration = jsonConfig.getAccessibilityConfiguration();
        if (jsonDocumentScannerAccessibilityConfiguration != null) {
            object = jsonDocumentScannerAccessibilityConfiguration;
            bl2 = false;
            bl = false;
            Object it2 = object;
            boolean bl5 = false;
            this.setAccessibilityConfiguration(DocumentJsonExtensionsKt.toSdk((JsonDocumentScannerAccessibilityConfiguration)it2));
            unit52 = Unit.INSTANCE;
        } else {
            unit52 = null;
        }
        Boolean bl6 = jsonConfig.getAutoSnappingButtonHidden();
        if (bl6 != null) {
            object = bl6;
            bl2 = false;
            bl = false;
            boolean it3 = (Boolean)object;
            boolean bl7 = false;
            this.setAutoSnappingButtonHidden(it3);
            unit51 = Unit.INSTANCE;
        } else {
            unit51 = null;
        }
        String string = jsonConfig.getAutoSnappingButtonTitle();
        if (string != null) {
            object = string;
            bl2 = false;
            bl = false;
            Object it4 = object;
            boolean bl8 = false;
            this.setAutoSnappingButtonTitle((String)it4);
            unit50 = Unit.INSTANCE;
        } else {
            unit50 = null;
        }
        Boolean bl9 = jsonConfig.getAutoSnappingEnabled();
        if (bl9 != null) {
            object = bl9;
            bl2 = false;
            bl = false;
            boolean it5 = (Boolean)object;
            boolean bl10 = false;
            this.setAutoSnappingEnabled(it5);
            unit49 = Unit.INSTANCE;
        } else {
            unit49 = null;
        }
        Double d3 = jsonConfig.getAutoSnappingSensitivity();
        if (d3 != null) {
            object = d3;
            bl2 = false;
            bl = false;
            double it6 = ((Number)object).doubleValue();
            boolean bl11 = false;
            this.setAutoSnappingSensitivity((float)it6);
            unit48 = Unit.INSTANCE;
        } else {
            unit48 = null;
        }
        JsonColor jsonColor = jsonConfig.getBottomBarBackgroundColor();
        if (jsonColor != null) {
            object = jsonColor;
            bl2 = false;
            bl = false;
            Object it7 = object;
            boolean bl12 = false;
            this.setBottomBarBackgroundColor(it7.toSdk());
            unit47 = Unit.INSTANCE;
        } else {
            unit47 = null;
        }
        JsonColor jsonColor2 = jsonConfig.getBottomBarButtonsColor();
        if (jsonColor2 != null) {
            object = jsonColor2;
            bl2 = false;
            bl = false;
            Object it8 = object;
            boolean bl13 = false;
            this.setBottomBarButtonsColor(it8.toSdk());
            unit46 = Unit.INSTANCE;
        } else {
            unit46 = null;
        }
        JsonColor jsonColor3 = jsonConfig.getCameraBackgroundColor();
        if (jsonColor3 != null) {
            object = jsonColor3;
            bl2 = false;
            bl = false;
            Object it9 = object;
            boolean bl14 = false;
            this.setCameraBackgroundColor(it9.toSdk());
            unit45 = Unit.INSTANCE;
        } else {
            unit45 = null;
        }
        JsonCameraModule jsonCameraModule = jsonConfig.getCameraModule();
        if (jsonCameraModule != null) {
            object = jsonCameraModule;
            bl2 = false;
            bl = false;
            Object it10 = object;
            boolean bl15 = false;
            this.setCameraModule(CommonExtensionsKt.toSdk((JsonCameraModule)it10));
            unit44 = Unit.INSTANCE;
        } else {
            unit44 = null;
        }
        String string2 = jsonConfig.getCancelButtonTitle();
        if (string2 != null) {
            object = string2;
            bl2 = false;
            bl = false;
            Object it11 = object;
            boolean bl16 = false;
            this.setCancelButtonTitle((String)it11);
            unit43 = Unit.INSTANCE;
        } else {
            unit43 = null;
        }
        JsonSize jsonSize = jsonConfig.getDocumentImageSizeLimit();
        if (jsonSize != null) {
            object = jsonSize;
            bl2 = false;
            bl = false;
            Object it12 = object;
            boolean bl17 = false;
            this.setDocumentImageSizeLimit((int)it12.getWidth(), (int)it12.getHeight());
            unit42 = Unit.INSTANCE;
        } else {
            unit42 = null;
        }
        String string3 = jsonConfig.getEnableCameraButtonTitle();
        if (string3 != null) {
            object = string3;
            bl2 = false;
            bl = false;
            Object it13 = object;
            boolean bl18 = false;
            this.setEnableCameraButtonTitle((String)it13);
            unit41 = Unit.INSTANCE;
        } else {
            unit41 = null;
        }
        String string4 = jsonConfig.getEnableCameraExplanationText();
        if (string4 != null) {
            object = string4;
            bl2 = false;
            bl = false;
            Object it14 = object;
            boolean bl19 = false;
            this.setEnableCameraExplanationText((String)it14);
            unit40 = Unit.INSTANCE;
        } else {
            unit40 = null;
        }
        Boolean bl20 = jsonConfig.getFlashButtonHidden();
        if (bl20 != null) {
            object = bl20;
            bl2 = false;
            bl = false;
            boolean it15 = (Boolean)object;
            boolean bl21 = false;
            this.setFlashButtonHidden(it15);
            unit39 = Unit.INSTANCE;
        } else {
            unit39 = null;
        }
        String string5 = jsonConfig.getFlashButtonTitle();
        if (string5 != null) {
            object = string5;
            bl2 = false;
            bl = false;
            Object it16 = object;
            boolean bl22 = false;
            this.setFlashButtonTitle((String)it16);
            unit38 = Unit.INSTANCE;
        } else {
            unit38 = null;
        }
        Boolean bl23 = jsonConfig.getFlashEnabled();
        if (bl23 != null) {
            object = bl23;
            bl2 = false;
            bl = false;
            boolean it17 = (Boolean)object;
            boolean bl24 = false;
            this.setFlashEnabled(it17);
            unit37 = Unit.INSTANCE;
        } else {
            unit37 = null;
        }
        Boolean bl25 = jsonConfig.getIgnoreBadAspectRatio();
        if (bl25 != null) {
            object = bl25;
            bl2 = false;
            bl = false;
            boolean it18 = (Boolean)object;
            boolean bl26 = false;
            this.setIgnoreBadAspectRatio(it18);
            unit36 = Unit.INSTANCE;
        } else {
            unit36 = null;
        }
        Double d4 = jsonConfig.getImageScale();
        if (d4 != null) {
            object = d4;
            bl2 = false;
            bl = false;
            double it19 = ((Number)object).doubleValue();
            boolean bl27 = false;
            this.setImageScale((float)it19);
            unit35 = Unit.INSTANCE;
        } else {
            unit35 = null;
        }
        JsonInterfaceOrientation jsonInterfaceOrientation = jsonConfig.getInterfaceOrientation();
        if (jsonInterfaceOrientation != null) {
            object = jsonInterfaceOrientation;
            bl2 = false;
            bl = false;
            Object it20 = object;
            boolean bl28 = false;
            CameraOrientationMode cameraOrientationMode = CommonExtensionsKt.toSdk((JsonInterfaceOrientation)it20);
            if (cameraOrientationMode != null) {
                CameraOrientationMode bl27 = cameraOrientationMode;
                boolean bl29 = false;
                boolean bl30 = false;
                CameraOrientationMode lockMode = bl27;
                boolean bl31 = false;
                this.setOrientationLockMode(lockMode);
                unit34 = Unit.INSTANCE;
            } else {
                unit34 = null;
            }
        } else {
            unit34 = null;
        }
        Integer n = jsonConfig.getMaxNumberOfPages();
        if (n != null) {
            object = n;
            bl2 = false;
            bl = false;
            int it21 = ((Number)object).intValue();
            boolean bl32 = false;
            this.setMaxNumberOfPages(it21);
            unit33 = Unit.INSTANCE;
        } else {
            unit33 = null;
        }
        Boolean bl33 = jsonConfig.getMultiPageButtonHidden();
        if (bl33 != null) {
            object = bl33;
            bl2 = false;
            bl = false;
            boolean it22 = (Boolean)object;
            boolean bl34 = false;
            this.setMultiPageButtonHidden(it22);
            unit32 = Unit.INSTANCE;
        } else {
            unit32 = null;
        }
        String string6 = jsonConfig.getMultiPageButtonTitle();
        if (string6 != null) {
            object = string6;
            bl2 = false;
            bl = false;
            Object it23 = object;
            boolean bl35 = false;
            this.setMultiPageButtonTitle((String)it23);
            unit31 = Unit.INSTANCE;
        } else {
            unit31 = null;
        }
        Boolean bl36 = jsonConfig.getMultiPageEnabled();
        if (bl36 != null) {
            object = bl36;
            bl2 = false;
            bl = false;
            boolean it24 = (Boolean)object;
            boolean bl37 = false;
            this.setMultiPageEnabled(it24);
            unit30 = Unit.INSTANCE;
        } else {
            unit30 = null;
        }
        String string7 = jsonConfig.getPageCounterButtonTitle();
        if (string7 != null) {
            object = string7;
            bl2 = false;
            bl = false;
            Object it25 = object;
            boolean bl38 = false;
            this.setPageCounterButtonTitle((String)it25);
            unit29 = Unit.INSTANCE;
        } else {
            unit29 = null;
        }
        JsonColor jsonColor4 = jsonConfig.getPolygonAutoSnapProgressColor();
        if (jsonColor4 != null) {
            object = jsonColor4;
            bl2 = false;
            bl = false;
            Object it26 = object;
            boolean bl39 = false;
            this.setPolygonAutoSnapProgressColor(it26.toSdk());
            unit28 = Unit.INSTANCE;
        } else {
            unit28 = null;
        }
        Boolean bl40 = jsonConfig.getPolygonAutoSnapProgressEnabled();
        if (bl40 != null) {
            object = bl40;
            bl2 = false;
            bl = false;
            boolean it27 = (Boolean)object;
            boolean bl41 = false;
            this.setPolygonAutoSnapProgressEnabled(it27);
            unit27 = Unit.INSTANCE;
        } else {
            unit27 = null;
        }
        Double d5 = jsonConfig.getPolygonAutoSnapProgressLineWidth();
        if (d5 != null) {
            object = d5;
            bl2 = false;
            bl = false;
            double it28 = ((Number)object).doubleValue();
            boolean bl42 = false;
            this.setPolygonAutoSnapProgressLineWidth((int)it28);
            unit26 = Unit.INSTANCE;
        } else {
            unit26 = null;
        }
        JsonColor jsonColor5 = jsonConfig.getPolygonBackgroundColor();
        if (jsonColor5 != null) {
            object = jsonColor5;
            bl2 = false;
            bl = false;
            Object it29 = object;
            boolean bl43 = false;
            this.setPolygonBackgroundColor(it29.toSdk());
            unit25 = Unit.INSTANCE;
        } else {
            unit25 = null;
        }
        JsonColor jsonColor6 = jsonConfig.getPolygonBackgroundColorOK();
        if (jsonColor6 != null) {
            object = jsonColor6;
            bl2 = false;
            bl = false;
            Object it30 = object;
            boolean bl44 = false;
            this.setPolygonBackgroundColorOK(it30.toSdk());
            unit24 = Unit.INSTANCE;
        } else {
            unit24 = null;
        }
        JsonColor jsonColor7 = jsonConfig.getPolygonColor();
        if (jsonColor7 != null) {
            object = jsonColor7;
            bl2 = false;
            bl = false;
            Object it31 = object;
            boolean bl45 = false;
            this.setPolygonColor(it31.toSdk());
            unit23 = Unit.INSTANCE;
        } else {
            unit23 = null;
        }
        JsonColor jsonColor8 = jsonConfig.getPolygonColorOK();
        if (jsonColor8 != null) {
            object = jsonColor8;
            bl2 = false;
            bl = false;
            Object it32 = object;
            boolean bl46 = false;
            this.setPolygonColorOK(it32.toSdk());
            unit22 = Unit.INSTANCE;
        } else {
            unit22 = null;
        }
        Double d6 = jsonConfig.getPolygonCornerRadius();
        if (d6 != null) {
            object = d6;
            bl2 = false;
            bl = false;
            double it33 = ((Number)object).doubleValue();
            boolean bl47 = false;
            this.setPolygonCornerRadius((int)it33);
            unit21 = Unit.INSTANCE;
        } else {
            unit21 = null;
        }
        Double d7 = jsonConfig.getPolygonLineWidth();
        if (d7 != null) {
            object = d7;
            bl2 = false;
            bl = false;
            double it34 = ((Number)object).doubleValue();
            boolean bl48 = false;
            this.setPolygonLineWidth((int)it34);
            unit20 = Unit.INSTANCE;
        } else {
            unit20 = null;
        }
        JsonColor jsonColor9 = jsonConfig.getShutterButtonAutoInnerColor();
        if (jsonColor9 != null) {
            object = jsonColor9;
            bl2 = false;
            bl = false;
            Object it35 = object;
            boolean bl49 = false;
            this.setShutterButtonAutoInnerColor(it35.toSdk());
            unit19 = Unit.INSTANCE;
        } else {
            unit19 = null;
        }
        JsonColor jsonColor10 = jsonConfig.getShutterButtonAutoOuterColor();
        if (jsonColor10 != null) {
            object = jsonColor10;
            bl2 = false;
            bl = false;
            Object it36 = object;
            boolean bl50 = false;
            this.setShutterButtonAutoOuterColor(it36.toSdk());
            unit18 = Unit.INSTANCE;
        } else {
            unit18 = null;
        }
        Boolean bl51 = jsonConfig.getShutterButtonHidden();
        if (bl51 != null) {
            object = bl51;
            bl2 = false;
            bl = false;
            boolean it37 = (Boolean)object;
            boolean bl52 = false;
            this.setShutterButtonHidden(it37);
            unit17 = Unit.INSTANCE;
        } else {
            unit17 = null;
        }
        JsonColor jsonColor11 = jsonConfig.getShutterButtonIndicatorColor();
        if (jsonColor11 != null) {
            object = jsonColor11;
            bl2 = false;
            bl = false;
            Object it38 = object;
            boolean bl53 = false;
            this.setShutterButtonAutoInnerColor(it38.toSdk());
            unit16 = Unit.INSTANCE;
        } else {
            unit16 = null;
        }
        JsonColor jsonColor12 = jsonConfig.getShutterButtonManualInnerColor();
        if (jsonColor12 != null) {
            object = jsonColor12;
            bl2 = false;
            bl = false;
            Object it39 = object;
            boolean bl54 = false;
            this.setShutterButtonManualInnerColor(it39.toSdk());
            unit15 = Unit.INSTANCE;
        } else {
            unit15 = null;
        }
        JsonColor jsonColor13 = jsonConfig.getShutterButtonManualOuterColor();
        if (jsonColor13 != null) {
            object = jsonColor13;
            bl2 = false;
            bl = false;
            Object it40 = object;
            boolean bl55 = false;
            this.setShutterButtonManualOuterColor(it40.toSdk());
            unit14 = Unit.INSTANCE;
        } else {
            unit14 = null;
        }
        String string8 = jsonConfig.getTextHintBadAngles();
        if (string8 != null) {
            object = string8;
            bl2 = false;
            bl = false;
            Object it41 = object;
            boolean bl56 = false;
            this.setTextHintBadAngles((String)it41);
            unit13 = Unit.INSTANCE;
        } else {
            unit13 = null;
        }
        String string9 = jsonConfig.getTextHintBadAspectRatio();
        if (string9 != null) {
            object = string9;
            bl2 = false;
            bl = false;
            Object it42 = object;
            boolean bl57 = false;
            this.setTextHintBadAspectRatio((String)it42);
            unit12 = Unit.INSTANCE;
        } else {
            unit12 = null;
        }
        String string10 = jsonConfig.getTextHintNothingDetected();
        if (string10 != null) {
            object = string10;
            bl2 = false;
            bl = false;
            Object it43 = object;
            boolean bl58 = false;
            this.setTextHintNothingDetected((String)it43);
            unit11 = Unit.INSTANCE;
        } else {
            unit11 = null;
        }
        String string11 = jsonConfig.getTextHintOK();
        if (string11 != null) {
            object = string11;
            bl2 = false;
            bl = false;
            Object it44 = object;
            boolean bl59 = false;
            this.setTextHintOK((String)it44);
            unit10 = Unit.INSTANCE;
        } else {
            unit10 = null;
        }
        String string12 = jsonConfig.getTextHintTooDark();
        if (string12 != null) {
            object = string12;
            bl2 = false;
            bl = false;
            Object it45 = object;
            boolean bl60 = false;
            this.setTextHintTooDark((String)it45);
            unit9 = Unit.INSTANCE;
        } else {
            unit9 = null;
        }
        String string13 = jsonConfig.getTextHintTooNoisy();
        if (string13 != null) {
            object = string13;
            bl2 = false;
            bl = false;
            Object it46 = object;
            boolean bl61 = false;
            this.setTextHintTooNoisy((String)it46);
            unit8 = Unit.INSTANCE;
        } else {
            unit8 = null;
        }
        String string14 = jsonConfig.getTextHintTooSmall();
        if (string14 != null) {
            object = string14;
            bl2 = false;
            bl = false;
            Object it47 = object;
            boolean bl62 = false;
            this.setTextHintTooSmall((String)it47);
            unit7 = Unit.INSTANCE;
        } else {
            unit7 = null;
        }
        JsonColor jsonColor14 = jsonConfig.getTopBarBackgroundColor();
        if (jsonColor14 != null) {
            object = jsonColor14;
            bl2 = false;
            bl = false;
            Object it48 = object;
            boolean bl63 = false;
            this.setTopBarBackgroundColor(it48.toSdk());
            unit6 = Unit.INSTANCE;
        } else {
            unit6 = null;
        }
        JsonColor jsonColor15 = jsonConfig.getTopBarButtonsActiveColor();
        if (jsonColor15 != null) {
            object = jsonColor15;
            bl2 = false;
            bl = false;
            Object it49 = object;
            boolean bl64 = false;
            this.setTopBarButtonsActiveColor(it49.toSdk());
            unit5 = Unit.INSTANCE;
        } else {
            unit5 = null;
        }
        JsonColor jsonColor16 = jsonConfig.getTopBarButtonsInactiveColor();
        if (jsonColor16 != null) {
            object = jsonColor16;
            bl2 = false;
            bl = false;
            Object it50 = object;
            boolean bl65 = false;
            this.setTopBarButtonsInactiveColor(it50.toSdk());
            unit4 = Unit.INSTANCE;
        } else {
            unit4 = null;
        }
        Boolean bl66 = jsonConfig.getUseButtonsAllCaps();
        if (bl66 != null) {
            object = bl66;
            bl2 = false;
            bl = false;
            boolean it51 = (Boolean)object;
            boolean bl67 = false;
            this.setUseButtonsAllCaps(it51);
            unit3 = Unit.INSTANCE;
        } else {
            unit3 = null;
        }
        JsonColor jsonColor17 = jsonConfig.getUserGuidanceBackgroundColor();
        if (jsonColor17 != null) {
            object = jsonColor17;
            bl2 = false;
            bl = false;
            Object it52 = object;
            boolean bl68 = false;
            this.setUserGuidanceBackgroundColor(it52.toSdk());
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        JsonColor jsonColor18 = jsonConfig.getUserGuidanceTextColor();
        if (jsonColor18 != null) {
            object = jsonColor18;
            bl2 = false;
            bl = false;
            Object it53 = object;
            boolean bl69 = false;
            this.setUserGuidanceTextColor(it53.toSdk());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerConfiguration$Companion;", "", "()V", "fromJson", "Lio/scanbot/sdk/ui/view/camera/configuration/DocumentScannerConfiguration;", "input", "", "rtu-ui-docdetector_release"})
    public static final class Companion {
        @NotNull
        public final DocumentScannerConfiguration fromJson(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            DocumentScannerJsonConfiguration jsonConfig = (DocumentScannerJsonConfiguration)gson.fromJson(input, DocumentScannerJsonConfiguration.class);
            DocumentScannerConfiguration documentScannerConfiguration = new DocumentScannerConfiguration();
            boolean bl = false;
            boolean bl2 = false;
            DocumentScannerConfiguration $this$apply = documentScannerConfiguration;
            boolean bl3 = false;
            DocumentScannerJsonConfiguration documentScannerJsonConfiguration = jsonConfig;
            Intrinsics.checkNotNullExpressionValue((Object)documentScannerJsonConfiguration, (String)"jsonConfig");
            $this$apply.modifyFromJsonConfiguration(documentScannerJsonConfiguration);
            return documentScannerConfiguration;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

