/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.genericdocument;

import io.reactivex.Observable;
import io.reactivex.subjects.BehaviorSubject;
import io.scanbot.genericdocument.entity.GenericDocument;
import io.scanbot.genericdocument.entity.GenericDocumentLibrary;
import io.scanbot.genericdocument.entity.GenericDocumentWrapper;
import io.scanbot.genericdocument.entity.RootDocumentType;
import io.scanbot.sdk.genericdocument.GenericDocumentRecognitionResult;
import io.scanbot.sdk.genericdocument.GenericDocumentRecognizer;
import io.scanbot.sdk.ui.view.genericdocument.DocumentRecognitionPack;
import io.scanbot.sdk.ui.view.genericdocument.DocumentRecognitionPacks;
import io.scanbot.sdk.ui.view.genericdocument.DocumentRecognitionState;
import io.scanbot.sdk.ui.view.genericdocument.DocumentRecognitionStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aJ\b\u0010\u001b\u001a\u00020\rH\u0002J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001dJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u001dJ\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\rJ\u000e\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\rJ\b\u0010)\u001a\u00020\u0018H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/scanbot/sdk/ui/view/genericdocument/GenericDocumentScanningSession;", "", "genericDocumentRecognizer", "Lio/scanbot/sdk/genericdocument/GenericDocumentRecognizer;", "(Lio/scanbot/sdk/genericdocument/GenericDocumentRecognizer;)V", "currentPack", "Lio/scanbot/sdk/ui/view/genericdocument/DocumentRecognitionPack;", "documentsState", "", "Lio/scanbot/genericdocument/entity/GenericDocument$Type;", "Lio/scanbot/genericdocument/entity/GenericDocument;", "scanPausedSubject", "Lio/reactivex/subjects/BehaviorSubject;", "", "scanReadyStateSubject", "stateSubject", "Lio/scanbot/sdk/ui/view/genericdocument/DocumentRecognitionState;", "allSidesScanned", "pack", "averageConfidence", "", "calculateStep", "Lio/scanbot/sdk/ui/view/genericdocument/DocumentRecognitionStep;", "clear", "", "getAllDocuments", "", "isHighAverageConfidence", "observeDocumentRecognitionResults", "Lio/reactivex/Observable;", "observeScanReadyState", "observeScanningPausedState", "processTwoSided", "Lio/scanbot/sdk/ui/view/genericdocument/DocumentRecognitionPack$TwoSidedPack;", "pushNewDocumentRecognitionResult", "result", "Lio/scanbot/sdk/genericdocument/GenericDocumentRecognitionResult;", "pushScanReadyState", "ready", "pushScanningPausedState", "opened", "updateState", "Companion", "rtu-ui-genericdocument_release"})
public final class GenericDocumentScanningSession {
    private final Map<GenericDocument.Type, GenericDocument> documentsState;
    private final BehaviorSubject<DocumentRecognitionState> stateSubject;
    private final BehaviorSubject<Boolean> scanReadyStateSubject;
    private final BehaviorSubject<Boolean> scanPausedSubject;
    private DocumentRecognitionPack currentPack;
    private final GenericDocumentRecognizer genericDocumentRecognizer;
    public static final double ZERO_CONFIDENCE_VALUE = 0.0;
    public static final double MODERATE_CONFIDENCE_VALUE = 0.5;
    public static final double HIGH_CONFIDENCE_VALUE = 0.9;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Observable<DocumentRecognitionState> observeDocumentRecognitionResults() {
        return (Observable)this.stateSubject;
    }

    public final void pushNewDocumentRecognitionResult(@NotNull GenericDocumentRecognitionResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        GenericDocument genericDocument = result.getDocument();
        if (genericDocument != null) {
            Object v1;
            GenericDocument.Type type;
            GenericDocument document;
            block5: {
                GenericDocument genericDocument2 = genericDocument;
                boolean bl = false;
                boolean bl2 = false;
                document = genericDocument2;
                boolean bl3 = false;
                type = document.getType();
                Iterable iterable = DocumentRecognitionPacks.INSTANCE.getPacks();
                boolean bl4 = false;
                Iterable iterable2 = iterable;
                boolean bl5 = false;
                for (Object t : iterable2) {
                    DocumentRecognitionPack it = (DocumentRecognitionPack)t;
                    boolean bl6 = false;
                    if (!it.contains(type)) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            DocumentRecognitionPack documentRecognitionPack = v1;
            if (documentRecognitionPack == null) {
                return;
            }
            DocumentRecognitionPack typePack = documentRecognitionPack;
            if (this.currentPack != null && Intrinsics.areEqual((Object)typePack, (Object)this.currentPack) ^ true) {
                return;
            }
            this.currentPack = typePack;
            GenericDocumentWrapper wrap = GenericDocumentLibrary.INSTANCE.wrap(document);
            this.documentsState.put(type, document);
            this.updateState();
        } else {
            this.updateState();
        }
    }

    @NotNull
    public final Observable<Boolean> observeScanReadyState() {
        return (Observable)this.scanReadyStateSubject;
    }

    @NotNull
    public final Observable<Boolean> observeScanningPausedState() {
        return (Observable)this.scanPausedSubject;
    }

    public final void pushScanReadyState(boolean ready) {
        this.scanReadyStateSubject.onNext((Object)ready);
    }

    public final void pushScanningPausedState(boolean opened) {
        this.scanPausedSubject.onNext((Object)opened);
    }

    public final void clear() {
        this.genericDocumentRecognizer.clear();
        this.documentsState.clear();
        this.currentPack = null;
        this.updateState();
    }

    @NotNull
    public final Set<GenericDocument> getAllDocuments() {
        return CollectionsKt.toSet((Iterable)this.documentsState.values());
    }

    private final void updateState() {
        this.stateSubject.onNext((Object)new DocumentRecognitionState(this.averageConfidence(), this.calculateStep(), MapsKt.toMap(this.documentsState)));
    }

    /*
     * WARNING - void declaration
     */
    private final double averageConfidence() {
        void $this$mapTo$iv$iv;
        Float f;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv2;
        if (this.documentsState.isEmpty()) {
            return 0.0;
        }
        Map<GenericDocument.Type, GenericDocument> $this$map$iv = this.documentsState;
        boolean $i$f$map = false;
        Map<GenericDocument.Type, GenericDocument> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo22 = false;
        void var7_9 = $this$mapTo$iv$iv2;
        boolean bl = false;
        for (Map.Entry item$iv$iv : var7_9.entrySet()) {
            void it;
            object = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            f = Float.valueOf(((GenericDocument)it.getValue()).getConfidence() * ((GenericDocument)it.getValue()).getConfidenceWeight());
            collection.add(f);
        }
        float weightedConf = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv));
        Map<GenericDocument.Type, GenericDocument> $this$map$iv2 = this.documentsState;
        boolean $i$f$map2 = false;
        Map<GenericDocument.Type, GenericDocument> $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv;
        boolean bl3 = false;
        object = iterator.entrySet().iterator();
        while (object.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)object.next();
            collection = destination$iv$iv2;
            boolean bl4 = false;
            f = Float.valueOf(((GenericDocument)it.getValue()).getConfidenceWeight());
            collection.add(f);
        }
        double weights = CollectionsKt.sumOfFloat((Iterable)((List)destination$iv$iv2));
        if (weights == 0.0) {
            return 1.0;
        }
        return (double)weightedConf / weights;
    }

    private final DocumentRecognitionStep calculateStep() {
        Object object;
        block10: {
            block9: {
                DocumentRecognitionStep documentRecognitionStep;
                object = this.currentPack;
                if (object == null) break block9;
                DocumentRecognitionPack documentRecognitionPack = object;
                boolean bl = false;
                boolean bl2 = false;
                DocumentRecognitionPack pack = documentRecognitionPack;
                boolean bl3 = false;
                if (this.allSidesScanned(pack)) {
                    documentRecognitionStep = this.isHighAverageConfidence() ? DocumentRecognitionStep.ALL_DONE : DocumentRecognitionStep.SCANNING_FRONT;
                } else {
                    DocumentRecognitionPack documentRecognitionPack2 = pack;
                    if (documentRecognitionPack2 instanceof DocumentRecognitionPack.TwoSidedPack) {
                        documentRecognitionStep = this.processTwoSided((DocumentRecognitionPack.TwoSidedPack)pack);
                    } else if (documentRecognitionPack2 instanceof DocumentRecognitionPack.OneSidedPack) {
                        documentRecognitionStep = DocumentRecognitionStep.SCANNING_FRONT;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                object = documentRecognitionStep;
                if (documentRecognitionStep != null) break block10;
            }
            object = DocumentRecognitionStep.INITIAL;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean allSidesScanned(DocumentRecognitionPack pack) {
        Collection<GenericDocument.Type> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = pack.getAllTypes();
        Set<GenericDocument.Type> set = this.documentsState.keySet();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RootDocumentType rootDocumentType = (RootDocumentType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            GenericDocument.Type type = it.getType();
            collection.add(type);
        }
        collection = (List)destination$iv$iv;
        return set.containsAll(collection);
    }

    private final DocumentRecognitionStep processTwoSided(DocumentRecognitionPack.TwoSidedPack pack) {
        return this.documentsState.containsKey(pack.getFrontType().getType()) ? (this.isHighAverageConfidence() ? DocumentRecognitionStep.FRONT_DONE : DocumentRecognitionStep.SCANNING_FRONT) : (this.documentsState.containsKey(pack.getBackType().getType()) ? (this.isHighAverageConfidence() ? DocumentRecognitionStep.BACK_DONE : DocumentRecognitionStep.SCANNING_BACK) : DocumentRecognitionStep.INITIAL);
    }

    private final boolean isHighAverageConfidence() {
        return this.averageConfidence() > 0.9;
    }

    public GenericDocumentScanningSession(@NotNull GenericDocumentRecognizer genericDocumentRecognizer) {
        Intrinsics.checkNotNullParameter((Object)genericDocumentRecognizer, (String)"genericDocumentRecognizer");
        this.genericDocumentRecognizer = genericDocumentRecognizer;
        boolean bl = false;
        this.documentsState = new LinkedHashMap();
        bl = false;
        BehaviorSubject behaviorSubject = BehaviorSubject.createDefault((Object)new DocumentRecognitionState(0.0, DocumentRecognitionStep.NOT_READY, MapsKt.emptyMap()));
        Intrinsics.checkNotNullExpressionValue((Object)behaviorSubject, (String)"BehaviorSubject.createDe\u2026  mapOf()\n        )\n    )");
        this.stateSubject = behaviorSubject;
        BehaviorSubject behaviorSubject2 = BehaviorSubject.createDefault((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)behaviorSubject2, (String)"BehaviorSubject.createDefault(false)");
        this.scanReadyStateSubject = behaviorSubject2;
        BehaviorSubject behaviorSubject3 = BehaviorSubject.createDefault((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)behaviorSubject3, (String)"BehaviorSubject.createDefault(false)");
        this.scanPausedSubject = behaviorSubject3;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/genericdocument/GenericDocumentScanningSession$Companion;", "", "()V", "HIGH_CONFIDENCE_VALUE", "", "MODERATE_CONFIDENCE_VALUE", "ZERO_CONFIDENCE_VALUE", "rtu-ui-genericdocument_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

