/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.generictext.configuration;

import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import com.google.gson.Gson;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.ui.configuration.json.CommonExtensionsKt;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonCameraModule;
import io.scanbot.sdk.ui.configuration.json.JsonColor;
import io.scanbot.sdk.ui.configuration.json.JsonOrientationLockMode;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.generictext.configuration.TextDataScannerConfigurationParams;
import io.scanbot.sdk.ui.view.generictext.configuration.json.TextDataScannerJsonConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 ?2\u00020\u0001:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\b\b\u0001\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\n2\b\b\u0001\u0010\u0017\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0005J\u0010\u0010\u001e\u001a\u00020\n2\b\b\u0001\u0010\u001f\u001a\u00020\u0012J\u0010\u0010 \u001a\u00020\n2\b\b\u0001\u0010!\u001a\u00020\u0012J\u0010\u0010\"\u001a\u00020\n2\b\b\u0001\u0010#\u001a\u00020\u0012J\u000e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0012J\u000e\u0010)\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0012J\u0010\u0010*\u001a\u00020\n2\b\b\u0001\u0010+\u001a\u00020\u0012J\u000e\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.J\u0014\u0010/\u001a\u00020\n2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201J\u0010\u00103\u001a\u00020\n2\b\b\u0001\u00104\u001a\u00020\u0012J\u0010\u00105\u001a\u00020\n2\b\b\u0001\u00106\u001a\u00020\u0012J\u0010\u00107\u001a\u00020\n2\b\b\u0001\u00108\u001a\u00020\u0012J\u000e\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020&J\u0010\u0010;\u001a\u00020\n2\b\b\u0001\u0010<\u001a\u00020\u0012J\u000e\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020&R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006@"}, d2={"Lio/scanbot/sdk/ui/view/generictext/configuration/TextDataScannerConfiguration;", "", "()V", "dataScannerConfiguration", "", "", "Ljava/io/Serializable;", "getDataScannerConfiguration", "()Ljava/util/Map;", "modifyFromJsonConfiguration", "", "jsonConfig", "Lio/scanbot/sdk/ui/view/generictext/configuration/json/TextDataScannerJsonConfiguration;", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOverlayColor", "cameraOverlayColor", "", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setCancelButtonIcon", "cancelButtonIcon", "setCancelButtonTitle", "cancelButtonTitle", "setEnableCameraButtonTitle", "enableCameraButtonTitle", "setEnableCameraExplanationText", "enableCameraExplanationText", "setFinderLineColor", "finderLineColor", "setFinderLineWidth", "finderLineWidth", "setFinderTextHintColor", "finderTextHintColor", "setFlashEnabled", "flashEnabled", "", "setMaximumNumberOfAccumulatedFrames", "numberOfFrames", "setMinimumNumberOfRequiredFramesWithEqualRecognitionResult", "setOcrResolutionLimit", "ocrResolutionLimit", "setOrientationLockMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setSupportedLanguages", "supportedLanguages", "", "Lio/scanbot/sdk/entity/Language;", "setTopBarBackgroundColor", "topBarBackgroundColor", "setTopBarButtonsColor", "topBarButtonsColor", "setTopBarButtonsInactiveColor", "topBarButtonsInactiveColor", "setUseButtonsAllCaps", "allCaps", "setWordBoxHighlightColor", "color", "setWordBoxHighlightEnabled", "enabled", "Companion", "rtu-ui-generictext_release"})
public final class TextDataScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Serializable> dataScannerConfiguration = new HashMap();

    @NotNull
    public final Map<String, Serializable> getDataScannerConfiguration() {
        return this.dataScannerConfiguration;
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        Boolean bl = flashEnabled;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.FLASH_ENABLED.getKey(), bl);
    }

    public final void setOrientationLockMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.ORIENTATION_LOCK_MODE.getKey(), (Serializable)cameraOrientationMode);
    }

    public final void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.CAMERA_MODULE.getKey(), (Serializable)cameraModule);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.CAMERA_PREVIEW_MODE.getKey(), (Serializable)cameraPreviewMode);
    }

    public final void setTopBarBackgroundColor(@ColorInt int topBarBackgroundColor) {
        Integer n = topBarBackgroundColor;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.TOP_BAR_BACKGROUND_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsColor(@ColorInt int topBarButtonsColor) {
        Integer n = topBarButtonsColor;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.TOP_BAR_BUTTONS_COLOR.getKey(), n);
    }

    public final void setTopBarButtonsInactiveColor(@ColorInt int topBarButtonsInactiveColor) {
        Integer n = topBarButtonsInactiveColor;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.TOP_BAR_BUTTONS_INACTIVE_COLOR.getKey(), n);
    }

    public final void setCameraOverlayColor(@ColorInt int cameraOverlayColor) {
        Integer n = cameraOverlayColor;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.CAMERA_OVERLAY_COLOR.getKey(), n);
    }

    public final void setFinderLineWidth(@Px int finderLineWidth) {
        Integer n = finderLineWidth;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.FINDER_LINE_WIDTH.getKey(), n);
    }

    public final void setFinderLineColor(@ColorInt int finderLineColor) {
        Integer n = finderLineColor;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.FINDER_LINE_COLOR.getKey(), n);
    }

    public final void setFinderTextHintColor(@ColorInt int finderTextHintColor) {
        Integer n = finderTextHintColor;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.FINDER_TEXT_HINT_COLOR.getKey(), n);
    }

    public final void setCancelButtonTitle(@NotNull String cancelButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)cancelButtonTitle, (String)"cancelButtonTitle");
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.CANCEL_BUTTON_TITLE.getKey(), (Serializable)((Object)cancelButtonTitle));
    }

    public final void setCancelButtonIcon(@DrawableRes int cancelButtonIcon) {
        Integer n = cancelButtonIcon;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.CANCEL_BUTTON_ICON.getKey(), n);
    }

    public final void setEnableCameraExplanationText(@NotNull String enableCameraExplanationText) {
        Intrinsics.checkNotNullParameter((Object)enableCameraExplanationText, (String)"enableCameraExplanationText");
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.ENABLE_CAMERA_EXPLANATION_TEXT.getKey(), (Serializable)((Object)enableCameraExplanationText));
    }

    public final void setEnableCameraButtonTitle(@NotNull String enableCameraButtonTitle) {
        Intrinsics.checkNotNullParameter((Object)enableCameraButtonTitle, (String)"enableCameraButtonTitle");
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.ENABLE_CAMERA_BUTTON_TITLE.getKey(), (Serializable)((Object)enableCameraButtonTitle));
    }

    public final void setWordBoxHighlightColor(@ColorInt int color) {
        Integer n = color;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.WORDBOX_HIGHLIGHT_COLOR.getKey(), n);
    }

    public final void setWordBoxHighlightEnabled(boolean enabled) {
        Boolean bl = enabled;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.WORDBOX_HIGHLIGHT_ENABLED.getKey(), bl);
    }

    public final void setMinimumNumberOfRequiredFramesWithEqualRecognitionResult(int numberOfFrames) {
        Integer n = numberOfFrames;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.MINIMUM_NUMBER_OF_REQUIRED_FRAMES_WITH_EQUAL_RECOGNITION_RESULT.getKey(), n);
    }

    public final void setMaximumNumberOfAccumulatedFrames(int numberOfFrames) {
        Integer n = numberOfFrames;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.MAXIMUM_NUMBER_OF_ACCUMULATED_FRAMES.getKey(), n);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSupportedLanguages(@NotNull Set<? extends Language> supportedLanguages) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(supportedLanguages, (String)"supportedLanguages");
        Map<String, Serializable> map = this.dataScannerConfiguration;
        String string = TextDataScannerConfigurationParams.SUPPORTED_LANGUAGES.getKey();
        Iterable $this$map$iv = supportedLanguages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Language language = (Language)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOcrBlobLanguageTag());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray2 = stringArray;
        map.put(string, (Serializable)stringArray2);
    }

    public final void setOcrResolutionLimit(@Px int ocrResolutionLimit) {
        Integer n = ocrResolutionLimit;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.OCR_RESOLUTION_LIMIT.getKey(), n);
    }

    public final void setUseButtonsAllCaps(boolean allCaps) {
        Boolean bl = allCaps;
        this.dataScannerConfiguration.put(TextDataScannerConfigurationParams.USE_BUTTONS_ALL_CAPS.getKey(), bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void modifyFromJsonConfiguration(@NotNull TextDataScannerJsonConfiguration jsonConfig) {
        block21: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
            JsonCameraModule jsonCameraModule = jsonConfig.getCameraModule();
            if (jsonCameraModule != null) {
                it = jsonCameraModule;
                boolean bl = false;
                this.setCameraModule(CommonExtensionsKt.toSdk((JsonCameraModule)it));
            }
            JsonColor jsonColor = jsonConfig.getCameraOverlayColor();
            if (jsonColor != null) {
                it = jsonColor;
                boolean bl = false;
                this.setCameraOverlayColor(it.toSdk());
            }
            String string = jsonConfig.getCancelButtonTitle();
            if (string != null) {
                it = string;
                boolean bl = false;
                this.setCancelButtonTitle((String)it);
            }
            String string2 = jsonConfig.getEnableCameraButtonTitle();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                this.setEnableCameraButtonTitle((String)it);
            }
            String string3 = jsonConfig.getEnableCameraExplanationText();
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                this.setEnableCameraExplanationText((String)it);
            }
            JsonColor jsonColor2 = jsonConfig.getFinderLineColor();
            if (jsonColor2 != null) {
                it = jsonColor2;
                boolean bl = false;
                this.setFinderLineColor(it.toSdk());
            }
            Double d = jsonConfig.getFinderLineWidth();
            if (d != null) {
                double it2 = ((Number)d).doubleValue();
                boolean bl = false;
                this.setFinderLineWidth((int)it2);
            }
            JsonColor jsonColor3 = jsonConfig.getFinderTextHintColor();
            if (jsonColor3 != null) {
                JsonColor it3 = jsonColor3;
                boolean bl = false;
                this.setFinderTextHintColor(it3.toSdk());
            }
            Boolean bl = jsonConfig.getFlashEnabled();
            if (bl != null) {
                boolean it4 = bl;
                boolean bl2 = false;
                this.setFlashEnabled(it4);
            }
            JsonOrientationLockMode jsonOrientationLockMode = jsonConfig.getOrientationLockMode();
            if (jsonOrientationLockMode != null) {
                JsonOrientationLockMode it5 = jsonOrientationLockMode;
                boolean bl3 = false;
                CameraOrientationMode cameraOrientationMode = CommonExtensionsKt.toSdk((JsonOrientationLockMode)it5);
                if (cameraOrientationMode != null) {
                    CameraOrientationMode lockMode = cameraOrientationMode;
                    boolean bl4 = false;
                    this.setOrientationLockMode(lockMode);
                }
            }
            JsonColor jsonColor4 = jsonConfig.getTopBarBackgroundColor();
            if (jsonColor4 != null) {
                JsonColor it6 = jsonColor4;
                boolean bl5 = false;
                this.setTopBarBackgroundColor(it6.toSdk());
            }
            JsonColor jsonColor5 = jsonConfig.getTopBarButtonsActiveColor();
            if (jsonColor5 != null) {
                JsonColor it7 = jsonColor5;
                boolean bl6 = false;
                this.setTopBarButtonsColor(it7.toSdk());
            }
            JsonColor jsonColor6 = jsonConfig.getTopBarButtonsInactiveColor();
            if (jsonColor6 != null) {
                JsonColor it8 = jsonColor6;
                boolean bl7 = false;
                this.setTopBarButtonsInactiveColor(it8.toSdk());
            }
            JsonColor jsonColor7 = jsonConfig.getWordBoxHighlightColor();
            if (jsonColor7 != null) {
                JsonColor it9 = jsonColor7;
                boolean bl8 = false;
                this.setWordBoxHighlightColor(it9.toSdk());
            }
            Boolean bl9 = jsonConfig.getWordBoxHighlightEnabled();
            if (bl9 != null) {
                boolean it10 = bl9;
                boolean bl10 = false;
                this.setWordBoxHighlightEnabled(it10);
            }
            Integer n = jsonConfig.getMinimumNumberOfRequiredFramesWithEqualRecognitionResult();
            if (n != null) {
                int it11 = ((Number)n).intValue();
                boolean bl11 = false;
                this.setMinimumNumberOfRequiredFramesWithEqualRecognitionResult(it11);
            }
            Integer n2 = jsonConfig.getMaximumNumberOfAccumulatedFrames();
            if (n2 != null) {
                int it12 = ((Number)n2).intValue();
                boolean bl12 = false;
                this.setMaximumNumberOfAccumulatedFrames(it12);
            }
            List<String> list = jsonConfig.getSupportedLanguages();
            if (list != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                List<String> it13 = list;
                boolean bl13 = false;
                Iterable lockMode = it13;
                TextDataScannerConfiguration textDataScannerConfiguration = this;
                boolean $i$f$mapNotNull = false;
                void var7_25 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Language it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl14 = false;
                    String tag = (String)element$iv$iv;
                    boolean bl15 = false;
                    if (Language.Companion.languageByLanguageTag(tag) == null) continue;
                    boolean bl16 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                textDataScannerConfiguration.setSupportedLanguages(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
            }
            Long l = jsonConfig.getOcrResolutionLimit();
            if (l != null) {
                long it14 = ((Number)l).longValue();
                boolean bl17 = false;
                this.setOcrResolutionLimit((int)it14);
            }
            Boolean bl18 = jsonConfig.getUseButtonsAllCaps();
            if (bl18 == null) break block21;
            boolean it15 = bl18;
            boolean bl19 = false;
            this.setUseButtonsAllCaps(it15);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/generictext/configuration/TextDataScannerConfiguration$Companion;", "", "()V", "fromJson", "Lio/scanbot/sdk/ui/view/generictext/configuration/TextDataScannerConfiguration;", "input", "", "rtu-ui-generictext_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextDataScannerConfiguration fromJson(@NotNull String input) {
            TextDataScannerConfiguration textDataScannerConfiguration;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            TextDataScannerJsonConfiguration jsonConfig = (TextDataScannerJsonConfiguration)gson.fromJson(input, TextDataScannerJsonConfiguration.class);
            TextDataScannerConfiguration $this$fromJson_u24lambda_u2d0 = textDataScannerConfiguration = new TextDataScannerConfiguration();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)jsonConfig, (String)"jsonConfig");
            $this$fromJson_u24lambda_u2d0.modifyFromJsonConfiguration(jsonConfig);
            return textDataScannerConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

