/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.idcard.list;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.BehaviorProcessor;
import io.scanbot.sdk.idcardscanner.IdScanResult;
import io.scanbot.sdk.ui.utils.CrossViewStatePresenter;
import io.scanbot.sdk.ui.utils.StatelessView;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.idcard.LastScannedIdCardHolder;
import io.scanbot.sdk.ui.view.idcard.entity.IdCardImagesResult;
import io.scanbot.sdk.ui.view.idcard.entity.IdCardScanningResult;
import io.scanbot.sdk.ui.view.idcard.entity.IdCardTextFieldResult;
import io.scanbot.sdk.ui.view.idcard.interactor.SaveIdCardImagesUseCase;
import io.scanbot.sdk.ui.view.idcard.list.IIdCardFieldListView;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter$WhenMappings;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u00018B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0002J$\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u001a\u001a\u00020\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\f\u001a\u00020\u001cH\u0016J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u00172\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0002J\u001e\u0010 \u001a\u0004\u0018\u00010\u00172\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015H\u0002J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J.\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010+\u001a\u00020#H\u0002J\b\u0010,\u001a\u00020\u001cH\u0016J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u0003H\u0016J\u000e\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\rJ\u000e\u00102\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\rJ\b\u00103\u001a\u00020\u001cH\u0016J&\u00104\u001a\u0004\u0018\u0001052\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u00107\u001a\u00020\u0016H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListPresenter;", "Lio/scanbot/sdk/ui/utils/CrossViewStatePresenter;", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView$State;", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView;", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView$Listener;", "navigator", "Lio/scanbot/sdk/ui/utils/navigator/Navigator;", "lastScannedIdCardHolder", "Lio/scanbot/sdk/ui/view/idcard/LastScannedIdCardHolder;", "saveIdCardImagesUseCase", "Lio/scanbot/sdk/ui/view/idcard/interactor/SaveIdCardImagesUseCase;", "(Lio/scanbot/sdk/ui/utils/navigator/Navigator;Lio/scanbot/sdk/ui/view/idcard/LastScannedIdCardHolder;Lio/scanbot/sdk/ui/view/idcard/interactor/SaveIdCardImagesUseCase;)V", "detailsOpened", "", "savePhotoImageAllowed", "saveSignatureImageAllowed", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "calculateConfidence", "", "value", "", "Lio/scanbot/sdk/idcardscanner/IdScanResult$Field$Type;", "Lio/scanbot/sdk/idcardscanner/IdScanResult$Field;", "calculateCurrentStep", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView$ScanningStep;", "confidence", "clearClick", "", "detailsClosed", "getPhotoFieldIfAllowed", "state", "getSignatureFieldIfAllowed", "isTypeProcessable", "previousType", "Lio/scanbot/sdk/idcardscanner/IdScanResult$DocumentType;", "newItem", "Lio/scanbot/sdk/idcardscanner/IdScanResult;", "mapResult", "Lio/scanbot/sdk/ui/view/idcard/entity/IdCardScanningResult;", "it", "Lio/scanbot/sdk/ui/view/idcard/entity/IdCardImagesResult;", "currentState", "type", "pause", "processIdCardScanResult", "resume", "view", "setSavePhotoImageAllowed", "allowed", "setSaveSignatureImageAllowed", "submitButtonClick", "toTextField", "Lio/scanbot/sdk/ui/view/idcard/entity/IdCardTextFieldResult;", "map", "fieldType", "IdCardScanFinished", "rtu-ui-idcard_release"})
public final class IdCardFieldListPresenter
extends CrossViewStatePresenter<IIdCardFieldListView.State, IIdCardFieldListView>
implements IIdCardFieldListView.Listener {
    private final CompositeDisposable subscriptions;
    private boolean detailsOpened;
    private boolean savePhotoImageAllowed;
    private boolean saveSignatureImageAllowed;
    private final Navigator navigator;
    private final LastScannedIdCardHolder lastScannedIdCardHolder;
    private final SaveIdCardImagesUseCase saveIdCardImagesUseCase;

    public void resume(@NotNull IIdCardFieldListView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        super.resume((StatelessView)view);
        view.setListener(this);
        if (this.state == null) {
            this.updateState(IIdCardFieldListView.State.Companion.getDEFAULT());
        }
        Function1 function1 = (Function1)new Function1<IdScanResult, Unit>(this){

            public final void invoke(@NotNull IdScanResult p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                IdCardFieldListPresenter.access$processIdCardScanResult((IdCardFieldListPresenter)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IdCardFieldListPresenter.class);
            }

            public final String getName() {
                return "processIdCardScanResult";
            }

            public final String getSignature() {
                return "processIdCardScanResult(Lio/scanbot/sdk/idcardscanner/IdScanResult;)V";
            }
        };
        IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0 idCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0 = new IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0(function1);
        function1 = (Function1)new Function1<Throwable, Unit>(LoggerProvider.getLogger()){

            public final void invoke(@Nullable Throwable p1) {
                ((Logger)this.receiver).logException(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Logger.class);
            }

            public final String getName() {
                return "logException";
            }

            public final String getSignature() {
                return "logException(Ljava/lang/Throwable;)V";
            }
        };
        this.subscriptions.add(this.lastScannedIdCardHolder.observeIdCardScanningResults().filter((Predicate)resume.1.INSTANCE).subscribe((Consumer)idCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0, (Consumer)new IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0(function1)));
    }

    private final void processIdCardScanResult(IdScanResult newItem) {
        if (!this.detailsOpened) {
            IdScanResult.DocumentType previousType;
            IdScanResult.DocumentType documentType = previousType = (IdScanResult.DocumentType)((IIdCardFieldListView.State)this.state).getPreviousScannedType().getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)documentType, (String)"previousType");
            if (this.isTypeProcessable(documentType, newItem)) {
                LinkedHashMap value = new LinkedHashMap((Map)((IIdCardFieldListView.State)this.state).getIdCardFields().getValue());
                for (IdScanResult.Field newField : newItem.getFields()) {
                    IdScanResult.Field oldField = (IdScanResult.Field)value.get(newField.getType());
                    if (oldField != null && !(oldField.getTextConfidence() <= newField.getTextConfidence())) continue;
                    ((Map)value).put(newField.getType(), newField);
                }
                double confidence = this.calculateConfidence(value);
                ((IIdCardFieldListView.State)this.state).getAverageConfidence().onNext((Object)confidence);
                ((IIdCardFieldListView.State)this.state).getScanningStep().onNext((Object)this.calculateCurrentStep(value, confidence));
                ((IIdCardFieldListView.State)this.state).getIdCardFields().onNext(value);
                ((IIdCardFieldListView.State)this.state).getPreviousScannedType().onNext((Object)newItem.getDocumentType());
            }
        }
    }

    private final boolean isTypeProcessable(IdScanResult.DocumentType previousType, IdScanResult newItem) {
        return previousType == IdScanResult.DocumentType.Junk || previousType == newItem.getDocumentType() || CollectionsKt.listOf((Object[])new IdScanResult.DocumentType[]{IdScanResult.DocumentType.DeIdBack, IdScanResult.DocumentType.DeIdFront}).contains(previousType) && CollectionsKt.listOf((Object[])new IdScanResult.DocumentType[]{IdScanResult.DocumentType.DeIdBack, IdScanResult.DocumentType.DeIdFront}).contains(newItem.getDocumentType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IIdCardFieldListView.ScanningStep calculateCurrentStep(Map<IdScanResult.Field.Type, IdScanResult.Field> value, double confidence) {
        IIdCardFieldListView.ScanningStep scanningStep;
        Map<IdScanResult.Field.Type, IdScanResult.Field> map = value;
        boolean bl = false;
        if (!map.isEmpty()) {
            IdScanResult.DocumentType documentType = (IdScanResult.DocumentType)((IIdCardFieldListView.State)this.state).getPreviousScannedType().getValue();
            if (documentType == null) throw new NoWhenBranchMatchedException();
            switch (IdCardFieldListPresenter$WhenMappings.$EnumSwitchMapping$0[documentType.ordinal()]) {
                case 1: {
                    scanningStep = confidence > 0.9 ? IIdCardFieldListView.ScanningStep.ALL_DONE : IIdCardFieldListView.ScanningStep.SCANNING_FRONT;
                    return scanningStep;
                }
                case 2: 
                case 3: {
                    boolean frontFieldScanned = value.containsKey(IdScanResult.Field.Type.Surname);
                    boolean backFieldScanned = value.containsKey(IdScanResult.Field.Type.MRZ);
                    boolean allDone = frontFieldScanned && backFieldScanned && confidence > 0.9;
                    scanningStep = allDone ? IIdCardFieldListView.ScanningStep.ALL_DONE : (backFieldScanned && confidence > 0.9 ? IIdCardFieldListView.ScanningStep.BACK_DONE : (backFieldScanned ? IIdCardFieldListView.ScanningStep.SCANNING_BACK : (confidence > 0.9 ? IIdCardFieldListView.ScanningStep.FRONT_DONE : IIdCardFieldListView.ScanningStep.SCANNING_FRONT)));
                    return scanningStep;
                }
                case 4: {
                    scanningStep = IIdCardFieldListView.ScanningStep.INITIAL;
                    return scanningStep;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        scanningStep = IIdCardFieldListView.ScanningStep.INITIAL;
        return scanningStep;
    }

    /*
     * WARNING - void declaration
     */
    private final double calculateConfidence(Map<IdScanResult.Field.Type, IdScanResult.Field> value) {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterNotTo$iv$iv;
        Map<IdScanResult.Field.Type, IdScanResult.Field> $this$filterNot$iv = value;
        boolean $i$f$filterNot = false;
        Map<IdScanResult.Field.Type, IdScanResult.Field> map = $this$filterNot$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        void var7_7 = $this$filterNotTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (CollectionsKt.listOf((Object[])new IdScanResult.Field.Type[]{IdScanResult.Field.Type.Height, IdScanResult.Field.Type.Pseudonym, IdScanResult.Field.Type.MaidenName, IdScanResult.Field.Type.Signature, IdScanResult.Field.Type.Photo}).contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var7_7 = $this$mapTo$iv$iv;
        bl = false;
        for (Map.Entry item$iv$iv : var7_7.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl3 = false;
            Float f = Float.valueOf(((IdScanResult.Field)it.getValue()).getTextConfidence());
            object.add(f);
        }
        return CollectionsKt.averageOfFloat((Iterable)((List)destination$iv$iv));
    }

    public void pause() {
        super.pause();
        this.subscriptions.clear();
    }

    @Override
    public void submitButtonClick() {
        Map currentState = (Map)((IIdCardFieldListView.State)this.state).getIdCardFields().getValue();
        IdScanResult.DocumentType type = (IdScanResult.DocumentType)((IIdCardFieldListView.State)this.state).getPreviousScannedType().getValue();
        Map map = currentState;
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"currentState");
        Function1 function1 = (Function1)new Function1<Throwable, Unit>(LoggerProvider.getLogger()){

            public final void invoke(@Nullable Throwable p1) {
                ((Logger)this.receiver).logException(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Logger.class);
            }

            public final String getName() {
                return "logException";
            }

            public final String getSignature() {
                return "logException(Ljava/lang/Throwable;)V";
            }
        };
        this.subscriptions.add(this.saveIdCardImagesUseCase.saveIdCardFields(this.getPhotoFieldIfAllowed(map), this.getSignatureFieldIfAllowed(currentState)).subscribe((Consumer)new Consumer<IdCardImagesResult>(this, currentState, type){
            final /* synthetic */ IdCardFieldListPresenter this$0;
            final /* synthetic */ Map $currentState;
            final /* synthetic */ IdScanResult.DocumentType $type;

            public final void accept(IdCardImagesResult images) {
                block0: {
                    IdCardImagesResult idCardImagesResult = images;
                    Intrinsics.checkExpressionValueIsNotNull((Object)idCardImagesResult, (String)"images");
                    Map map = this.$currentState;
                    Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"currentState");
                    IdScanResult.DocumentType documentType = this.$type;
                    Intrinsics.checkExpressionValueIsNotNull((Object)documentType, (String)"type");
                    IdCardScanningResult idCardScanningResult = IdCardFieldListPresenter.access$mapResult(this.this$0, idCardImagesResult, map, documentType);
                    if (idCardScanningResult == null) break block0;
                    IdCardScanningResult idCardScanningResult2 = idCardScanningResult;
                    boolean bl = false;
                    boolean bl2 = false;
                    IdCardScanningResult it = idCardScanningResult2;
                    boolean bl3 = false;
                    IdCardFieldListPresenter.access$getNavigator$p(this.this$0).navigate((Object)new IdCardScanFinished(it));
                }
            }
            {
                this.this$0 = idCardFieldListPresenter;
                this.$currentState = map;
                this.$type = documentType;
            }
        }, (Consumer)new IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0(function1)));
    }

    private final IdScanResult.Field getPhotoFieldIfAllowed(Map<IdScanResult.Field.Type, IdScanResult.Field> state) {
        return this.savePhotoImageAllowed ? state.get(IdScanResult.Field.Type.Photo) : null;
    }

    private final IdScanResult.Field getSignatureFieldIfAllowed(Map<IdScanResult.Field.Type, IdScanResult.Field> state) {
        return this.saveSignatureImageAllowed ? state.get(IdScanResult.Field.Type.Signature) : null;
    }

    private final IdCardScanningResult mapResult(IdCardImagesResult it, Map<IdScanResult.Field.Type, IdScanResult.Field> currentState, IdScanResult.DocumentType type) {
        IdCardScanningResult idCardScanningResult;
        switch (IdCardFieldListPresenter$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                idCardScanningResult = new IdCardScanningResult.GermanyPassportCard(this.toTextField(currentState, IdScanResult.Field.Type.ID), this.toTextField(currentState, IdScanResult.Field.Type.Surname), this.toTextField(currentState, IdScanResult.Field.Type.GivenNames), this.toTextField(currentState, IdScanResult.Field.Type.BirthDate), this.toTextField(currentState, IdScanResult.Field.Type.Nationality), this.toTextField(currentState, IdScanResult.Field.Type.ExpiryDate), this.toTextField(currentState, IdScanResult.Field.Type.MRZ), it.getPhotoUri(), it.getSignatureUri(), this.toTextField(currentState, IdScanResult.Field.Type.MaidenName), this.toTextField(currentState, IdScanResult.Field.Type.Birthplace), this.toTextField(currentState, IdScanResult.Field.Type.IssueDate), this.toTextField(currentState, IdScanResult.Field.Type.IssuingAuthority), this.toTextField(currentState, IdScanResult.Field.Type.PassportType), this.toTextField(currentState, IdScanResult.Field.Type.CountryCode), this.toTextField(currentState, IdScanResult.Field.Type.Gender));
                break;
            }
            case 2: 
            case 3: {
                idCardScanningResult = new IdCardScanningResult.GermanyIdCard(this.toTextField(currentState, IdScanResult.Field.Type.ID), this.toTextField(currentState, IdScanResult.Field.Type.Surname), this.toTextField(currentState, IdScanResult.Field.Type.GivenNames), this.toTextField(currentState, IdScanResult.Field.Type.BirthDate), this.toTextField(currentState, IdScanResult.Field.Type.Nationality), this.toTextField(currentState, IdScanResult.Field.Type.ExpiryDate), this.toTextField(currentState, IdScanResult.Field.Type.MRZ), it.getPhotoUri(), it.getSignatureUri(), this.toTextField(currentState, IdScanResult.Field.Type.Birthplace), this.toTextField(currentState, IdScanResult.Field.Type.PIN), this.toTextField(currentState, IdScanResult.Field.Type.EyeColor), this.toTextField(currentState, IdScanResult.Field.Type.Height), this.toTextField(currentState, IdScanResult.Field.Type.IssueDate), this.toTextField(currentState, IdScanResult.Field.Type.IssuingAuthority), this.toTextField(currentState, IdScanResult.Field.Type.Address), this.toTextField(currentState, IdScanResult.Field.Type.Pseudonym));
                break;
            }
            default: {
                idCardScanningResult = null;
            }
        }
        return idCardScanningResult;
    }

    private final IdCardTextFieldResult toTextField(Map<IdScanResult.Field.Type, IdScanResult.Field> map, IdScanResult.Field.Type fieldType) {
        IdCardTextFieldResult idCardTextFieldResult;
        IdScanResult.Field field = map.get(fieldType);
        if (field != null) {
            IdScanResult.Field field2 = field;
            boolean bl = false;
            boolean bl2 = false;
            IdScanResult.Field textField = field2;
            boolean bl3 = false;
            String string = textField.getText();
            if (string != null) {
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String textValue = string2;
                boolean bl6 = false;
                idCardTextFieldResult = new IdCardTextFieldResult(textValue, textField.getTextConfidence());
            } else {
                idCardTextFieldResult = null;
            }
        } else {
            idCardTextFieldResult = null;
        }
        return idCardTextFieldResult;
    }

    @Override
    public void clearClick() {
        ((IIdCardFieldListView.State)this.state).getAverageConfidence().onNext((Object)0.0);
        ((IIdCardFieldListView.State)this.state).getScanningStep().onNext((Object)IIdCardFieldListView.ScanningStep.INITIAL);
        ((IIdCardFieldListView.State)this.state).getPreviousScannedType().onNext((Object)IdScanResult.DocumentType.Junk);
        BehaviorProcessor<Map<IdScanResult.Field.Type, IdScanResult.Field>> behaviorProcessor = ((IIdCardFieldListView.State)this.state).getIdCardFields();
        boolean bl = false;
        Map map = MapsKt.emptyMap();
        behaviorProcessor.onNext((Object)map);
    }

    @Override
    public void detailsOpened() {
        this.detailsOpened = true;
    }

    @Override
    public void detailsClosed() {
        this.detailsOpened = false;
    }

    public final void setSavePhotoImageAllowed(boolean allowed) {
        this.savePhotoImageAllowed = allowed;
    }

    public final void setSaveSignatureImageAllowed(boolean allowed) {
        this.saveSignatureImageAllowed = allowed;
    }

    @Inject
    public IdCardFieldListPresenter(@NotNull Navigator navigator, @NotNull LastScannedIdCardHolder lastScannedIdCardHolder, @NotNull SaveIdCardImagesUseCase saveIdCardImagesUseCase) {
        Intrinsics.checkParameterIsNotNull((Object)navigator, (String)"navigator");
        Intrinsics.checkParameterIsNotNull((Object)lastScannedIdCardHolder, (String)"lastScannedIdCardHolder");
        Intrinsics.checkParameterIsNotNull((Object)saveIdCardImagesUseCase, (String)"saveIdCardImagesUseCase");
        this.navigator = navigator;
        this.lastScannedIdCardHolder = lastScannedIdCardHolder;
        this.saveIdCardImagesUseCase = saveIdCardImagesUseCase;
        this.subscriptions = new CompositeDisposable();
    }

    public static final /* synthetic */ void access$processIdCardScanResult(IdCardFieldListPresenter $this, IdScanResult newItem) {
        $this.processIdCardScanResult(newItem);
    }

    public static final /* synthetic */ IdCardScanningResult access$mapResult(IdCardFieldListPresenter $this, IdCardImagesResult it, Map currentState, IdScanResult.DocumentType type) {
        return $this.mapResult(it, currentState, type);
    }

    public static final /* synthetic */ Navigator access$getNavigator$p(IdCardFieldListPresenter $this) {
        return $this.navigator;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListPresenter$IdCardScanFinished;", "", "idCardScanningResult", "Lio/scanbot/sdk/ui/view/idcard/entity/IdCardScanningResult;", "(Lio/scanbot/sdk/ui/view/idcard/entity/IdCardScanningResult;)V", "getIdCardScanningResult", "()Lio/scanbot/sdk/ui/view/idcard/entity/IdCardScanningResult;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "rtu-ui-idcard_release"})
    public static final class IdCardScanFinished {
        @NotNull
        private final IdCardScanningResult idCardScanningResult;

        @NotNull
        public final IdCardScanningResult getIdCardScanningResult() {
            return this.idCardScanningResult;
        }

        public IdCardScanFinished(@NotNull IdCardScanningResult idCardScanningResult) {
            Intrinsics.checkParameterIsNotNull((Object)idCardScanningResult, (String)"idCardScanningResult");
            this.idCardScanningResult = idCardScanningResult;
        }

        @NotNull
        public final IdCardScanningResult component1() {
            return this.idCardScanningResult;
        }

        @NotNull
        public final IdCardScanFinished copy(@NotNull IdCardScanningResult idCardScanningResult) {
            Intrinsics.checkParameterIsNotNull((Object)idCardScanningResult, (String)"idCardScanningResult");
            return new IdCardScanFinished(idCardScanningResult);
        }

        public static /* synthetic */ IdCardScanFinished copy$default(IdCardScanFinished idCardScanFinished, IdCardScanningResult idCardScanningResult, int n, Object object) {
            if ((n & 1) != 0) {
                idCardScanningResult = idCardScanFinished.idCardScanningResult;
            }
            return idCardScanFinished.copy(idCardScanningResult);
        }

        @NotNull
        public String toString() {
            return "IdCardScanFinished(idCardScanningResult=" + this.idCardScanningResult + ")";
        }

        public int hashCode() {
            IdCardScanningResult idCardScanningResult = this.idCardScanningResult;
            return idCardScanningResult != null ? idCardScanningResult.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IdCardScanFinished)) break block3;
                    IdCardScanFinished idCardScanFinished = (IdCardScanFinished)object;
                    if (!Intrinsics.areEqual((Object)this.idCardScanningResult, (Object)idCardScanFinished.idCardScanningResult)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

