/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.idcard.list;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.scanbot.sdk.idcardscanner.IdScanResult;
import io.scanbot.sdk.ui.utils.CrossViewStatePresenter;
import io.scanbot.sdk.ui.utils.StatelessView;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.idcard.IdCardScanningSession;
import io.scanbot.sdk.ui.view.idcard.entity.IdCardImagesResult;
import io.scanbot.sdk.ui.view.idcard.entity.IdCardScanningResult;
import io.scanbot.sdk.ui.view.idcard.interactor.SaveIdCardImagesUseCase;
import io.scanbot.sdk.ui.view.idcard.list.IIdCardFieldListView;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter$WhenMappings;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter$sam$i$io_reactivex_functions_Consumer$0;
import io.scanbot.sdk.ui.view.idcard.list.IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0;
import io.scanbot.sdk.ui.view.idcard.list.IdCardPresenterResultMapper;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u00019B\u001f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J$\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170\u001a2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010\f\u001a\u00020\u001eH\u0016J\u001e\u0010 \u001a\u0004\u0018\u00010\u00172\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170\u001aH\u0002J\u001e\u0010\"\u001a\u0004\u0018\u00010\u00172\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170\u001aH\u0002J\u001e\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0018\u0010&\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0017H\u0002J\u0010\u0010(\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0017H\u0002J\u0018\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020\u001eH\u0016J\u0010\u0010/\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\rH\u0002J\u0010\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u0003H\u0016J\u000e\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\rJ\u000e\u00106\u001a\u00020\u001e2\u0006\u00105\u001a\u00020\rJ(\u00107\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\b\u00108\u001a\u00020\u001eH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListPresenter;", "Lio/scanbot/sdk/ui/utils/CrossViewStatePresenter;", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView$State;", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView;", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView$Listener;", "navigator", "Lio/scanbot/sdk/ui/utils/navigator/Navigator;", "idCardScanningSession", "Lio/scanbot/sdk/ui/view/idcard/IdCardScanningSession;", "saveIdCardImagesUseCase", "Lio/scanbot/sdk/ui/view/idcard/interactor/SaveIdCardImagesUseCase;", "(Lio/scanbot/sdk/ui/utils/navigator/Navigator;Lio/scanbot/sdk/ui/view/idcard/IdCardScanningSession;Lio/scanbot/sdk/ui/view/idcard/interactor/SaveIdCardImagesUseCase;)V", "detailsOpened", "", "goodPhotoConfidence", "", "savePhotoImageAllowed", "saveSignatureImageAllowed", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "calculateConfidence", "value", "", "Lio/scanbot/sdk/idcardscanner/IdScanResult$Field;", "calculateCurrentStep", "Lio/scanbot/sdk/ui/view/idcard/list/IIdCardFieldListView$ScanningStep;", "", "Lio/scanbot/sdk/idcardscanner/IdScanResult$Field$Type;", "confidence", "clearClick", "", "detailsClosed", "getPhotoFieldIfAllowed", "state", "getSignatureFieldIfAllowed", "isGoodPhoto", "newField", "fields", "isGoodTextField", "oldField", "isPhoto", "isTypeProcessable", "previousType", "Lio/scanbot/sdk/idcardscanner/IdScanResult$DocumentType;", "newItem", "Lio/scanbot/sdk/idcardscanner/IdScanResult;", "pause", "processIdCardScanResult", "processScanningState", "started", "resume", "view", "setSavePhotoImageAllowed", "allowed", "setSaveSignatureImageAllowed", "shouldKeep", "submitButtonClick", "IdCardScanFinished", "rtu-ui-idcard_release"})
public final class IdCardFieldListPresenter
extends CrossViewStatePresenter<IIdCardFieldListView.State, IIdCardFieldListView>
implements IIdCardFieldListView.Listener {
    private final CompositeDisposable subscriptions;
    private boolean detailsOpened;
    private boolean savePhotoImageAllowed;
    private boolean saveSignatureImageAllowed;
    private double goodPhotoConfidence;
    private final Navigator navigator;
    private final IdCardScanningSession idCardScanningSession;
    private final SaveIdCardImagesUseCase saveIdCardImagesUseCase;

    public void resume(@NotNull IIdCardFieldListView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.resume((StatelessView)view);
        view.setListener(this);
        if (this.getState() == null) {
            this.updateState(IIdCardFieldListView.State.Companion.getDEFAULT());
        }
        Function1 function1 = (Function1)new Function1<IdScanResult, Unit>(this){

            public final void invoke(@NotNull IdScanResult p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                IdCardFieldListPresenter.access$processIdCardScanResult((IdCardFieldListPresenter)this.receiver, p1);
            }
        };
        IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0 idCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0 = new IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0(function1);
        function1 = (Function1)new Function1<Throwable, Unit>(LoggerProvider.getLogger()){

            public final void invoke(@Nullable Throwable p1) {
                ((Logger)this.receiver).logException(p1);
            }
        };
        this.subscriptions.add(this.idCardScanningSession.observeIdCardScanningResults().filter((Predicate)resume.1.INSTANCE).subscribe((Consumer)idCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0, (Consumer)new IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0(function1)));
        function1 = (Function1)new Function1<Boolean, Unit>(this){

            public final void invoke(boolean p1) {
                IdCardFieldListPresenter.access$processScanningState((IdCardFieldListPresenter)this.receiver, p1);
            }
        };
        IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0 idCardFieldListPresenter$sam$io_reactivex_functions_Consumer$02 = new IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0(function1);
        function1 = (Function1)new Function1<Throwable, Unit>(LoggerProvider.getLogger()){

            public final void invoke(@Nullable Throwable p1) {
                ((Logger)this.receiver).logException(p1);
            }
        };
        this.subscriptions.add(this.idCardScanningSession.observeScanReadyState().subscribe((Consumer)idCardFieldListPresenter$sam$io_reactivex_functions_Consumer$02, (Consumer)new IdCardFieldListPresenter$sam$io_reactivex_functions_Consumer$0(function1)));
    }

    private final void processScanningState(boolean started) {
        block1: {
            IIdCardFieldListView.State state = (IIdCardFieldListView.State)this.getState();
            if (state == null) break block1;
            IIdCardFieldListView.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            IIdCardFieldListView.State state3 = state2;
            boolean bl3 = false;
            if ((IIdCardFieldListView.ScanningStep)((Object)state3.getScanningStep().getValue()) == IIdCardFieldListView.ScanningStep.NOT_READY && started) {
                state3.getScanningStep().onNext((Object)IIdCardFieldListView.ScanningStep.INITIAL);
            }
        }
    }

    private final void processIdCardScanResult(IdScanResult newItem) {
        block3: {
            IIdCardFieldListView.State state = (IIdCardFieldListView.State)this.getState();
            if (state == null) break block3;
            IIdCardFieldListView.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            IIdCardFieldListView.State state3 = state2;
            boolean bl3 = false;
            if (!this.detailsOpened) {
                IdScanResult.DocumentType previousType;
                IdScanResult.DocumentType documentType = previousType = (IdScanResult.DocumentType)state3.getPreviousScannedType().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)documentType, (String)"previousType");
                if (this.isTypeProcessable(documentType, newItem)) {
                    LinkedHashMap value = new LinkedHashMap((Map)state3.getIdCardFields().getValue());
                    for (IdScanResult.Field newField : newItem.getFields()) {
                        IdScanResult.Field oldField = (IdScanResult.Field)value.get(newField.getType());
                        if (!this.shouldKeep(oldField, newField, newItem.getFields())) continue;
                        ((Map)value).put(newField.getType(), newField);
                    }
                    Collection collection = value.values();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"value.values");
                    double confidence = this.calculateConfidence(CollectionsKt.toList((Iterable)collection));
                    state3.getAverageConfidence().onNext((Object)confidence);
                    state3.getScanningStep().onNext((Object)this.calculateCurrentStep(value, confidence));
                    state3.getIdCardFields().onNext(value);
                    state3.getPreviousScannedType().onNext((Object)newItem.getDocumentType());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldKeep(IdScanResult.Field oldField, IdScanResult.Field newField, List<IdScanResult.Field> fields) {
        if (oldField == null) {
            if (!newField.getType().isDriversCategory()) return true;
            CharSequence charSequence = newField.getText();
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null) return false;
            if (charSequence.length() != 0) return true;
            return false;
        }
        if (this.isGoodTextField(newField, oldField)) return true;
        if (!this.isGoodPhoto(newField, fields)) return false;
        return true;
    }

    private final boolean isPhoto(IdScanResult.Field newField) {
        return CollectionsKt.listOf((Object[])new IdScanResult.Field.Type[]{IdScanResult.Field.Type.Photo, IdScanResult.Field.Type.Signature}).contains(newField.getType());
    }

    private final boolean isGoodTextField(IdScanResult.Field newField, IdScanResult.Field oldField) {
        return !this.isPhoto(newField) && oldField.getTextConfidence() <= newField.getTextConfidence();
    }

    private final boolean isGoodPhoto(IdScanResult.Field newField, List<IdScanResult.Field> fields) {
        double newConfidence;
        if (this.isPhoto(newField) && (newConfidence = this.calculateConfidence(fields)) > this.goodPhotoConfidence) {
            this.goodPhotoConfidence = newConfidence;
            return true;
        }
        return false;
    }

    private final boolean isTypeProcessable(IdScanResult.DocumentType previousType, IdScanResult newItem) {
        return previousType == IdScanResult.DocumentType.Junk || previousType == newItem.getDocumentType() || CollectionsKt.listOf((Object[])new IdScanResult.DocumentType[]{IdScanResult.DocumentType.DeIdBack, IdScanResult.DocumentType.DeIdFront}).contains(previousType) && CollectionsKt.listOf((Object[])new IdScanResult.DocumentType[]{IdScanResult.DocumentType.DeIdBack, IdScanResult.DocumentType.DeIdFront}).contains(newItem.getDocumentType()) || CollectionsKt.listOf((Object[])new IdScanResult.DocumentType[]{IdScanResult.DocumentType.DeDriverLicenseBack, IdScanResult.DocumentType.DeDriverLicenseFront}).contains(previousType) && CollectionsKt.listOf((Object[])new IdScanResult.DocumentType[]{IdScanResult.DocumentType.DeDriverLicenseBack, IdScanResult.DocumentType.DeDriverLicenseFront}).contains(newItem.getDocumentType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final IIdCardFieldListView.ScanningStep calculateCurrentStep(Map<IdScanResult.Field.Type, IdScanResult.Field> value, double confidence) {
        Object object;
        Object object2 = value;
        boolean bl = false;
        if (!object2.isEmpty()) {
            object = (IIdCardFieldListView.State)this.getState();
            if (object != null) {
                IIdCardFieldListView.ScanningStep scanningStep;
                object2 = object;
                bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                IdScanResult.DocumentType documentType = (IdScanResult.DocumentType)((IIdCardFieldListView.State)it).getPreviousScannedType().getValue();
                if (documentType == null) throw new NoWhenBranchMatchedException();
                switch (IdCardFieldListPresenter$WhenMappings.$EnumSwitchMapping$0[documentType.ordinal()]) {
                    case 1: {
                        if (confidence > 0.9) {
                            scanningStep = IIdCardFieldListView.ScanningStep.ALL_DONE;
                            break;
                        }
                        scanningStep = IIdCardFieldListView.ScanningStep.SCANNING_FRONT;
                        break;
                    }
                    case 2: 
                    case 3: {
                        boolean frontFieldScanned = value.containsKey(IdScanResult.Field.Type.Surname);
                        boolean backFieldScanned = value.containsKey(IdScanResult.Field.Type.MRZ);
                        boolean allDone = frontFieldScanned && backFieldScanned && confidence > 0.9;
                        if (allDone) {
                            scanningStep = IIdCardFieldListView.ScanningStep.ALL_DONE;
                            break;
                        }
                        if (backFieldScanned && confidence > 0.9) {
                            scanningStep = IIdCardFieldListView.ScanningStep.BACK_DONE;
                            break;
                        }
                        if (backFieldScanned) {
                            scanningStep = IIdCardFieldListView.ScanningStep.SCANNING_BACK;
                            break;
                        }
                        if (confidence > 0.9) {
                            scanningStep = IIdCardFieldListView.ScanningStep.FRONT_DONE;
                            break;
                        }
                        scanningStep = IIdCardFieldListView.ScanningStep.SCANNING_FRONT;
                        break;
                    }
                    case 4: 
                    case 5: {
                        boolean frontFieldScanned = value.containsKey(IdScanResult.Field.Type.ID);
                        boolean backFieldScanned = value.containsKey(IdScanResult.Field.Type.DeDriverLicense_12_Beschrankungen);
                        boolean allDone = frontFieldScanned && backFieldScanned && confidence > 0.9;
                        if (allDone) {
                            scanningStep = IIdCardFieldListView.ScanningStep.ALL_DONE;
                            break;
                        }
                        if (backFieldScanned && confidence > 0.9) {
                            scanningStep = IIdCardFieldListView.ScanningStep.BACK_DONE;
                            break;
                        }
                        if (backFieldScanned) {
                            scanningStep = IIdCardFieldListView.ScanningStep.SCANNING_BACK;
                            break;
                        }
                        if (confidence > 0.9) {
                            scanningStep = IIdCardFieldListView.ScanningStep.FRONT_DONE;
                            break;
                        }
                        scanningStep = IIdCardFieldListView.ScanningStep.SCANNING_FRONT;
                        break;
                    }
                    case 6: {
                        scanningStep = IIdCardFieldListView.ScanningStep.INITIAL;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                object = scanningStep;
                if (scanningStep != null) return object;
            }
            object = IIdCardFieldListView.ScanningStep.INITIAL;
            return object;
        } else {
            object = IIdCardFieldListView.ScanningStep.INITIAL;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final double calculateConfidence(List<IdScanResult.Field> value) {
        void $this$mapTo$iv$iv;
        IdScanResult.Field it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = value;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IdScanResult.Field)element$iv$iv;
            boolean bl = false;
            if (CollectionsKt.listOf((Object[])new IdScanResult.Field.Type[]{IdScanResult.Field.Type.Height, IdScanResult.Field.Type.Pseudonym, IdScanResult.Field.Type.MaidenName, IdScanResult.Field.Type.Signature, IdScanResult.Field.Type.Photo, IdScanResult.Field.Type.DeDriverLicense_12_Beschrankungen}).contains(it.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (IdScanResult.Field)element$iv$iv;
            boolean bl = false;
            if (it.getType().isDriversCategory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IdScanResult.Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Float f = Float.valueOf(it.getTextConfidence());
            collection.add(f);
        }
        return CollectionsKt.averageOfFloat((Iterable)((List)destination$iv$iv));
    }

    public void pause() {
        super.pause();
        this.subscriptions.clear();
    }

    @Override
    public void submitButtonClick() {
        block0: {
            IIdCardFieldListView.State state = (IIdCardFieldListView.State)this.getState();
            if (state == null) break block0;
            IIdCardFieldListView.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            IIdCardFieldListView.State state3 = state2;
            boolean bl3 = false;
            Map currentState = (Map)state3.getIdCardFields().getValue();
            IdScanResult.DocumentType type = (IdScanResult.DocumentType)state3.getPreviousScannedType().getValue();
            Map map = currentState;
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"currentState");
            Function1 function1 = (Function1)new Function1<Throwable, Unit>(LoggerProvider.getLogger()){

                public final void invoke(@Nullable Throwable p1) {
                    ((Logger)this.receiver).logException(p1);
                }
            };
            this.subscriptions.add(this.saveIdCardImagesUseCase.saveIdCardFields(this.getPhotoFieldIfAllowed(map), this.getSignatureFieldIfAllowed(currentState)).subscribe((Consumer)new Consumer<IdCardImagesResult>(currentState, type, this){
                final /* synthetic */ Map $currentState;
                final /* synthetic */ IdScanResult.DocumentType $type;
                final /* synthetic */ IdCardFieldListPresenter this$0;
                {
                    this.$currentState = map;
                    this.$type = documentType;
                    this.this$0 = idCardFieldListPresenter;
                }

                public final void accept(IdCardImagesResult images) {
                    block0: {
                        IdCardImagesResult idCardImagesResult = images;
                        Intrinsics.checkNotNullExpressionValue((Object)idCardImagesResult, (String)"images");
                        Map map = this.$currentState;
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"currentState");
                        IdScanResult.DocumentType documentType = this.$type;
                        Intrinsics.checkNotNullExpressionValue((Object)documentType, (String)"type");
                        IdCardScanningResult idCardScanningResult = IdCardPresenterResultMapper.INSTANCE.mapResult(idCardImagesResult, map, documentType);
                        if (idCardScanningResult == null) break block0;
                        IdCardScanningResult idCardScanningResult2 = idCardScanningResult;
                        boolean bl = false;
                        boolean bl2 = false;
                        IdCardScanningResult it = idCardScanningResult2;
                        boolean bl3 = false;
                        IdCardFieldListPresenter.access$getNavigator$p(this.this$0).navigate((Object)new IdCardScanFinished(it));
                    }
                }
            }, (Consumer)new IdCardFieldListPresenter$sam$i$io_reactivex_functions_Consumer$0(function1)));
        }
    }

    private final IdScanResult.Field getPhotoFieldIfAllowed(Map<IdScanResult.Field.Type, IdScanResult.Field> state) {
        return this.savePhotoImageAllowed ? state.get(IdScanResult.Field.Type.Photo) : null;
    }

    private final IdScanResult.Field getSignatureFieldIfAllowed(Map<IdScanResult.Field.Type, IdScanResult.Field> state) {
        return this.saveSignatureImageAllowed ? state.get(IdScanResult.Field.Type.Signature) : null;
    }

    @Override
    public void clearClick() {
        block0: {
            IIdCardFieldListView.State state = (IIdCardFieldListView.State)this.getState();
            if (state == null) break block0;
            IIdCardFieldListView.State state2 = state;
            boolean bl = false;
            boolean bl2 = false;
            IIdCardFieldListView.State state3 = state2;
            boolean bl3 = false;
            this.goodPhotoConfidence = 0.0;
            state3.getAverageConfidence().onNext((Object)0.0);
            state3.getScanningStep().onNext((Object)IIdCardFieldListView.ScanningStep.INITIAL);
            state3.getPreviousScannedType().onNext((Object)IdScanResult.DocumentType.Junk);
            boolean bl4 = false;
            state3.getIdCardFields().onNext((Object)MapsKt.emptyMap());
        }
    }

    @Override
    public void detailsOpened() {
        this.detailsOpened = true;
    }

    @Override
    public void detailsClosed() {
        this.detailsOpened = false;
    }

    public final void setSavePhotoImageAllowed(boolean allowed) {
        this.savePhotoImageAllowed = allowed;
    }

    public final void setSaveSignatureImageAllowed(boolean allowed) {
        this.saveSignatureImageAllowed = allowed;
    }

    @Inject
    public IdCardFieldListPresenter(@NotNull Navigator navigator, @NotNull IdCardScanningSession idCardScanningSession, @NotNull SaveIdCardImagesUseCase saveIdCardImagesUseCase) {
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)idCardScanningSession, (String)"idCardScanningSession");
        Intrinsics.checkNotNullParameter((Object)saveIdCardImagesUseCase, (String)"saveIdCardImagesUseCase");
        this.navigator = navigator;
        this.idCardScanningSession = idCardScanningSession;
        this.saveIdCardImagesUseCase = saveIdCardImagesUseCase;
        this.subscriptions = new CompositeDisposable();
    }

    public static final /* synthetic */ void access$processIdCardScanResult(IdCardFieldListPresenter $this, IdScanResult newItem) {
        $this.processIdCardScanResult(newItem);
    }

    public static final /* synthetic */ void access$processScanningState(IdCardFieldListPresenter $this, boolean started) {
        $this.processScanningState(started);
    }

    public static final /* synthetic */ Navigator access$getNavigator$p(IdCardFieldListPresenter $this) {
        return $this.navigator;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/view/idcard/list/IdCardFieldListPresenter$IdCardScanFinished;", "", "idCardScanningResult", "Lio/scanbot/sdk/ui/view/idcard/entity/IdCardScanningResult;", "(Lio/scanbot/sdk/ui/view/idcard/entity/IdCardScanningResult;)V", "getIdCardScanningResult", "()Lio/scanbot/sdk/ui/view/idcard/entity/IdCardScanningResult;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "rtu-ui-idcard_release"})
    public static final class IdCardScanFinished {
        @NotNull
        private final IdCardScanningResult idCardScanningResult;

        @NotNull
        public final IdCardScanningResult getIdCardScanningResult() {
            return this.idCardScanningResult;
        }

        public IdCardScanFinished(@NotNull IdCardScanningResult idCardScanningResult) {
            Intrinsics.checkNotNullParameter((Object)idCardScanningResult, (String)"idCardScanningResult");
            this.idCardScanningResult = idCardScanningResult;
        }

        @NotNull
        public final IdCardScanningResult component1() {
            return this.idCardScanningResult;
        }

        @NotNull
        public final IdCardScanFinished copy(@NotNull IdCardScanningResult idCardScanningResult) {
            Intrinsics.checkNotNullParameter((Object)idCardScanningResult, (String)"idCardScanningResult");
            return new IdCardScanFinished(idCardScanningResult);
        }

        public static /* synthetic */ IdCardScanFinished copy$default(IdCardScanFinished idCardScanFinished, IdCardScanningResult idCardScanningResult, int n, Object object) {
            if ((n & 1) != 0) {
                idCardScanningResult = idCardScanFinished.idCardScanningResult;
            }
            return idCardScanFinished.copy(idCardScanningResult);
        }

        @NotNull
        public String toString() {
            return "IdCardScanFinished(idCardScanningResult=" + this.idCardScanningResult + ")";
        }

        public int hashCode() {
            IdCardScanningResult idCardScanningResult = this.idCardScanningResult;
            return idCardScanningResult != null ? idCardScanningResult.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof IdCardScanFinished)) break block3;
                    IdCardScanFinished idCardScanFinished = (IdCardScanFinished)object;
                    if (!Intrinsics.areEqual((Object)this.idCardScanningResult, (Object)idCardScanFinished.idCardScanningResult)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

