/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.mrz;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewKt;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.CameraModule;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.mrzscanner.MRZScanner;
import io.scanbot.sdk.mrzscanner.MRZScannerFrameHandler;
import io.scanbot.sdk.ui.base.databinding.ScanbotSdkCameraViewPermissionPlaceholderBinding;
import io.scanbot.sdk.ui.camera.CameraUiSettings;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.ui.camera.ScanbotCameraContainerView;
import io.scanbot.sdk.ui.mrz.R;
import io.scanbot.sdk.ui.mrz.databinding.ScanbotSdkMrzCameraViewBinding;
import io.scanbot.sdk.ui.mrz.databinding.ScanbotSdkMrzDescriptionViewBinding;
import io.scanbot.sdk.ui.view.base.IPermissionViewModel;
import io.scanbot.sdk.ui.view.base.configuration.CameraOrientationMode;
import io.scanbot.sdk.ui.view.mrz.IMRZCameraView;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001FB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020$H\u0002J\b\u0010(\u001a\u00020)H\u0015J\u001c\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-H\u0016J\u000e\u00100\u001a\u00020$2\u0006\u00101\u001a\u000202J\b\u00103\u001a\u00020$H\u0014J\u0010\u00104\u001a\u00020$2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020$2\u0006\u00108\u001a\u000209H\u0016J\u000e\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020<J\u0010\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001eH\u0002J\u0010\u0010A\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0010\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020+H\u0014J\u0010\u0010D\u001a\u00020$2\u0006\u0010E\u001a\u00020+H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006G"}, d2={"Lio/scanbot/sdk/ui/view/mrz/MRZCameraView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView;", "Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler$ResultHandler;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraBinding", "Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzCameraViewBinding;", "getCameraBinding", "()Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzCameraViewBinding;", "cameraViewModel", "Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$ViewModel;", "getCameraViewModel", "()Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$ViewModel;", "setCameraViewModel", "(Lio/scanbot/sdk/ui/view/mrz/IMRZCameraView$ViewModel;)V", "descriptionBinding", "Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzDescriptionViewBinding;", "getDescriptionBinding", "()Lio/scanbot/sdk/ui/mrz/databinding/ScanbotSdkMrzDescriptionViewBinding;", "mrzScannerFrameHandler", "Lio/scanbot/sdk/mrzscanner/MRZScannerFrameHandler;", "permissionBinding", "Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;", "getPermissionBinding", "()Lio/scanbot/sdk/ui/base/databinding/ScanbotSdkCameraViewPermissionPlaceholderBinding;", "permissionViewModel", "Lio/scanbot/sdk/ui/view/base/IPermissionViewModel;", "getPermissionViewModel", "()Lio/scanbot/sdk/ui/view/base/IPermissionViewModel;", "setPermissionViewModel", "(Lio/scanbot/sdk/ui/view/base/IPermissionViewModel;)V", "attachPermissionViewModel", "", "viewModel", "attachViewModel", "closeCamera", "getLayoutRes", "", "handle", "", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "Lio/scanbot/sdk/SdkLicenseError;", "initCameraView", "cameraUiSettings", "Lio/scanbot/sdk/ui/camera/CameraUiSettings;", "onDetachedFromWindow", "setCameraModule", "cameraModule", "Lio/scanbot/sdk/camera/CameraModule;", "setCameraOrientationMode", "cameraOrientationMode", "Lio/scanbot/sdk/ui/view/base/configuration/CameraOrientationMode;", "setCameraPreviewMode", "cameraPreviewMode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setMrzScanner", "scanner", "Lio/scanbot/sdk/mrzscanner/MRZScanner;", "subscribePermissionViewModel", "subscribeViews", "updateCameraPermissionView", "cameraPermissionGranted", "updateFlashState", "flash", "Companion", "rtu-ui-mrz_release"})
public class MRZCameraView
extends FrameLayout
implements IMRZCameraView,
MRZScannerFrameHandler.ResultHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public IMRZCameraView.ViewModel cameraViewModel;
    public IPermissionViewModel permissionViewModel;
    private MRZScannerFrameHandler mrzScannerFrameHandler;
    @NotNull
    private final ScanbotSdkMrzCameraViewBinding cameraBinding;
    @NotNull
    private final ScanbotSdkCameraViewPermissionPlaceholderBinding permissionBinding;
    @NotNull
    private final ScanbotSdkMrzDescriptionViewBinding descriptionBinding;
    private static final long CAMERA_OPENED_DELAY_MILLIS = 300L;

    public MRZCameraView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        View view = LayoutInflater.from((Context)context).inflate(this.getLayoutRes(), (ViewGroup)this, true);
        ScanbotSdkMrzCameraViewBinding scanbotSdkMrzCameraViewBinding = ScanbotSdkMrzCameraViewBinding.bind(view.findViewById(R.id.cameraRootLayout));
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkMrzCameraViewBinding, (String)"bind(view.findViewById(R.id.cameraRootLayout))");
        this.cameraBinding = scanbotSdkMrzCameraViewBinding;
        ScanbotSdkMrzDescriptionViewBinding scanbotSdkMrzDescriptionViewBinding = ScanbotSdkMrzDescriptionViewBinding.bind((View)this.cameraBinding.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkMrzDescriptionViewBinding, (String)"bind(cameraBinding.root)");
        this.descriptionBinding = scanbotSdkMrzDescriptionViewBinding;
        ScanbotSdkCameraViewPermissionPlaceholderBinding scanbotSdkCameraViewPermissionPlaceholderBinding = this.cameraBinding.cameraPermissionView;
        Intrinsics.checkNotNullExpressionValue((Object)scanbotSdkCameraViewPermissionPlaceholderBinding, (String)"cameraBinding.cameraPermissionView");
        this.permissionBinding = scanbotSdkCameraViewPermissionPlaceholderBinding;
        this.cameraBinding.cancelView.setOnClickListener(arg_0 -> MRZCameraView._init_$lambda-0(this, arg_0));
        this.cameraBinding.flashBtn.setOnClickListener(arg_0 -> MRZCameraView._init_$lambda-1(this, arg_0));
        boolean hasCameraFlash = context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
        this.cameraBinding.flashBtn.setVisibility(hasCameraFlash ? 0 : 4);
        this.permissionBinding.enableCameraBtn.setOnClickListener(arg_0 -> MRZCameraView._init_$lambda-2(this, arg_0));
    }

    @NotNull
    public final IMRZCameraView.ViewModel getCameraViewModel() {
        IMRZCameraView.ViewModel viewModel = this.cameraViewModel;
        if (viewModel != null) {
            return viewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cameraViewModel");
        return null;
    }

    public final void setCameraViewModel(@NotNull IMRZCameraView.ViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"<set-?>");
        this.cameraViewModel = viewModel;
    }

    @NotNull
    public final IPermissionViewModel getPermissionViewModel() {
        IPermissionViewModel iPermissionViewModel = this.permissionViewModel;
        if (iPermissionViewModel != null) {
            return iPermissionViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"permissionViewModel");
        return null;
    }

    public final void setPermissionViewModel(@NotNull IPermissionViewModel iPermissionViewModel) {
        Intrinsics.checkNotNullParameter((Object)iPermissionViewModel, (String)"<set-?>");
        this.permissionViewModel = iPermissionViewModel;
    }

    @NotNull
    public final ScanbotSdkMrzCameraViewBinding getCameraBinding() {
        return this.cameraBinding;
    }

    @NotNull
    public final ScanbotSdkCameraViewPermissionPlaceholderBinding getPermissionBinding() {
        return this.permissionBinding;
    }

    @NotNull
    public final ScanbotSdkMrzDescriptionViewBinding getDescriptionBinding() {
        return this.descriptionBinding;
    }

    @LayoutRes
    protected int getLayoutRes() {
        return R.layout.scanbot_sdk_mrz_camera_view;
    }

    private final void setMrzScanner(MRZScanner scanner) {
        ScanbotCameraContainerView scanbotCameraContainerView = this.cameraBinding.scanbotCameraView;
        Intrinsics.checkNotNullExpressionValue((Object)scanbotCameraContainerView, (String)"cameraBinding.scanbotCameraView");
        this.mrzScannerFrameHandler = MRZScannerFrameHandler.Companion.attach((IScanbotCameraView)scanbotCameraContainerView, scanner);
        MRZScannerFrameHandler mRZScannerFrameHandler = this.mrzScannerFrameHandler;
        if (mRZScannerFrameHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mrzScannerFrameHandler");
            mRZScannerFrameHandler = null;
        }
        mRZScannerFrameHandler.addResultHandler((MRZScannerFrameHandler.ResultHandler)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closeCamera();
    }

    @Override
    public void attachViewModel(@NotNull IMRZCameraView.ViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.setCameraViewModel(viewModel);
        this.setMrzScanner(viewModel.getScanner());
        this.subscribeViews(viewModel);
    }

    @Override
    public void attachPermissionViewModel(@NotNull IPermissionViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.setPermissionViewModel(viewModel);
        this.subscribePermissionViewModel(viewModel);
    }

    private final void subscribePermissionViewModel(IPermissionViewModel viewModel) {
        block0: {
            LifecycleOwner lifecycleOwner;
            LifecycleOwner lifecycleOwner2 = ViewKt.findViewTreeLifecycleOwner((View)((View)this));
            if (lifecycleOwner2 == null || (lifecycleOwner2 = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)lifecycleOwner2)) == null) break block0;
            LifecycleOwner $this$subscribePermissionViewModel_u24lambda_u2d3 = lifecycleOwner = lifecycleOwner2;
            boolean bl = false;
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getCameraPermissionGranted()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ MRZCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean granted = this.Z$0;
                            this.this$0.updateCameraPermissionView(granted);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<Boolean, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.Z$0 = (Boolean)value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribePermissionViewModel_u24lambda_u2d3));
        }
    }

    @Override
    public void setCameraOrientationMode(@NotNull CameraOrientationMode cameraOrientationMode) {
        Intrinsics.checkNotNullParameter((Object)cameraOrientationMode, (String)"cameraOrientationMode");
        switch (WhenMappings.$EnumSwitchMapping$0[cameraOrientationMode.ordinal()]) {
            case 1: {
                this.cameraBinding.scanbotCameraView.lockToPortrait(true);
                break;
            }
            case 2: {
                this.cameraBinding.scanbotCameraView.lockToLandscape(true);
            }
        }
    }

    @Override
    public void setCameraModule(@NotNull CameraModule cameraModule) {
        Intrinsics.checkNotNullParameter((Object)cameraModule, (String)"cameraModule");
        this.cameraBinding.scanbotCameraView.setCameraModule(cameraModule);
    }

    public final void setCameraPreviewMode(@NotNull CameraPreviewMode cameraPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)cameraPreviewMode, (String)"cameraPreviewMode");
        this.cameraBinding.scanbotCameraView.setPreviewMode(cameraPreviewMode);
    }

    public boolean handle(@NotNull FrameHandlerResult<MRZRecognitionResult, SdkLicenseError> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        this.getCameraViewModel().mrzCodeScanned(result);
        return false;
    }

    private final void closeCamera() {
        this.cameraBinding.scanbotCameraView.onPause();
    }

    public final void initCameraView(@NotNull CameraUiSettings cameraUiSettings) {
        Intrinsics.checkNotNullParameter((Object)cameraUiSettings, (String)"cameraUiSettings");
        this.cameraBinding.scanbotCameraView.setCameraType(cameraUiSettings.getUseCameraX() ? ScanbotCameraContainerView.CameraType.CAMERA_X : ScanbotCameraContainerView.CameraType.CWAC_CAMERA);
        this.cameraBinding.scanbotCameraView.setPreviewMode(CameraPreviewMode.FILL_IN);
        this.cameraBinding.scanbotCameraView.setCameraOpenCallback(() -> MRZCameraView.initCameraView$lambda-5(this));
    }

    private final void subscribeViews(IMRZCameraView.ViewModel viewModel) {
        block0: {
            LifecycleOwner lifecycleOwner;
            LifecycleOwner lifecycleOwner2 = ViewKt.findViewTreeLifecycleOwner((View)((View)this));
            if (lifecycleOwner2 == null || (lifecycleOwner2 = LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)lifecycleOwner2)) == null) break block0;
            LifecycleOwner $this$subscribeViews_u24lambda_u2d6 = lifecycleOwner = lifecycleOwner2;
            boolean bl = false;
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getCameraOpened()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ MRZCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            if (value) {
                                this.this$0.getCameraBinding().scanbotCameraView.onResume();
                            } else {
                                this.this$0.getCameraBinding().scanbotCameraView.onPause();
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<Boolean, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.Z$0 = (Boolean)value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u2d6));
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getStopNewFrames()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ MRZCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            MRZScannerFrameHandler mRZScannerFrameHandler = MRZCameraView.access$getMrzScannerFrameHandler$p(this.this$0);
                            if (mRZScannerFrameHandler == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"mrzScannerFrameHandler");
                                mRZScannerFrameHandler = null;
                            }
                            mRZScannerFrameHandler.setEnabled(!value);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<Boolean, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.Z$0 = (Boolean)value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u2d6));
            FlowKt.launchIn((Flow)FlowKt.onEach((Flow)((Flow)viewModel.getFlash()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ MRZCameraView this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            boolean value = this.Z$0;
                            MRZCameraView.access$updateFlashState(this.this$0, value);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<Boolean, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.Z$0 = (Boolean)value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(boolean p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)((CoroutineScope)$this$subscribeViews_u24lambda_u2d6));
        }
    }

    protected void updateCameraPermissionView(boolean cameraPermissionGranted) {
        if (cameraPermissionGranted) {
            this.permissionBinding.cameraPermissionView.setVisibility(8);
            this.cameraBinding.scanbotCameraView.restartPreview();
        } else {
            this.permissionBinding.cameraPermissionView.setVisibility(0);
        }
    }

    private final void updateFlashState(boolean flash) {
        if (((Boolean)this.getCameraViewModel().getCameraOpened().getValue()).booleanValue()) {
            this.cameraBinding.flashBtn.setChecked(flash);
            this.cameraBinding.scanbotCameraView.useFlash(flash);
        }
    }

    private static final void _init_$lambda-0(MRZCameraView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getCameraViewModel().onCancelClicked();
    }

    private static final void _init_$lambda-1(MRZCameraView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getCameraViewModel().onFlashClicked();
    }

    private static final void _init_$lambda-2(MRZCameraView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getPermissionViewModel().onActivateCameraPermission();
    }

    private static final void initCameraView$lambda-5$lambda-4(MRZCameraView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cameraBinding.scanbotCameraView.setShutterSound(false);
        this$0.updateFlashState((Boolean)this$0.getCameraViewModel().getFlash().getValue());
        this$0.cameraBinding.scanbotCameraView.continuousFocus();
    }

    private static final void initCameraView$lambda-5(MRZCameraView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cameraBinding.scanbotCameraView.postDelayed(() -> MRZCameraView.initCameraView$lambda-5$lambda-4(this$0), 300L);
    }

    public static final /* synthetic */ MRZScannerFrameHandler access$getMrzScannerFrameHandler$p(MRZCameraView $this) {
        return $this.mrzScannerFrameHandler;
    }

    public static final /* synthetic */ void access$updateFlashState(MRZCameraView $this, boolean flash) {
        $this.updateFlashState(flash);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/ui/view/mrz/MRZCameraView$Companion;", "", "()V", "CAMERA_OPENED_DELAY_MILLIS", "", "rtu-ui-mrz_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CameraOrientationMode.values().length];
            nArray[CameraOrientationMode.PORTRAIT.ordinal()] = 1;
            nArray[CameraOrientationMode.LANDSCAPE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

