/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.interactor;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.scanbot.multipleobjectsscanner.MultipleObjectsDetector;
import io.scanbot.multipleobjectsscanner.model.Polygon;
import io.scanbot.sdk.camera.CaptureInfo;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.docprocessing.PageProcessor;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.persistence.PageImageSource;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.RotateOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/scanbot/sdk/ui/view/interactor/DetectSaveMultipleObjectsUseCase;", "", "pageProcessor", "Lio/scanbot/sdk/docprocessing/PageProcessor;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "imageProcessor", "Lio/scanbot/sdk/process/ImageProcessor;", "multipleObjectsDetector", "Lio/scanbot/multipleobjectsscanner/MultipleObjectsDetector;", "(Lio/scanbot/sdk/docprocessing/PageProcessor;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/process/ImageProcessor;Lio/scanbot/multipleobjectsscanner/MultipleObjectsDetector;)V", "detectAndSave", "Lio/reactivex/Flowable;", "", "Lio/scanbot/sdk/persistence/Page;", "image", "", "captureInfo", "Lio/scanbot/sdk/camera/CaptureInfo;", "detectObjectsIntoPages", "bitmap", "Landroid/graphics/Bitmap;", "encodeAndRotateImage", "imageOrientation", "", "rtu-ui-multipleobjects_release"})
public final class DetectSaveMultipleObjectsUseCase {
    private final PageProcessor pageProcessor;
    private final PageFileStorage pageFileStorage;
    private final ImageProcessor imageProcessor;
    private final MultipleObjectsDetector multipleObjectsDetector;

    @NotNull
    public final Flowable<List<Page>> detectAndSave(@NotNull byte[] image, @NotNull CaptureInfo captureInfo) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)captureInfo, (String)"captureInfo");
        Flowable flowable = Flowable.create((FlowableOnSubscribe)((FlowableOnSubscribe)new FlowableOnSubscribe<List<? extends Page>>(this, image, captureInfo){
            final /* synthetic */ DetectSaveMultipleObjectsUseCase this$0;
            final /* synthetic */ byte[] $image;
            final /* synthetic */ CaptureInfo $captureInfo;

            public final void subscribe(@NotNull FlowableEmitter<List<Page>> source) {
                Intrinsics.checkNotNullParameter(source, (String)"source");
                try {
                    Bitmap bitmap = DetectSaveMultipleObjectsUseCase.access$encodeAndRotateImage(this.this$0, this.$image, this.$captureInfo.getImageOrientation());
                    List result = DetectSaveMultipleObjectsUseCase.access$detectObjectsIntoPages(this.this$0, bitmap, this.$captureInfo);
                    source.onNext((Object)result);
                }
                catch (IOException e) {
                    source.onError((Throwable)e);
                }
            }
            {
                this.this$0 = detectSaveMultipleObjectsUseCase;
                this.$image = byArray;
                this.$captureInfo = captureInfo;
            }
        }), (BackpressureStrategy)BackpressureStrategy.DROP);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"Flowable.create({ source\u2026ackpressureStrategy.DROP)");
        return flowable;
    }

    private final Bitmap encodeAndRotateImage(byte[] image, int imageOrientation) {
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"bitmap");
        Bitmap bitmap3 = ImageProcessor.processBitmap$default((ImageProcessor)this.imageProcessor, (Bitmap)bitmap2, (List)CollectionsKt.listOf((Object)new RotateOperation(imageOrientation)), (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)bitmap3);
        return bitmap3;
    }

    private final List<Page> detectObjectsIntoPages(Bitmap bitmap, CaptureInfo captureInfo) throws IOException {
        List polygons = this.multipleObjectsDetector.detectOnBitmap(bitmap);
        ArrayList<Page> detectedObjectPages = new ArrayList<Page>();
        PageImageSource pageImageSource = captureInfo.isCapturedAutomatically() ? PageImageSource.AUTOSNAPPING : PageImageSource.MANUAL_SNAP;
        for (Polygon polygon : polygons) {
            String pageId = this.pageFileStorage.add(bitmap);
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"Collections.emptyList()");
            Page page = new Page(pageId, list, DetectionResult.OK, ImageFilterType.NONE, null, null, 0, pageImageSource, 112, null);
            Page croppedPage = this.pageProcessor.cropAndRotate(page, 0, polygon.getPolygonF());
            detectedObjectPages.add(croppedPage);
        }
        return detectedObjectPages;
    }

    @Inject
    public DetectSaveMultipleObjectsUseCase(@NotNull PageProcessor pageProcessor, @NotNull PageFileStorage pageFileStorage, @NotNull ImageProcessor imageProcessor, @NotNull MultipleObjectsDetector multipleObjectsDetector) {
        Intrinsics.checkNotNullParameter((Object)pageProcessor, (String)"pageProcessor");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)imageProcessor, (String)"imageProcessor");
        Intrinsics.checkNotNullParameter((Object)multipleObjectsDetector, (String)"multipleObjectsDetector");
        this.pageProcessor = pageProcessor;
        this.pageFileStorage = pageFileStorage;
        this.imageProcessor = imageProcessor;
        this.multipleObjectsDetector = multipleObjectsDetector;
    }

    public static final /* synthetic */ Bitmap access$encodeAndRotateImage(DetectSaveMultipleObjectsUseCase $this, byte[] image, int imageOrientation) {
        return $this.encodeAndRotateImage(image, imageOrientation);
    }

    public static final /* synthetic */ List access$detectObjectsIntoPages(DetectSaveMultipleObjectsUseCase $this, Bitmap bitmap, CaptureInfo captureInfo) {
        return $this.detectObjectsIntoPages(bitmap, captureInfo);
    }
}

