/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.os.SystemClock;
import io.scanbot.sap.SapManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import net.doo.snap.blob.BlobManager;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.DocumentType;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.OcrStatus;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.DocumentClassifier;
import net.doo.snap.intelligence.d;
import net.doo.snap.intelligence.o;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.process.PDFProcessor;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.process.compose.SimpleComposer;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;

public final class c
implements Composer {
    private final Logger a = LoggerProvider.getLogger();
    private final DocumentStoreStrategy b;
    private final net.doo.snap.intelligence.a c;
    private final o d;
    private final BlobManager e;
    private final DocumentClassifier f;
    private final d g;
    private final PDFProcessor h;
    private final SimpleComposer i;
    private final SapManager j;

    @Inject
    public c(DocumentStoreStrategy documentStoreStrategy, net.doo.snap.intelligence.a a2, o o2, BlobManager blobManager, DocumentClassifier documentClassifier, d d2, PDFProcessor pDFProcessor, SimpleComposer simpleComposer, SapManager sapManager) {
        this.j = sapManager;
        this.b = documentStoreStrategy;
        this.c = a2;
        this.d = o2;
        this.e = blobManager;
        this.f = documentClassifier;
        this.g = d2;
        this.h = pDFProcessor;
        this.i = simpleComposer;
    }

    @Override
    public final void composeDocument(Document document, Page ... pageArray) throws IOException {
        if (!this.j.isLicenseActive() || !this.j.isFeatureEnabled(16)) {
            return;
        }
        try {
            String string;
            Language language;
            long l2 = SystemClock.elapsedRealtime();
            if (this.e.hasActiveDownloads()) {
                throw new IOException("Downloading in progress");
            }
            Set<Language> set = this.e.getAllLanguagesWithAvailableOcrBlobs();
            if (!set.contains((Object)(language = this.d.a()))) {
                this.a.d("OCR", "Default language is not available - abort OCR: " + (Object)((Object)language));
                throw new IOException("Blob for default language is not available");
            }
            String string2 = string = this.a(document, pageArray, language, set);
            Language language2 = language;
            Set<Language> set2 = set;
            Document document2 = document;
            c c2 = this;
            document2.setOcrStatus(OcrStatus.DONE);
            document2.setOcrText(string2);
            Language language3 = language2;
            Set<Language> set3 = set2;
            String string3 = string2;
            Document document3 = document2;
            c c3 = c2;
            ArrayList<Language> arrayList = new ArrayList<Language>(c3.c.a(string3));
            arrayList.retainAll(set3);
            arrayList.add(language3);
            document3.setLanguage((Language)((Object)arrayList.get(0)));
            String string4 = string2;
            Document document4 = document2;
            c c4 = c2;
            Language language4 = document4.getLanguage();
            if (language4 != null) {
                try {
                    DocumentType documentType = c4.f.classifyDocument(language4, string4);
                    document4.setDocumentType(documentType);
                }
                catch (IOException iOException) {
                    c4.a.logException(iOException);
                }
            }
            document3 = document2;
            c3 = c2;
            if (document3.getLanguage() != null) {
                c3.a.d("OCR", "Document language assigned: " + document3.getLanguage().getIsoCode());
            }
            document2 = document;
            c2 = this;
            if (document2.getLanguage() != null) {
                long l3 = SystemClock.elapsedRealtime() - l2;
                c2.a.d("OCR", "Ocr total: " + (float)l3 / 1000.0f + " sec");
            }
            return;
        }
        catch (IOException iOException) {
            this.i.composeDocument(document, pageArray);
            return;
        }
    }

    private void a() throws IOException {
        if (this.e.hasActiveDownloads()) {
            throw new IOException("Downloading in progress");
        }
    }

    private String a(Document document, Page[] pageArray, final Language language, Set<Language> set) throws IOException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(new Runnable(){

            @Override
            public final void run() {
                try {
                    c.this.f.initialize(language);
                    return;
                }
                catch (IOException iOException) {
                    c.this.a.logException(iOException);
                    return;
                }
            }
        });
        try {
            String string = this.a(document, pageArray, set, language);
            this.h.processPDF(document, pageArray);
            String string2 = string;
            return string2;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private String a(Document document, Page[] pageArray, Set<Language> set, Language language) throws IOException {
        String string;
        this.a.d("OCR", "Starting OCR with language: " + (Object)((Object)language));
        try {
            string = this.b(document, pageArray, set, language);
        }
        catch (a a2) {
            string = this.a(document, pageArray, a2.a());
        }
        return string;
    }

    private String b(Document document, Page[] pageArray, Set<Language> set, Language language) throws IOException, a {
        String string;
        d.a a2 = this.g.a(document, pageArray, Collections.singletonList(language));
        try {
            boolean bl = false;
            while (a2.a()) {
                if (bl) continue;
                try {
                    HashSet<Language> hashSet = new HashSet<Language>(this.c.a(a2.b()));
                    this.a.d("OCR", "Detected languages: " + Arrays.toString(hashSet.toArray()));
                    hashSet.retainAll(set);
                    if (hashSet.isEmpty()) {
                        hashSet.addAll(set);
                        this.a.d("OCR", "None of them are available");
                    }
                    if (hashSet.size() == 1 && hashSet.contains((Object)language)) {
                        bl = true;
                        this.a.d("OCR", "Continue with current language");
                        continue;
                    }
                    this.a.d("OCR", "Languages are not match. Restart with languages: " + Arrays.toString(hashSet.toArray()));
                    throw new a(hashSet);
                }
                catch (IOException iOException) {
                    this.a.logException(iOException);
                    bl = true;
                }
            }
            string = a2.b();
        }
        finally {
            a2.e();
        }
        return string;
    }

    private String a(Document document, Page[] pageArray, Collection<Language> collection) throws IOException {
        FileUtils.deleteQuietly((File)this.b.getDocumentFile(document.getId(), document.getName()));
        d.a a2 = this.g.a(document, pageArray, collection);
        try {
            while (a2.a()) {
            }
            String string = a2.b();
            return string;
        }
        finally {
            a2.e();
        }
    }

    private void a(Document document, Set<Language> set, Language language, String string) throws IOException {
        document.setOcrStatus(OcrStatus.DONE);
        document.setOcrText(string);
        Enum enum_ = language;
        Object object = set;
        String string2 = string;
        Document document2 = document;
        c c2 = this;
        ArrayList<Language> arrayList = new ArrayList<Language>(c2.c.a(string2));
        arrayList.retainAll((Collection<?>)object);
        arrayList.add((Language)enum_);
        document2.setLanguage((Language)((Object)arrayList.get(0)));
        string2 = string;
        document2 = document;
        c2 = this;
        object = document2.getLanguage();
        if (object != null) {
            try {
                enum_ = c2.f.classifyDocument((Language)((Object)object), string2);
                document2.setDocumentType((DocumentType)enum_);
            }
            catch (IOException iOException) {
                c2.a.logException(iOException);
            }
        }
        document2 = document;
        c2 = this;
        if (document2.getLanguage() != null) {
            c2.a.d("OCR", "Document language assigned: " + document2.getLanguage().getIsoCode());
        }
    }

    private void a(Document document, String string, Set<Language> set, Language language) throws IOException {
        ArrayList<Language> arrayList = new ArrayList<Language>(this.c.a(string));
        arrayList.retainAll(set);
        arrayList.add(language);
        document.setLanguage((Language)((Object)arrayList.get(0)));
    }

    private void a(Document document, String string) {
        Language language = document.getLanguage();
        if (language == null) {
            return;
        }
        try {
            DocumentType documentType = this.f.classifyDocument(language, string);
            document.setDocumentType(documentType);
            return;
        }
        catch (IOException iOException) {
            this.a.logException(iOException);
            return;
        }
    }

    private void a(Document document, long l2) {
        if (document.getLanguage() == null) {
            return;
        }
        long l3 = SystemClock.elapsedRealtime() - l2;
        this.a.d("OCR", "Ocr total: " + (float)l3 / 1000.0f + " sec");
    }

    private void a(Document document) {
        if (document.getLanguage() != null) {
            this.a.d("OCR", "Document language assigned: " + document.getLanguage().getIsoCode());
        }
    }

    private static final class a
    extends Exception {
        private final Collection<Language> a;

        public a(Collection<Language> collection) {
            this.a = collection;
        }

        public final Collection<Language> a() {
            return this.a;
        }
    }
}

