/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.content.Context;
import com.google.zxing.Result;
import io.scanbot.sap.SapManager;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.doo.snap.ScanbotSDK;
import net.doo.snap.c.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.camera.barcode.ScanbotBarcodeDetector;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class BarcodeDetectorFrameHandler
implements PreviewBuffer.FrameHandler {
    private static final int DEFAULT_BARCODE_DETECTION_INTERVAL_IN_MS = 10000;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private final ScanbotBarcodeDetector barcodeDetector;
    private boolean enabled = true;
    private boolean intervalEnabled = true;
    private long detectionIntervalInMs = 10000L;

    public static BarcodeDetectorFrameHandler attach(ScanbotCameraView scanbotCameraView, ScanbotSDK scanbotSDK) {
        BarcodeDetectorFrameHandler barcodeDetectorFrameHandler = new BarcodeDetectorFrameHandler(scanbotCameraView.getContext(), scanbotSDK);
        scanbotCameraView.getPreviewBuffer().addFrameHandler(barcodeDetectorFrameHandler);
        return barcodeDetectorFrameHandler;
    }

    public BarcodeDetectorFrameHandler(Context context, ScanbotSDK scanbotSDK) {
        this.barcodeDetector = scanbotSDK.barcodeDetector();
        this.sapManager = c.a(context);
    }

    @Override
    public synchronized boolean handleFrame(byte[] byArray, int n2, int n3, int n4) {
        this.logger.logMethod();
        if (!(this.enabled && this.sapManager.isLicenseActive() && this.intervalEnabled)) {
            return false;
        }
        Result result = this.barcodeDetector.decodeWithState(byArray, n2, n3);
        if (result != null) {
            this.intervalEnabled = false;
            new Timer().schedule(new TimerTask(){

                @Override
                public final void run() {
                    BarcodeDetectorFrameHandler.this.intervalEnabled = true;
                }
            }, this.detectionIntervalInMs);
        }
        return this.notifyHandlers(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(resultHandler);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler resultHandler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(resultHandler);
            return;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setDetectionInterval(long l2) {
        this.detectionIntervalInMs = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(Result result) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(result);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(Result var1);
    }
}

