/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera.barcode;

import android.content.Context;
import android.graphics.Point;
import android.util.SparseArray;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.BarcodeDetector;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import io.scanbot.sap.SapManager;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import net.doo.snap.c.c;
import net.doo.snap.camera.barcode.ScanbotBarcodeDetector;

public class GoogleVisionBarcodeDetector
implements ScanbotBarcodeDetector {
    private final SapManager sapManager;
    private final BarcodeDetector detector;
    private AtomicBoolean barcodeScanEnabled = new AtomicBoolean(true);

    @Inject
    public GoogleVisionBarcodeDetector(Context context) {
        this.detector = new BarcodeDetector.Builder(context).build();
        this.sapManager = c.a(context);
    }

    @Override
    public void enableBarcodeScan(boolean bl) {
        this.barcodeScanEnabled.set(bl);
    }

    @Override
    public Result decodeWithState(byte[] byArray, int n2, int n3) {
        Result result = null;
        if (this.barcodeScanEnabled.compareAndSet(false, false)) {
            return null;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        if (this.detector == null || !this.detector.isOperational()) {
            return null;
        }
        try {
            ByteBuffer byteBuffer = MappedByteBuffer.wrap(byArray);
            Frame frame = new Frame.Builder().setImageData(byteBuffer, n2, n3, 17).build();
            SparseArray sparseArray = this.detector.detect(frame);
            if (sparseArray.size() > 0) {
                Barcode barcode = (Barcode)sparseArray.valueAt(0);
                result = new Result(barcode.rawValue, barcode.rawValue.getBytes(), this.getCornerPoints(barcode.cornerPoints), this.getFormat(barcode.format));
            }
        }
        finally {
            this.detector.release();
        }
        return result;
    }

    private ResultPoint[] getCornerPoints(Point[] pointArray) {
        ArrayList<ResultPoint> arrayList = new ArrayList<ResultPoint>();
        Point[] pointArray2 = pointArray;
        int n2 = pointArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Point point = pointArray2[i2];
            arrayList.add(new ResultPoint((float)point.x, (float)point.y));
        }
        return arrayList.toArray(new ResultPoint[arrayList.size()]);
    }

    private BarcodeFormat getFormat(int n2) {
        switch (n2) {
            case 4096: {
                return BarcodeFormat.AZTEC;
            }
            case 8: {
                return BarcodeFormat.CODABAR;
            }
            case 2: {
                return BarcodeFormat.CODE_39;
            }
            case 4: {
                return BarcodeFormat.CODE_93;
            }
            case 1: {
                return BarcodeFormat.CODE_128;
            }
            case 16: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 64: {
                return BarcodeFormat.EAN_8;
            }
            case 32: {
                return BarcodeFormat.EAN_13;
            }
            case 128: {
                return BarcodeFormat.ITF;
            }
            case 2048: {
                return BarcodeFormat.PDF_417;
            }
            case 256: {
                return BarcodeFormat.QR_CODE;
            }
            case 512: {
                return BarcodeFormat.UPC_A;
            }
            case 1024: {
                return BarcodeFormat.UPC_E;
            }
        }
        return null;
    }
}

