/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.entity;

import android.util.SparseArray;

public enum RotationType {
    ROTATION_0(0),
    ROTATION_90(90),
    ROTATION_180(180),
    ROTATION_270(270),
    ROTATION_360(360);

    private final int degrees;
    private static final SparseArray<RotationType> degrees2Type;

    private RotationType(int n3) {
        this.degrees = n3;
    }

    public static RotationType rotateClockwise(RotationType rotationType) {
        RotationType rotationType2 = ROTATION_0;
        switch (rotationType) {
            case ROTATION_360: 
            case ROTATION_0: {
                rotationType2 = ROTATION_90;
                break;
            }
            case ROTATION_90: {
                rotationType2 = ROTATION_180;
                break;
            }
            case ROTATION_180: {
                rotationType2 = ROTATION_270;
                break;
            }
            case ROTATION_270: {
                rotationType2 = ROTATION_360;
            }
        }
        return rotationType2;
    }

    public final int getDegrees() {
        return this.degrees;
    }

    public static RotationType getByDegrees(int n2) {
        RotationType rotationType = (RotationType)((Object)degrees2Type.get(n2));
        if (rotationType == null) {
            throw new IllegalStateException("no rottation type for: " + n2);
        }
        return rotationType;
    }

    static {
        degrees2Type = new SparseArray();
        for (RotationType rotationType : RotationType.values()) {
            degrees2Type.put(rotationType.degrees, (Object)rotationType);
        }
    }
}

