/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.bitmap;

import android.graphics.Bitmap;

public class ImageQualityOptimizer {
    public Bitmap optimizeImage(Bitmap bitmap, float f2, float f3, long l2) {
        float f4;
        int n2 = bitmap.getHeight();
        int n3 = bitmap.getWidth();
        float f5 = Math.round((float)Math.max(n2, n3) / Math.max(f3, f2));
        float f6 = (float)l2 / f5;
        if (f4 >= 1.0f) {
            return bitmap;
        }
        int n4 = Math.round((float)n3 * f6);
        int n5 = Math.round((float)n2 * f6);
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n4, (int)n5, (boolean)false);
    }

    public final Bitmap optimizeImage(Bitmap bitmap, long l2) {
        return this.optimizeImage(bitmap, PaperFormat.A4.widthInches, PaperFormat.A4.heightInches, l2);
    }

    public static enum PaperFormat {
        A1(23.4f, 33.1f),
        A2(16.5f, 23.4f),
        A3(11.7f, 16.5f),
        A4(8.3f, 11.7f),
        A5(5.8f, 8.3f),
        US_LETTER(8.5f, 11.0f),
        US_LEGAL(8.5f, 14.0f);

        public final float widthInches;
        public final float heightInches;

        private PaperFormat(float f2, float f3) {
            this.widthInches = f2;
            this.heightInches = f3;
        }
    }
}

