/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.util.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class BackgroundThreadFactory
implements ThreadFactory {
    private static final int DEFAULT_THREAD_PRIORITY = 4;
    private static final String DEFAULT_THREAD_NAME = "WORKER_THREAD_";
    private final AtomicInteger threadCounter = new AtomicInteger(0);
    private final int threadPriority;
    private final String threadNamePrefix;

    public BackgroundThreadFactory(int n2, String string2) {
        this.threadPriority = n2;
        this.threadNamePrefix = string2;
    }

    public BackgroundThreadFactory() {
        this(4, DEFAULT_THREAD_NAME);
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setPriority(this.threadPriority);
        thread.setName(this.threadNamePrefix + this.threadCounter.incrementAndGet());
        thread.setDaemon(true);
        return thread;
    }
}

