/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import net.doo.snap.R;
import net.doo.snap.ui.EditPolygonImageView;
import net.doo.snap.util.bitmap.BitmapUtils;

public class MagnifierView
extends View {
    private final Drawable magnifierDrawable;
    private final float magnifierRaduis;
    private final float magnifierMargin;
    private a magnifier = new a();
    private PointF zoomPoint;
    private Bitmap magnifierFrameBitmap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MagnifierView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.MagnifierView, 0, 0);
        try {
            this.magnifierDrawable = typedArray.getDrawable(R.styleable.MagnifierView_magnifierImageSrc);
            this.magnifierRaduis = typedArray.getDimension(R.styleable.MagnifierView_magnifierRadius, this.getResources().getDimension(R.dimen.magnifier_raduis));
            this.magnifierMargin = typedArray.getDimension(R.styleable.MagnifierView_magnifierMargin, this.getResources().getDimension(R.dimen.magnifier_margin));
        }
        finally {
            typedArray.recycle();
        }
    }

    void drawMagnifier(PointF pointF) {
        this.zoomPoint = pointF;
        this.invalidate();
    }

    void eraseMagnifier() {
        this.zoomPoint = null;
        this.invalidate();
    }

    void setImageRotation(float f2) {
        this.magnifier.a(f2);
        this.invalidate();
    }

    public void setupMagnifier(EditPolygonImageView editPolygonImageView) {
        Bitmap bitmap = BitmapUtils.drawableToBitmap(editPolygonImageView.getDrawable());
        this.magnifier.a(bitmap, editPolygonImageView.getRotation(), -16777216);
        editPolygonImageView.setMagnifier(this);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.zoomPoint != null) {
            this.magnifier.a(canvas, this.zoomPoint);
        } else {
            canvas.drawColor(0);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        this.magnifierFrameBitmap = BitmapUtils.drawableToBitmap(this.magnifierDrawable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.magnifierFrameBitmap.recycle();
        this.magnifierFrameBitmap = null;
        this.magnifier.a();
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        this.magnifier.a(this.getWidth(), this.getHeight());
    }

    private class a {
        private final float b = 2.0f;
        private float c;
        private int d;
        private int e;
        private BitmapShader f;
        private Paint g;
        private Matrix h = new Matrix();
        private float i;
        private float j;
        private float k;
        private Bitmap l;

        a() {
        }

        void a(int n2, int n3) {
            this.d = n2;
            this.e = n3;
            if (this.l != null && n2 != 0 && n3 != 0) {
                this.c = Math.max((float)this.l.getWidth() / (float)this.d, (float)this.l.getHeight() / (float)this.e);
                this.i = ((float)this.d - (float)this.l.getWidth() / this.c) / 2.0f;
                this.j = ((float)this.e - (float)this.l.getHeight() / this.c) / 2.0f;
            }
        }

        void a(Bitmap bitmap, float f2, int n2) {
            if (BitmapUtils.isBitmapValid(bitmap)) {
                if (this.f != null) {
                    this.a();
                }
                this.l = this.a(bitmap, n2);
                this.f = new BitmapShader(this.l, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
                this.g = new Paint();
                this.g.setShader((Shader)this.f);
                this.k = f2;
                this.a(MagnifierView.this.getWidth(), MagnifierView.this.getHeight());
            }
        }

        void a() {
            if (this.l != null) {
                this.l.recycle();
            }
            this.l = null;
            this.g = null;
            this.f = null;
        }

        private Bitmap a(Bitmap bitmap, int n2) {
            Canvas canvas = new Canvas(bitmap);
            Paint paint = new Paint();
            paint.setColor(n2);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(0.0f);
            canvas.drawRect(0.0f, 0.0f, (float)(bitmap.getWidth() - 1), (float)(bitmap.getHeight() - 1), paint);
            return bitmap;
        }

        void a(Canvas canvas, PointF pointF) {
            float f2 = MagnifierView.this.magnifierMargin;
            float f3 = MagnifierView.this.magnifierMargin;
            if (this.a(pointF)) {
                f2 = (float)MagnifierView.this.getWidth() - MagnifierView.this.magnifierRaduis * 2.0f - MagnifierView.this.magnifierMargin;
            }
            this.h.setScale(2.0f, 2.0f);
            this.h.postTranslate(-pointF.x * this.c * 2.0f + MagnifierView.this.magnifierRaduis + f2, -pointF.y * this.c * 2.0f + MagnifierView.this.magnifierRaduis + f3);
            this.f.setLocalMatrix(this.h);
            canvas.save();
            canvas.rotate(this.k, f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis);
            canvas.drawCircle(f2 + MagnifierView.this.magnifierRaduis, f3 + MagnifierView.this.magnifierRaduis, MagnifierView.this.magnifierRaduis, this.g);
            canvas.restore();
            canvas.drawBitmap(MagnifierView.this.magnifierFrameBitmap, f2, f3, null);
        }

        private boolean a(PointF pointF) {
            int n2 = 1;
            n2 = pointF.x + this.i < (float)(this.d >> 1) ? (pointF.y + this.j < (float)(this.e >> 1) ? 1 : 4) : (pointF.y + this.j < (float)(this.e >> 1) ? 2 : 3);
            n2 = (int)((float)n2 - (360.0f - this.k) % 360.0f / 90.0f);
            return n2 == 1;
        }

        void a(float f2) {
            this.k = f2;
        }
    }
}

