/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.process.compose;

import android.graphics.Rect;
import android.graphics.RectF;
import crl.android.pdfwriter.PDFWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.inject.Inject;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Page;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.PDFProcessor;
import net.doo.snap.process.compose.Composer;
import net.doo.snap.util.bitmap.BitmapUtils;
import net.doo.snap.util.pdf.PdfUtils;
import org.apache.commons.io.IOUtils;

public class SimpleComposer
implements Composer {
    private final DocumentStoreStrategy a;
    private final PageStoreStrategy b;
    private final PDFProcessor c;

    @Inject
    public SimpleComposer(DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, PDFProcessor pDFProcessor) {
        this.a = documentStoreStrategy;
        this.b = pageStoreStrategy;
        this.c = pDFProcessor;
    }

    @Override
    public void composeDocument(Document document, Page ... pageArray) throws IOException {
        if (document.getSize() > 0L) {
            throw new IOException("Document already exists");
        }
        PDFWriter pDFWriter = new PDFWriter();
        this.a(pDFWriter, pageArray);
        this.a(document, pDFWriter);
        this.c.processPDF(document, pageArray);
    }

    private void a(PDFWriter pDFWriter, Page[] pageArray) throws IOException {
        for (Page page : pageArray) {
            int n2;
            int n3;
            String string2 = this.b.getImageFile(page.getId(), Page.ImageType.COMBINED).getPath();
            Rect rect = BitmapUtils.getBitmapBounds(string2);
            int n4 = page.getRotationType().getDegrees();
            if (n4 == 90 || n4 == 270) {
                n3 = rect.height();
                n2 = rect.width();
            } else {
                n3 = rect.width();
                n2 = rect.height();
            }
            RectF rectF = PdfUtils.fitToPhysicalBounds(new RectF(0.0f, 0.0f, (float)n3, (float)n2), PdfUtils.defaultPhysicalBounds());
            int n5 = (int)rectF.width();
            int n6 = (int)rectF.height();
            pDFWriter.newPage(n5, n6);
            pDFWriter.addJPGImageKeepRatio(n5, n6, -n4, string2);
        }
        pDFWriter.setDocumentInfo("/Creator (Scanbot for Android)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(Document document, PDFWriter pDFWriter) throws IOException {
        File file = this.a.getDocumentFile(document.getId(), document.getName());
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            pDFWriter.write((OutputStream)bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
    }
}

