/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.camera;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.doo.snap.camera.ContourDetectorFrameHandler;
import net.doo.snap.camera.PictureCallback;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class AutoSnappingController {
    private static final long DEFAULT_CAPTURE_INTERVAL_MS = 1000L;
    private static final long MAXIMUM_CAPTURE_INTERVAL = 3000L;
    private final ScanbotCameraView cameraView;
    private final AtomicLong captureInterval = new AtomicLong(1000L);
    private final Logger logger = LoggerProvider.getLogger();
    private long lastCapture = 0L;
    private boolean capturing = false;
    private boolean ignoreBadAspectRatio = false;
    private final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private boolean isAutoSnapEnabled = true;
    private AtomicBoolean isAutosnappingShooting = new AtomicBoolean(false);
    private AutoSnappingCallback autoSnappingCallback = AutoSnappingCallback.NULL;
    private final Runnable autosnappingShoot = new Runnable(){

        @Override
        public void run() {
            if (AutoSnappingController.this.isAutoSnapEnabled) {
                if (!AutoSnappingController.this.autoSnappingCallback.onAutoSnapping()) {
                    AutoSnappingController.this.cameraView.takePicture(true);
                }
            } else {
                AutoSnappingController.this.isAutosnappingShooting.set(false);
            }
        }
    };

    public static AutoSnappingController attach(ScanbotCameraView cameraView) {
        ContourDetectorFrameHandler contourDetectorFrameHandler = new ContourDetectorFrameHandler(cameraView.getContext());
        return AutoSnappingController.attach(cameraView, contourDetectorFrameHandler);
    }

    public static AutoSnappingController attach(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        return new AutoSnappingController(cameraView, contourDetectorFrameHandler);
    }

    public AutoSnappingController(ScanbotCameraView cameraView, ContourDetectorFrameHandler contourDetectorFrameHandler) {
        this.cameraView = cameraView;
        cameraView.getPreviewBuffer().addFrameHandler(contourDetectorFrameHandler);
        cameraView.addPictureCallback(new d());
        cameraView.addCameraStateCallback(new a());
        cameraView.addTakePictureCallback(new b());
        contourDetectorFrameHandler.addResultHandler(new c());
    }

    private void onDetectionOK() {
        if (!this.isAutosnappingShooting.get()) {
            this.isAutosnappingShooting.set(true);
            this.mainThreadHandler.post(this.autosnappingShoot);
        }
    }

    public void setEnabled(boolean enabled) {
        this.isAutoSnapEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.isAutoSnapEnabled;
    }

    public void setSensitivity(float sensitivity) {
        this.logger.logMethod();
        float f2 = 1.0f - this.clamp(sensitivity);
        this.captureInterval.set((long)(f2 * 3000.0f));
    }

    public void setIgnoreBadAspectRatio(boolean ignoreBadAspectRatio) {
        this.logger.logMethod();
        this.ignoreBadAspectRatio = ignoreBadAspectRatio;
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            return 0.0f;
        }
        if (value > 1.0f) {
            return 1.0f;
        }
        return value;
    }

    public void setAutoSnappingCallback(AutoSnappingCallback callback) {
        this.logger.logMethod();
        this.autoSnappingCallback = callback != null ? callback : AutoSnappingCallback.NULL;
    }

    private class b
    implements net.doo.snap.camera.c {
        private b() {
        }

        @Override
        public void a() {
        }

        @Override
        public void b() {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    private class a
    implements net.doo.snap.camera.b {
        private a() {
        }

        @Override
        public void a() {
            AutoSnappingController.this.capturing = true;
        }

        @Override
        public void b() {
            AutoSnappingController.this.isAutosnappingShooting.set(false);
            AutoSnappingController.this.capturing = false;
            AutoSnappingController.this.lastCapture = 0L;
        }
    }

    private class d
    implements PictureCallback {
        private d() {
        }

        @Override
        public void onPictureTaken(byte[] image, int imageOrientation) {
            AutoSnappingController.this.mainThreadHandler.removeCallbacksAndMessages(null);
            AutoSnappingController.this.isAutosnappingShooting.set(false);
        }
    }

    private class c
    implements ContourDetectorFrameHandler.ResultHandler {
        private c() {
        }

        @Override
        public boolean handleResult(ContourDetectorFrameHandler.DetectedFrame detectedFrame) {
            AutoSnappingController.this.logger.logMethod();
            if ((detectedFrame.detectionResult == DetectionResult.OK || AutoSnappingController.this.ignoreBadAspectRatio && detectedFrame.detectionResult == DetectionResult.OK_BUT_BAD_ASPECT_RATIO) && AutoSnappingController.this.capturing && SystemClock.elapsedRealtime() - AutoSnappingController.this.lastCapture > AutoSnappingController.this.captureInterval.get()) {
                if (AutoSnappingController.this.lastCapture != 0L) {
                    this.a();
                }
                AutoSnappingController.this.lastCapture = SystemClock.elapsedRealtime();
            }
            return false;
        }

        private void a() {
            AutoSnappingController.this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    AutoSnappingController.this.onDetectionOK();
                }
            });
        }
    }

    public static interface AutoSnappingCallback {
        public static final AutoSnappingCallback NULL = new AutoSnappingCallback(){

            @Override
            public boolean onAutoSnapping() {
                return false;
            }
        };

        public boolean onAutoSnapping();
    }
}

