/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.PointF;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageProcessorInteractor$WhenMappings;
import io.scanbot.sdk.persistence.PageStorage;
import io.scanbot.sdk.persistence.PageStorageSettings;
import io.scanbot.sdk.persistence.PolygonHelper;
import io.scanbot.sdk.process.ImageFilterType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.lib.detector.ContourDetector;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011J\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/scanbot/sdk/persistence/PageProcessorInteractor;", "", "pageStorage", "Lio/scanbot/sdk/persistence/PageStorage;", "pageStorageSettings", "Lio/scanbot/sdk/persistence/PageStorageSettings;", "(Lio/scanbot/sdk/persistence/PageStorage;Lio/scanbot/sdk/persistence/PageStorageSettings;)V", "logger", "Lnet/doo/snap/util/log/Logger;", "kotlin.jvm.PlatformType", "createPage", "Lio/scanbot/sdk/persistence/Page;", "srcImage", "Landroid/graphics/Bitmap;", "configuration", "Lio/scanbot/sdk/persistence/PageProcessorInteractor$Configuration;", "createPage$scanbot_sdk_release", "", "createPreviewTo", "", "previewFile", "Ljava/io/File;", "bitmap", "image", "saveBitmapTo", "file", "Configuration", "scanbot-sdk_release"})
public final class PageProcessorInteractor {
    private final Logger logger;
    private final PageStorage pageStorage;
    private final PageStorageSettings pageStorageSettings;

    @NotNull
    public final Page createPage$scanbot_sdk_release(@NotNull byte[] srcImage, @NotNull Configuration configuration) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)srcImage, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])srcImage, (int)0, (int)srcImage.length, (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"originalBitmap");
        return this.createPage$scanbot_sdk_release(bitmap2, configuration);
    }

    @NotNull
    public final Page createPage$scanbot_sdk_release(@NotNull Bitmap srcImage, @NotNull Configuration configuration) {
        ContourDetector contourDetector;
        int n2;
        double d2;
        Object object;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)srcImage, (String)"srcImage");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        String string3 = string2 = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"pageId");
        File file = this.pageStorage.getPageDir(string3);
        FileUtils.forceMkdir((File)file);
        Bitmap bitmap = srcImage;
        if (configuration.getImageOrientation() > 0) {
            object = new Matrix();
            object.setRotate((float)configuration.getImageOrientation(), (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)object, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(orig\u2026ap.height, matrix, false)");
            bitmap = bitmap2;
        }
        if (configuration.getImageScale() != 1.0f) {
            Bitmap bitmap3 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)(configuration.getImageScale() * (float)bitmap.getWidth())), (int)((int)(configuration.getImageScale() * (float)bitmap.getHeight())), (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"Bitmap.createScaledBitma\u2026p.height).toInt(), false)");
            bitmap = bitmap3;
        }
        this.saveBitmapTo(this.pageStorage.getOriginalImage(string2), bitmap);
        if (configuration.getCreatePreview()) {
            int n3 = bitmap.getHeight();
            int n4 = bitmap.getWidth();
            d2 = this.pageStorageSettings.getPreviewTargetMax();
            n2 = Math.max(n3, n4);
            double d3 = d2 / (double)n2;
            contourDetector = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d3)), (int)((int)((double)bitmap.getHeight() * d3)), (boolean)false);
            File file2 = this.pageStorage.getOriginalImagePreview(string2);
            ContourDetector contourDetector2 = contourDetector;
            Intrinsics.checkExpressionValueIsNotNull((Object)contourDetector2, (String)"preview");
            this.saveBitmapTo(file2, (Bitmap)contourDetector2);
        }
        object = PolygonHelper.Companion.getFulPolygon();
        DetectionResult detectionResult = DetectionResult.ERROR_NOTHING_DETECTED;
        if (configuration.getCreateDocument()) {
            contourDetector = new ContourDetector();
            DetectionResult detectionResult2 = contourDetector.detect(bitmap);
            Intrinsics.checkExpressionValueIsNotNull((Object)detectionResult2, (String)"detector.detect(originalBitmap)");
            detectionResult = detectionResult2;
            List list = contourDetector.getPolygonF();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"detector.polygonF");
            object = list;
            Bitmap bitmap4 = contourDetector.processImageF(bitmap, (List)object, ImageFilterType.NONE.getCode());
            File file3 = this.pageStorage.getDocumentImage(string2);
            Bitmap bitmap5 = bitmap4;
            Intrinsics.checkExpressionValueIsNotNull((Object)bitmap5, (String)"documentBitmap");
            this.saveBitmapTo(file3, bitmap5);
            this.saveBitmapTo(this.pageStorage.getUnfilteredDocumentImage(string2), bitmap4);
            if (configuration.getCreatePreview()) {
                int n5 = bitmap4.getHeight();
                int n6 = bitmap4.getWidth();
                d2 = this.pageStorageSettings.getPreviewTargetMax();
                n2 = Math.max(n5, n6);
                double d4 = d2 / (double)n2;
                Bitmap bitmap6 = Bitmap.createScaledBitmap((Bitmap)bitmap4, (int)((int)((double)bitmap4.getWidth() * d4)), (int)((int)((double)bitmap4.getHeight() * d4)), (boolean)false);
                File file4 = this.pageStorage.getDocumentImagePreview(string2);
                Bitmap bitmap7 = bitmap6;
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap7, (String)"preview");
                this.saveBitmapTo(file4, bitmap7);
                this.saveBitmapTo(this.pageStorage.getUnfilteredDocumentImagePreview(string2), bitmap6);
            }
        }
        return new Page(string2, (List<? extends PointF>)object, detectionResult);
    }

    public final void saveBitmapTo(@NotNull File file, @NotNull byte[] bitmap) {
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        BitmapFactory.Options options = new BitmapFactory.Options();
        Bitmap bitmap3 = bitmap2 = BitmapFactory.decodeByteArray((byte[])bitmap, (int)0, (int)bitmap.length, (BitmapFactory.Options)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"originalBitmap");
        this.saveBitmapTo(file, bitmap3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveBitmapTo(@NotNull File file, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        FileOutputStream fileOutputStream = null;
        try {
            Bitmap.CompressFormat compressFormat;
            fileOutputStream = new FileOutputStream(file);
            switch (PageProcessorInteractor$WhenMappings.$EnumSwitchMapping$0[this.pageStorageSettings.getImageFormat().ordinal()]) {
                case 1: {
                    compressFormat = Bitmap.CompressFormat.JPEG;
                    break;
                }
                case 2: {
                    compressFormat = Bitmap.CompressFormat.PNG;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Bitmap.CompressFormat compressFormat2 = compressFormat;
            bitmap.compress(compressFormat2, this.pageStorageSettings.getImageQuality(), (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            this.logger.logException(iOException);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    public final void createPreviewTo(@NotNull File previewFile, @NotNull byte[] image) {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)previewFile, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)image, (String)"image");
        Bitmap bitmap2 = BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
        double d2 = this.pageStorageSettings.getPreviewTargetMax();
        Bitmap bitmap3 = bitmap2;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"bitmap");
        int n2 = bitmap3.getHeight();
        int n3 = bitmap2.getWidth();
        double d3 = d2;
        int n4 = Math.max(n2, n3);
        double d4 = d3 / (double)n4;
        Bitmap bitmap4 = bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)((int)((double)bitmap2.getWidth() * d4)), (int)((int)((double)bitmap2.getHeight() * d4)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap4, (String)"preview");
        this.saveBitmapTo(previewFile, bitmap4);
    }

    public final void createPreviewTo(@NotNull File previewFile, @NotNull Bitmap bitmap) {
        Bitmap bitmap2;
        Intrinsics.checkParameterIsNotNull((Object)previewFile, (String)"previewFile");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        int n2 = bitmap.getHeight();
        int n3 = bitmap.getWidth();
        double d2 = this.pageStorageSettings.getPreviewTargetMax();
        int n4 = Math.max(n2, n3);
        double d3 = d2 / (double)n4;
        Bitmap bitmap3 = bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)((double)bitmap.getWidth() * d3)), (int)((int)((double)bitmap.getHeight() * d3)), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap3, (String)"preview");
        this.saveBitmapTo(previewFile, bitmap3);
    }

    @Inject
    public PageProcessorInteractor(@NotNull PageStorage pageStorage, @NotNull PageStorageSettings pageStorageSettings) {
        Intrinsics.checkParameterIsNotNull((Object)pageStorage, (String)"pageStorage");
        Intrinsics.checkParameterIsNotNull((Object)pageStorageSettings, (String)"pageStorageSettings");
        this.pageStorage = pageStorage;
        this.pageStorageSettings = pageStorageSettings;
        this.logger = LoggerProvider.getLogger();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/persistence/PageProcessorInteractor$Configuration;", "", "createPreview", "", "createDocument", "imageScale", "", "imageOrientation", "", "(ZZFI)V", "getCreateDocument", "()Z", "getCreatePreview", "getImageOrientation", "()I", "getImageScale", "()F", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "scanbot-sdk_release"})
    public static final class Configuration {
        private final boolean createPreview;
        private final boolean createDocument;
        private final float imageScale;
        private final int imageOrientation;
        public static final Companion Companion = new Companion(null);

        public final boolean getCreatePreview() {
            return this.createPreview;
        }

        public final boolean getCreateDocument() {
            return this.createDocument;
        }

        public final float getImageScale() {
            return this.imageScale;
        }

        public final int getImageOrientation() {
            return this.imageOrientation;
        }

        public Configuration(boolean createPreview, boolean createDocument, float imageScale, int imageOrientation) {
            this.createPreview = createPreview;
            this.createDocument = createDocument;
            this.imageScale = imageScale;
            this.imageOrientation = imageOrientation;
        }

        public /* synthetic */ Configuration(boolean bl, boolean bl2, float f2, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                bl = true;
            }
            if ((n3 & 2) != 0) {
                bl2 = false;
            }
            if ((n3 & 4) != 0) {
                f2 = 1.0f;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            this(bl, bl2, f2, n2);
        }

        public Configuration() {
            this(false, false, 0.0f, 0, 15, null);
        }

        public final boolean component1() {
            return this.createPreview;
        }

        public final boolean component2() {
            return this.createDocument;
        }

        public final float component3() {
            return this.imageScale;
        }

        public final int component4() {
            return this.imageOrientation;
        }

        @NotNull
        public final Configuration copy(boolean createPreview, boolean createDocument, float imageScale, int imageOrientation) {
            return new Configuration(createPreview, createDocument, imageScale, imageOrientation);
        }

        @NotNull
        public static /* synthetic */ Configuration copy$default(Configuration configuration, boolean bl, boolean bl2, float f2, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                bl = configuration.createPreview;
            }
            if ((n3 & 2) != 0) {
                bl2 = configuration.createDocument;
            }
            if ((n3 & 4) != 0) {
                f2 = configuration.imageScale;
            }
            if ((n3 & 8) != 0) {
                n2 = configuration.imageOrientation;
            }
            return configuration.copy(bl, bl2, f2, n2);
        }

        public String toString() {
            return "Configuration(createPreview=" + this.createPreview + ", createDocument=" + this.createDocument + ", imageScale=" + this.imageScale + ", imageOrientation=" + this.imageOrientation + ")";
        }

        public int hashCode() {
            int n2 = this.createPreview ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = n2 * 31;
            int n4 = this.createDocument ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            return ((n3 + n4) * 31 + Float.floatToIntBits(this.imageScale)) * 31 + this.imageOrientation;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Configuration)) break block3;
                    Configuration configuration = (Configuration)object;
                    if (!(this.createPreview == configuration.createPreview) || !(this.createDocument == configuration.createDocument) || Float.compare(this.imageScale, configuration.imageScale) != 0 || !(this.imageOrientation == configuration.imageOrientation)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/persistence/PageProcessorInteractor$Configuration$Companion;", "", "()V", "DEFAULT", "Lio/scanbot/sdk/persistence/PageProcessorInteractor$Configuration;", "scanbot-sdk_release"})
        public static final class Companion {
            @NotNull
            public final Configuration DEFAULT() {
                return new Configuration(false, false, 0.0f, 0, 15, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

