/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.mrzscanner;

import android.content.Context;
import android.graphics.Rect;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sap.SapManager;
import java.util.LinkedHashSet;
import java.util.Set;
import net.doo.snap.b.c;
import net.doo.snap.camera.PreviewBuffer;
import net.doo.snap.camera.ScanbotCameraView;
import net.doo.snap.mrzscanner.MRZScanner;
import net.doo.snap.util.log.Logger;
import net.doo.snap.util.log.LoggerProvider;

public class MRZScannerFrameHandler
implements PreviewBuffer.FrameHandler {
    private MRZScanner mrzScanner;
    private final Set<ResultHandler> handlers = new LinkedHashSet<ResultHandler>();
    private final SapManager sapManager;
    private final Logger logger = LoggerProvider.getLogger();
    private boolean enabled = true;

    public static MRZScannerFrameHandler attach(ScanbotCameraView cameraView, MRZScanner mrzScanner) {
        MRZScannerFrameHandler mRZScannerFrameHandler = new MRZScannerFrameHandler(cameraView.getContext(), mrzScanner);
        cameraView.getPreviewBuffer().addFrameHandler(mRZScannerFrameHandler);
        return mRZScannerFrameHandler;
    }

    public MRZScannerFrameHandler(Context context, MRZScanner mrzScanner) {
        this.mrzScanner = mrzScanner;
        this.sapManager = c.a();
    }

    @Override
    public synchronized boolean handleFrame(byte[] frame, int width, int height, int frameOrientation, Rect finderRect) {
        this.logger.logMethod();
        if (!this.enabled) {
            return false;
        }
        if (!this.sapManager.isLicenseActive()) {
            throw new RuntimeException("ScanbotSDK: ERROR - ScanbotSDK license is not valid or expired.");
        }
        MRZRecognitionResult mRZRecognitionResult = finderRect == null ? this.mrzScanner.recognizeMRZ(frame, width, height, frameOrientation) : this.mrzScanner.recognizeMRZWithFinderOverlay(frame, width, height, frameOrientation, finderRect);
        return this.notifyHandlers(mRZRecognitionResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResultHandler(ResultHandler handler) {
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(handler);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyHandlers(MRZRecognitionResult recognitionResult) {
        boolean bl = false;
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            for (ResultHandler resultHandler : this.handlers) {
                bl |= resultHandler.handleResult(recognitionResult);
            }
        }
        return bl;
    }

    public static interface ResultHandler {
        public boolean handleResult(MRZRecognitionResult var1);
    }
}

