/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import io.scanbot.multipleobjectsscanner.model.Polygon;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.multipleobjects.MultipleObjectsFrameHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.doo.snap.R;
import net.doo.snap.lib.detector.DetectionResult;
import net.doo.snap.util.snap.PolygonHelper;

public class MultiplePolygonsView
extends View {
    private static final Property<Paint, Integer> PAINT_ALPHA_PROPERTY = Property.of(Paint.class, Integer.TYPE, (String)"alpha");
    private static final int POLYGON_FADE_OUT_DURATION_MS = 250;
    private List<float[]> listOfPoints = new ArrayList<float[]>();
    private Paint strokePaint;
    private Paint fillPaint;
    private Paint strokePaintOK;
    private Paint fillPaintOK;
    private boolean useFill = false;
    private boolean useFillOK = false;
    private Path path;
    public MultipleObjectsFrameHandler.ResultHandler multipleObjectDetectorHandler = new MultipleObjectsFrameHandler.ResultHandler(){

        public boolean handle(FrameHandlerResult<? extends MultipleObjectsFrameHandler.DetectedData, ? extends SdkLicenseError> result) {
            if (result instanceof FrameHandlerResult.Success) {
                MultipleObjectsFrameHandler.DetectedData detectedData;
                if ((detectedData = (MultipleObjectsFrameHandler.DetectedData)((FrameHandlerResult.Success)detectedData).getValue()).getDetectedPolygons().isEmpty() && MultiplePolygonsView.this.listOfPoints.isEmpty()) {
                    return false;
                }
                if (MultiplePolygonsView.this.polygonUpdating.get()) {
                    return false;
                }
                MultiplePolygonsView.this.post(new Runnable(){

                    @Override
                    public void run() {
                        a a2 = this;
                        a2.MultiplePolygonsView.this.polygonUpdating.set(true);
                        a2.MultiplePolygonsView.this.updatePolygon(detectedData.getDetectedPolygons());
                    }
                });
            }
            return false;
        }
    };
    private ObjectAnimator polygonAlphaAnimator;
    private PolygonHelper polygonHelper;
    private DetectionResult lastResult = DetectionResult.ERROR_NOTHING_DETECTED;
    protected AtomicBoolean polygonUpdating = new AtomicBoolean(false);

    public MultiplePolygonsView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public MultiplePolygonsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    /*
     * WARNING - void declaration
     */
    private void initView(Context context, AttributeSet attrs) {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.strokePaint = new Paint();
        multiplePolygonsView.strokePaint.setColor(-1);
        multiplePolygonsView.strokePaint.setStyle(Paint.Style.STROKE);
        multiplePolygonsView.strokePaint.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        multiplePolygonsView.strokePaint.setAntiAlias(true);
        multiplePolygonsView.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        multiplePolygonsView.fillPaint = new Paint();
        multiplePolygonsView.fillPaint.setColor(-16711936);
        multiplePolygonsView.fillPaint.setStyle(Paint.Style.FILL);
        multiplePolygonsView.strokePaintOK = new Paint();
        multiplePolygonsView.strokePaintOK.setColor(-1);
        multiplePolygonsView.strokePaintOK.setStyle(Paint.Style.STROKE);
        multiplePolygonsView.strokePaintOK.setStrokeWidth(this.getResources().getDimension(R.dimen.polygon_stroke_width));
        multiplePolygonsView.strokePaintOK.setAntiAlias(true);
        multiplePolygonsView.strokePaintOK.setStrokeCap(Paint.Cap.SQUARE);
        multiplePolygonsView.fillPaintOK = new Paint();
        multiplePolygonsView.fillPaintOK.setColor(-16711936);
        multiplePolygonsView.fillPaintOK.setStyle(Paint.Style.FILL);
        multiplePolygonsView.polygonHelper = new PolygonHelper();
        multiplePolygonsView.path = new Path();
        if (attrs != null) {
            void var2_2;
            void var1_1;
            this.loadAttributes((Context)var1_1, (AttributeSet)var2_2);
        }
    }

    private void loadAttributes(Context context, AttributeSet attrs) {
        int n2;
        int n3;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PolygonView);
        try {
            n3 = typedArray.getColor(R.styleable.PolygonView_polygonFillColor, 0);
            n2 = n3 != 0 ? 1 : 0;
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        TypedArray typedArray2 = typedArray;
        MultiplePolygonsView multiplePolygonsView = this;
        this.useFill = n2;
        this.fillPaint.setColor(n3);
        n2 = typedArray.getColor(R.styleable.PolygonView_polygonStrokeColor, -1);
        multiplePolygonsView.strokePaint.setColor(n2);
        n3 = typedArray2.getColor(R.styleable.PolygonView_polygonFillColorOK, n3);
        boolean bl = n3 != 0;
        TypedArray typedArray3 = typedArray;
        MultiplePolygonsView multiplePolygonsView2 = this;
        MultiplePolygonsView multiplePolygonsView3 = multiplePolygonsView2;
        MultiplePolygonsView multiplePolygonsView4 = multiplePolygonsView2;
        TypedArray typedArray4 = typedArray;
        MultiplePolygonsView multiplePolygonsView5 = this;
        this.useFillOK = bl;
        this.fillPaintOK.setColor(n3);
        n3 = typedArray.getColor(R.styleable.PolygonView_polygonStrokeColorOK, n2);
        multiplePolygonsView5.strokePaintOK.setColor(n3);
        float f2 = typedArray4.getDimension(R.styleable.PolygonView_polygonStrokeWidth, this.getResources().getDimension(R.dimen.polygon_stroke_width));
        multiplePolygonsView3.strokePaint.setStrokeWidth(f2);
        multiplePolygonsView4.strokePaintOK.setStrokeWidth(f2);
        typedArray3.recycle();
    }

    private void animatePolygonFadeOut() {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.polygonAlphaAnimator = ObjectAnimator.ofInt((Object)multiplePolygonsView.strokePaint, PAINT_ALPHA_PROPERTY, (int[])new int[]{0});
        multiplePolygonsView.polygonAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                MultiplePolygonsView.this.invalidate();
            }
        });
        multiplePolygonsView.polygonAlphaAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                MultiplePolygonsView.this.polygonUpdating.set(false);
                super.onAnimationCancel(animation);
            }

            public void onAnimationEnd(Animator animation) {
                MultiplePolygonsView.this.polygonUpdating.set(false);
                super.onAnimationEnd(animation);
            }
        });
        multiplePolygonsView.polygonAlphaAnimator.setDuration(250L);
        multiplePolygonsView.polygonAlphaAnimator.start();
    }

    private void updatePath() {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.path.rewind();
        for (float[] fArray : multiplePolygonsView.listOfPoints) {
            this.path.moveTo(fArray[0], fArray[1]);
            for (int i2 = 2; i2 < fArray.length; i2 += 2) {
                this.path.lineTo(fArray[i2], fArray[i2 + 1]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColor(int fillColor) {
        void var1_1;
        boolean bl = fillColor != 0;
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.useFill = bl;
        multiplePolygonsView.fillPaint.setColor((int)var1_1);
        multiplePolygonsView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColorOK(int fillColorOK) {
        void var1_1;
        boolean bl = fillColorOK != 0;
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.useFillOK = bl;
        multiplePolygonsView.fillPaintOK.setColor((int)var1_1);
        multiplePolygonsView.invalidate();
    }

    public void setStrokeColor(int strokeColor) {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.strokePaint.setColor(strokeColor);
        multiplePolygonsView.invalidate();
    }

    public void setStrokeColorOK(int strokeColorOK) {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.strokePaintOK.setColor(strokeColorOK);
        multiplePolygonsView.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.strokePaint.setStrokeWidth(strokeWidth);
        multiplePolygonsView.strokePaintOK.setStrokeWidth(strokeWidth);
        multiplePolygonsView.invalidate();
    }

    protected void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        MultiplePolygonsView multiplePolygonsView = this;
        super.onSizeChanged(w2, h2, oldw, oldh);
        multiplePolygonsView.polygonHelper.setLayout(0, 0, w2, h2);
    }

    protected void updatePolygon(List<Polygon> polygons) {
        ObjectAnimator objectAnimator;
        if (polygons.isEmpty() && !this.listOfPoints.isEmpty()) {
            MultiplePolygonsView multiplePolygonsView = this;
            multiplePolygonsView.listOfPoints.clear();
            objectAnimator = multiplePolygonsView.polygonAlphaAnimator;
            if (objectAnimator != null) {
                objectAnimator.cancel();
                this.polygonAlphaAnimator = null;
            }
            this.animatePolygonFadeOut();
        } else {
            MultiplePolygonsView multiplePolygonsView = this;
            multiplePolygonsView.strokePaint.setAlpha(255);
            multiplePolygonsView.listOfPoints.clear();
            objectAnimator = objectAnimator.iterator();
            while (objectAnimator.hasNext()) {
                MultiplePolygonsView multiplePolygonsView2 = this;
                Polygon polygon = (Polygon)objectAnimator.next();
                float[] fArray = new float[16];
                multiplePolygonsView2.polygonHelper.polygonToPoints(polygon.getPolygonF(), fArray);
                multiplePolygonsView2.listOfPoints.add(fArray);
                if (!multiplePolygonsView2.useFill && !this.useFillOK) continue;
                this.updatePath();
            }
        }
        MultiplePolygonsView multiplePolygonsView = this;
        multiplePolygonsView.polygonUpdating.set(false);
        multiplePolygonsView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        MultiplePolygonsView multiplePolygonsView = this_;
        super.dispatchDraw(canvas);
        Paint paint = multiplePolygonsView.lastResult == DetectionResult.OK ? ((MultiplePolygonsView)((Object)this_)).fillPaintOK : ((MultiplePolygonsView)((Object)this_)).fillPaint;
        Paint paint2 = ((MultiplePolygonsView)((Object)this_)).lastResult == DetectionResult.OK ? ((MultiplePolygonsView)((Object)this_)).strokePaintOK : ((MultiplePolygonsView)((Object)this_)).strokePaint;
        boolean bl = ((MultiplePolygonsView)((Object)this_)).lastResult == DetectionResult.OK ? ((MultiplePolygonsView)((Object)this_)).useFillOK : ((MultiplePolygonsView)((Object)this_)).useFill;
        if (!((MultiplePolygonsView)((Object)this_)).listOfPoints.isEmpty()) {
            void var1_1;
            if (bl) {
                var1_1.drawPath(((MultiplePolygonsView)((Object)this_)).path, paint);
            }
            Iterator<float[]> this_ = ((MultiplePolygonsView)((Object)this_)).listOfPoints.iterator();
            while (this_.hasNext()) {
                var1_1.drawLines((float[])this_.next(), paint2);
            }
        }
    }
}

